/*****************************************************************
MissingParameter.java

GNU Lesser General Public License

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, 
version 2.1 of the License. 

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.
*****************************************************************/


package madkit.fipa.agMgmt;

import madkit.fipa.content.Predicate;

/** 
* 
* @see jade.domain.agMgmt.FIPAManagementOntology
* @author Fabio Bellifemine - CSELT S.p.A.
* @version $Date: 2004/02/15 15:46:16 $ $Revision: 1.1 $
*/

public class MissingParameter extends RefuseException implements Predicate {

  public MissingParameter() {
    this("Unkown-object", "Unknown-parameter-name"); 
  }
  
public MissingParameter(String objectName, String parameterName) {
  super("(missing-parameter "+objectName+" "+parameterName+")");
  s1=objectName;
  s2=parameterName;
}


/**
  @serial
  */
String s1,s2;
public void setObjectName(String a){s1=a; setMessage("(missing-parameter "+s1+" "+s2+")");}
public String getObjectName() {return s1;}
public void setParameterName(String a){s2=a; setMessage("(missing-parameter "+s1+" "+s2+")");}
public String getParameterName() {return s2;}


}