/**
 * ***************************************************************
 *	AbsObject.java
 * 
 * GNU Lesser General Public License
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation,
 * version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 * **************************************************************
 */
package madkit.fipa.abs;


/**
	L'anctre commun de tous les descripteurs d'objet. Un descripteur d'objet contint donc 
	le nom de l'objet qu'il dcrit
	une liste de couple attibut / valeur
  */
public interface AbsObject {
    
    // un desc doit fournir le nom de l'objet qu'il reprsente
    public String getTypeName();
    
   	//Permet de retourner la valeur associe  un attribut
    public AbsObject getAbsObject(String name);

    //  retourne le nom de chacun des attributs.
    public String[] getNames();

    
    // Grounded dfini un objet dont aucun des attibuts n'est associ  une variable
    public boolean isGrounded();

    //Le nombre d'attributs de l'objet
    public int getCount();

}

