/*
* APService.java - description of an agent plate-form service
* Copyright (C) 1998-2007 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.fipa.AMS;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

// La description d'un service de plate-forme particulier et les @ pour y acc�der
// Les eux services debase sont l'AMS et le MTP...
public class APService {

	private String name;
	private String type;
	private List addresses = new ArrayList(); 
	
	public APService() 
	{
  	}
  
  /**
   * Constructor. Create a new APService where name and type get the same value (i.e.
   * the passed type parameter).
   **/
  	public APService(String type, String[] addresses) 
  	{
    	name=type;
      	this.type=type;
      	for (int i=0; i<addresses.length; i++)
        	this.addresses.add(addresses[i]);
  	}
  
  	public void setName(String n) 
  	{
    	name = n;
  	}
  	
  	public String getName() 
  	{
    	return name;
  	}

  	public void setType(String t) 
  	{
    	type = t;
  	}
  
  	public String getType() 
  	{
    	return type;
  	}

  	public void addAddresses(String address) 
  	{
    	addresses.add(address);
  	}

  	public boolean removeAddresses(String address) 
  	{
    	return addresses.remove(address);
  	}

  	public void clearAllAddresses() 
  	{
    	addresses.clear();
  	}

  	public Iterator getAllAddresses() 
  	{
    	return addresses.iterator();
   	}

    public String toString() {
	StringBuffer str = new StringBuffer("( ap-service ");
        if ((name!=null)&&(name.length()>0))
	    str.append(" :name " + name);
        if ((type!=null)&&(type.length()>0))
	    str.append(" :type " + type);
        String s;
        str.append(" :addresses (sequence");
        for (Iterator i=addresses.iterator(); i.hasNext(); ) {
            s=(String)(i.next());
            str.append(" "+s.toString());
        }
	str.append("))");
	return str.toString();
    }


}