/*
* AMSAgentDescription.java
* Copyright (C) 1998-2007 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.fipa.AMS;


public class AMSAgentDescription {


	public static final String INITIATED = "initiated";
	public static final String ACTIVE = "active";
	public static final String SUSPENDED = "suspended";
	public static final String WAITING = "waiting";
	public static final String TRANSIT = "transit";
	
	//une entr�e contient :
	AID name ; //l'identit� de l'agent,
	String ownership ;// son propri�taire
	String state ; // l'�tat actuel de l'agent -> initiated, active, suspended, waiting, transit;
	
	public void setName(AID n)
	{
  		name = n;
	}

	public void setOwnership(String n) 
	{
  		ownership = n;
	}

	public void setState(String n) 
	{
  		state = n;
	}

	public AID getName()
	{
  		return name;
	}

	public String getOwnership()
	{
  		return ownership;
	}

	public String getState()
	{
  		return state;
	}
}