
/*
* PingPong.java - a PingPong agent in Java
* Copyright (C) 1998-2007 Olivier Gutknecht
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package madkit.demos;

import madkit.kernel.Agent;
import madkit.kernel.Message;
import madkit.kernel.MessageException;
import madkit.kernel.StringMessage;

@SuppressWarnings("serial")
public class MultiPong extends Agent
{

	final static int PLAYING=1, WAITING=2;
	private int status=2;

/** This method sets the agent to create or join a "multi-pong" group, and then registers it with a role of "player"
 */

@Override
public void activate()
{
	createGroup(true,"pong","multi-pong",null,null);
	println ("No multi-pong group : I created one");
	requestRole("pong","multi-pong","player",null);
}

@Override
@SuppressWarnings("unchecked")
public void live()
{
	while(true){
		exitImmediatlyOnKill();
		switch (status) {
		case PLAYING:
			Message m = waitNextMessage(1300);
			if(m==null){
				println("partner is gone : waiting");
				status = WAITING;
			}
			else{
				println("message from "+m.getSender()+" I reply !");
				pause(500);
				sendMessage(m.getSender(),new StringMessage("Ball"));
			}
			break;
		case WAITING:
				if(sendMessage("pong","multi-pong", "player", new StringMessage("Ball"))){
					println("I have a new partner !!");
					status=PLAYING;
				}
			 else{
				println("still nobody...");
				pause(1200);
			}
			break;
		}
	}
}

@Override
public void end()
{
	println("Bye Bye !!");
	println ("PingPong agent Ended");
}
}
