/* 
* JXTACommunicator.java - Kernel: the kernel of MadKit
* Copyright (C) 1998-2006 Mansour Saber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


package JXTACommunicator;

/** This class represents the P2P Communicator of Madkit. It is based 
		on the JXTA technology and represents another transport way.
    Each platform represented by its JXTACommunicator will belong to a
		global JXTAGroup named  "MadkitJXTACommunicatorGroup" and will 
		communicate with exisitng platforms thanks to bidirectional pipes. 
  
	@author Mansour Saber
  @version d6 - 15/09/2006 */

import madkit.kernel.*;

import java.io.*;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.*;
import net.jxta.peer.*;
import net.jxta.id.*;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.pipe.*;
import net.jxta.discovery.*;
import java.util.Vector; 
import net.jxta.endpoint.*;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.document.Advertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.StructuredDocument;
import net.jxta.impl.membership.PasswdMembershipService;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv ;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.credential.Credential;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.document.TextElement;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ModuleImplAdvertisement;
import java.net.URL;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.jxta.util.JxtaBiDiPipe;
import net.jxta.util.JxtaServerPipe;
import net.jxta.rendezvous.RendezvousEvent;

import net.jxta.rendezvous.RendezvousListener;



public class JXTACommunicator extends Agent implements PipeMsgListener,OutputPipeListener, DiscoveryListener, RendezvousListener, EndpointListener
{

        //private PeerGroup netPeerGroup = null;

				JxtaServerPipe server=null;
				JxtaBiDiPipe pipe = new JxtaBiDiPipe();
    //    private JXTAAgentPeerDiscovery discover = null;     
         
        PeerGroup netPeerGroup=null;
        PeerGroup myPeerGroup=null;  // The "MadkitJXTACommunicatorGroup" Peer Group
        PeerID pID=null;
    		static final String peerGroupName = "MadkitJXTACommunicatorGroup"; // This nam is a global and final one for all the kernels that will enter the P2P JXTA community
        static final String myGroupName ="P2PCommunicator"; // To be removed
        static final String myRoleName ="JXTACommunicator"; //   To be removed      
        final File rep = new File(System.getProperty("user.dir")); // To be finished for auto configuration
        final String home = rep +"\\JXTAConfig\\"; ///System.getenv("JXTA_HOME") ; // To be finished for auto configuration
        static final String jxtaConf = ".jxtaConfigurator"; // To be finished for auto configuration
        DiscoveryService discoSvc; // 
        boolean alive = true; 
    	  AgentAddress mykernel; // The siteAgent
 				Hashtable distantKernels = new Hashtable(); // The list of (KernelAddress, BiPipe, JXTACommunicator) allows to conect to distant kernels
				RendezVousService rendezvous = null;
				RendezVousService myJxtarendezvous = null;
				//private String rendezvousLock = "Rendezvous Lock";
		

	/**Decoding handled JXTA messages 
	 * @param msg the received message to decode
	 * @param element the attribut used to extract the message
	 */
 Object decode(net.jxta.endpoint.Message msg, String element) throws IOException, ClassNotFoundException
 {				
			 byte[] bytes = msg.getMessageElement(element).getBytes(false);
       ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
       Object a = (Object) in.readObject();
       in.close();
       return a;                		
 }
	/**Encoding JXTA messages that will be send
	 * @param name the attribut of the message to encode
	 * @param o the message to send
	 */
 ByteArrayMessageElement encodeMessage(String name, Object o)
 {
    byte [] b=null;
    try
    {
    	b = Codec.encode(o);
    }
    catch (Exception er)  
    { 
    	System.err.println("Error in serializedObject : "); er.printStackTrace(); 
    }
    MimeMediaType asMType = new MimeMediaType("text/xml");
    
    ByteArrayMessageElement messageElem = new ByteArrayMessageElement(name, asMType , b, null);
    return(messageElem);
}

	/**Sending distant JXTA messages with a default attribut : "Message"
	 * @param m the message to send
	 * @param distKernel the receiver distant kernel 
	 */
		
void sendDistantMessage(madkit.kernel.Message m, KernelAddress distKernel)
{
	String attribut = "Message";
	sendDistantMessage(attribut,m, distKernel);
}

	/**Sending distant JXTA messages with a default attribut : "Message"
	 * @param attribut the name of the attribut will be used to extract the message in the decode phase
	 * @param m the message to send
	 * @param distKernel the receiver distant kernel 
	 */
		
void sendDistantMessage(String attribut,madkit.kernel.Message m, KernelAddress distKernel)
{
	try
	{	
		Object jxtaInf = distantKernels.get(distKernel.toString());
	
		if(jxtaInf!=null)
		{
	/*
	 *  Process rendezvous connection events from the rendezvous service listener
	 */
			JxtaBiDiPipe bidi = (JxtaBiDiPipe)((Vector)jxtaInf).firstElement();
			net.jxta.endpoint.Message msg = new net.jxta.endpoint.Message();
			PipeService pipeService = myPeerGroup.getPipeService();
			StringMessageElement sme = new StringMessageElement("Content",attribut,null);
			msg.addMessageElement(null,sme);			
			ByteArrayMessageElement msgElem= encodeMessage("Message",m);
			msg.addMessageElement("Message",msgElem);
			bidi.sendMessage(msg);	
		}
		else
			System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! unkown distant kernel");
	}
	catch(Exception e)
	{
		System.err.println("Error while sending a distant Agent with JXTACommunicator : "+e.toString());
	}
}

	 /**Process rendezvous connection events from the rendezvous service listener
	 * @param event the handled RendezVous event
	 */

	/*public synchronized void rendezvousEvent(RendezvousEvent event) {
		if (event.getType() == event.RDVCONNECT ||
			event.getType() == event.RDVRECONNECT ) {
			notify();
		}
	}
	*/
public void rendezvousEvent(RendezvousEvent rdvEvent) {
    // TODO Auto-generated method stub

    System.out.print("\nEvent peer: " + rdvEvent.getPeer() + ": ");

    switch(rdvEvent.getType()){
    case RendezvousEvent.BECAMEEDGE: System.err.println("BECAMEEDGE");
break;
    case RendezvousEvent.BECAMERDV: System.err.println("BECAMERDV"); break;
    case RendezvousEvent.CLIENTCONNECT: System.err.println("CLIENTCONNECT");
break;
    case RendezvousEvent.CLIENTDISCONNECT:
System.err.println("CLIENTDISCONNECT");
break;
    case RendezvousEvent.CLIENTFAILED: System.err.println("CLIENTFAILED");
break;
    case RendezvousEvent.CLIENTRECONNECT:
System.err.println("CLIENTRECONNECT");
break;
    case RendezvousEvent.RDVCONNECT: System.err.println("RDVCONNECT");
break;
    case RendezvousEvent.RDVDISCONNECT: System.err.println("RDVDISCONNECT");
break;
    case RendezvousEvent.RDVFAILED: System.err.println("RDVFAILED"); break;
    case RendezvousEvent.RDVRECONNECT: System.err.println("RDVRECONNECT");
break;
    default: System.err.println("Rdv even can't be defined");
    }
  } 
	/**The intial state of the agent. Cleaning the local Cash, try to connect to a RendezVous, Join the netPeerGroup,
	 * searching for "MadkitJXTACommunicatorGroup", join the group, send advertisement and wait for connections to establish
	 */
		
public void activate()
{  

			try
			{
						if(startJxta())
						{
								getLocalAdvGroups(netPeerGroup);
								clean(netPeerGroup,null,null);
								getLocalAdvGroups(netPeerGroup);
								

								/*
								 * Extracting the RDV service
								 */
								

								netPeerGroup.getRendezVousService().startRendezVous();
								
								/*
								 * Register a RDV service listener for RDV events. We are
								 * looking for a RDV connect event to let us know that we
								 * connected to the peer
								 */
								rendezvous = netPeerGroup.getRendezVousService();
								rendezvous.addListener(this);
								int maxWaitTime = 30;
								int j =0;
								int autoRendezvousTimeout = 1000;
								
								while (rendezvous.isRendezVous()==false  )//|| rendezvous.isConnectedToRendezVous()==false) 
								{
				            System.out.println("Waiting for Rendezvous Connection"+rendezvous.isRendezVous()+" et je suis connect  moi meme : "+rendezvous.isConnectedToRendezVous());
				            try 
										{
										 		Thread.sleep(2000);
				               /* synchronized(rendezvousLock) 
												{
				                    rendezvousLock.wait(autoRendezvousTimeout);
				                }
												*/
				            } 
										catch (Exception e) 
										{
											System.out.println("EROOOOOOOOOOOORRR RENDEZVOUS CONNECTION"+e.toString());
				            }
				        }								
								System.out.println("Left successfully Rendezvous Connection"+rendezvous.isRendezVous()+" et je suis connect  moi meme : "+rendezvous.isConnectedToRendezVous());

								/*
								 * Wait for the RDV connection event
								 /
									
									 while (! rendezvous.isConnectedToRendezVous() && j<maxWaitTime) 
									 { 
										 try 
											{ 
						              pause(4000);
											    System.out.println("Waiting for NetPeerGroup Rendezvous Connection "+j);
						          } 
											catch (Exception e) 
											{
						              // System.out.println("Waiting for NetPeerGroup Rendezvous Connection");
														// nothing, keep going
						          }
											j++;
					        }
									if (!rendezvous.isConnectedToRendezVous()) 
									{
										System.out.println("Error Connecting to the NetPeergroup Rendezvous");
										rendezvous.removeListener(this);
									}
									else
										System.out.println("Successfully Connected to the NetPeergroup Rendezvous "+j);
								*/		
								//int maxWaitTime = 30;
								PeerGroupAdvertisement pgA = getPeerGroupAdvertisement(netPeerGroup,peerGroupName, maxWaitTime * 1000);
							  if(pgA!=null)
								{		
									myPeerGroup=createGroup(pgA);
									System.err.println("PeerGroupFound "+pgA.toString());
								}
								else
									myPeerGroup=createGroup(netPeerGroup,peerGroupName);
										
								if(myPeerGroup!=null)
								{
										joinPeerGroup(myPeerGroup);
										System.err.println("\n\t****************************PeerGroupAdvvvvvv**************************** \n\t"+myPeerGroup.getPeerGroupAdvertisement().toString());
										println("Communicator Activated");
										requestRole("public","system","communicator",null);
										mykernel = getAgentWithRole("communications","site");
										if(mykernel!=null)
											sendMessage(mykernel, new NetworkRequest(NetworkRequest.BE_COMMUNICATOR));
										else
											System.err.println("Error while searching the SiteAgent");
										
										System.err.println("We create the server");
										discoSvc=myPeerGroup.getDiscoveryService();
										discoSvc.addDiscoveryListener(this);								
										String mobility ="0" ;
										if(getAddress().getKernel().supportMobility())
											mobility ="1";										
										String strSite = 	mykernel.getName()+","+String.valueOf(mykernel.getLocalID())+"@"+mykernel.getKernel();
										String strKernel = getAddress().getKernel().getHost()+":"+getAddress().getKernel().getID()+":"+getAddress().getKernel().getKernelName()+":"+mobility+"&"+strSite;
										myPeerGroup.getPeerAdvertisement().setName(strKernel);
										
										myPeerGroup.getRendezVousService().startRendezVous();
								
								/*
								 * Register a RDV service listener for RDV events. We are
								 * looking for a RDV connect event to let us know that we
								 * connected to the peer
								 */										
										myJxtarendezvous = myPeerGroup.getRendezVousService();
										myJxtarendezvous.addListener(this);
										
										
									//int		j =0;
											 	while (! myJxtarendezvous.isConnectedToRendezVous() && j<maxWaitTime) 
											 	{ 
														try 
														{ 
									              pause(500);
														    System.out.println("Waiting for MyJXTA Rendezvous Connection");
									          } 
														catch (Exception e) 
														{
									             //  System.out.println("Waiting for NetPeerGroup Rendezvous Connection");
																	// nothing, keep going
									          }
														j++;
								        }
									//			
										if (!myJxtarendezvous.isConnectedToRendezVous()) 
										{
											System.out.println("Error Connecting to the MyJXTA Rendezvous");
										}						
										else
											System.out.println("Connected to MyJXTA Rendezvous");
										server= createBiDiPipeServer(myPeerGroup,"Pipe1"+netPeerGroup.getPeerName(),1000);
								}
							}
					}
					catch(Exception e)
					{
							System.err.println("ERRRRRRRRRRRRRRRRRRRRr"+e.getMessage());
					}
}

        
/**
* Constructor
*
*/
public JXTACommunicator() 
{


}

//public JXTACommunicator(boolean init) {}

/** Run a Peers **/




public void live()
{       
			while(true)
      {
						try
						{
	//							System.err.println("-------->  Server Waiting for connexions");
								JxtaBiDiPipe bipipe = server.accept();
								if(bipipe!=null)
								{
									String str = bipipe.getRemotePeerAdvertisement().getName();
									int index = str.indexOf("&");											
									String strSiteAddress = str.substring(index+1);
									String strKernelAddress = str.substring(0, index);
									AgentAddress addSiteAgent = new AgentAddress("mka:"+strSiteAddress);									    											
									KernelAddress ka = new KernelAddress(strKernelAddress);
									Vector v = new Vector(3);
									v.add(bipipe);
									v.add(addSiteAgent);
									v.add(new Boolean(false));
									distantKernels.put(addSiteAgent.getKernel().toString(),v);									
									System.err.println("We added the new Kernel successfully ;) "+ka.toString());
									bipipe.setListener(this);
								}
								else
									System.err.println("Server is not up!!!");	
						}
						catch(Exception e)
						{
						//	System.err.println("Error when listening for new JXTA Connexions");
						}	
		//				System.err.println("<--------  Agent Waiting for connexions");
						madkit.kernel.Message m=waitNextMessage(1000);
						exitImmediatlyOnKill();
						if (!alive) return;
						if (m instanceof KernelMessage)
					    	handleMessage((KernelMessage)m);
						else if (m instanceof NetworkRequest)
							handleMessage((NetworkRequest)m);
						else if (m instanceof StringMessage)
						
						
						//	handlePersonalMessage((StringMessage) m);

						System.err.println("YES i m listening man");
/*						System.err.println("Group Creation : "+createGroup(true,myGroupName+i,"Sahar"+i,null));	
						System.err.println("Role playing : "+requestRole(myGroupName+i,myRoleName+i,null));
						
						i++;
	*/					
      }
}

	/**Search for local PeerGroupAdv related to the PeerGroup pG
	 * @param pG the PeerGroup we will search PGAdv in
	 */
		
    public void getLocalAdvGroups(PeerGroup pG)
		{
						System.out.println("--- local cache (Peer Groups) ---");
						try 
						{
				 				PeerGroupAdvertisement adv = null;
								Enumeration en = pG.getDiscoveryService().getLocalAdvertisements(
								pG.getDiscoveryService().GROUP, null, null);
								if (en != null) 
								{
										while (en.hasMoreElements()) 
										{
											adv = (PeerGroupAdvertisement) en.nextElement();		
											System.out.println(adv.getName() + ", group ID = " + adv.toString());
										}	
								}
						}		
						catch (Exception e) {}
						System.out.println("--- end local cache ---");
		}

	/**Search for PeerGroupAdv having name the parameter name
	 * @param name the PeerGroupName we will search 
	 */
		
 		public PeerGroupAdvertisement getGroup(String name)
		{
			try
			{
				discoSvc.flushAdvertisements(null,DiscoveryService.GROUP)	;
				discoSvc.getRemoteAdvertisements(null,DiscoveryService.GROUP,null,name,5);
				return null;
			}
			catch(Exception e)
			{
				System.out.println("IL n'y a pas de grouppppppess"+e.getMessage());
				return null;
			}			
		}       
        
				
				public static  void main (String argv[])
				{
					JXTACommunicator jxta = new JXTACommunicator();
				//	jxta.startJxta();//System.err.println(jxta.monFichier);
					jxta.activate();
				}
      

		public void pipeMsgEvent(PipeMsgEvent event) 
		{
			try 
			{
				net.jxta.endpoint.Message msg = event.getMessage();
				System.out.println("Message reu "+msg.toString());
				System.out.println("The received message is  : "+msg.getMessageElement("Content").toString());
				
/*				if(msg.getMessageElement("Content").toString().equals("Connexion")) // To replace with a case of and a int code for messageTypes 
				{							
							KernelAddress ka = (KernelAddress) decode(msg,"KernelAddress");
							AgentAddress distantSiteAgent = (AgentAddress) decode(msg,"SiteAgentAddress");
							PeerID pAdID = (PeerID) decode(msg,"PeerAdvetisementID");							
							System.err.println("Sending the answer and wait	 a few seconds before doing it"+event.getPipeID());			

							if(tempBiDiPipeList.get(event.getPipeID())!=null)
							{
										System.err.println("The Connexion alwayas started and now we finish it");		 								
										JxtaBiDiPipe bidi = (JxtaBiDiPipe) tempBiDiPipeList.get(event.getPipeID());
										tempBiDiPipeList.remove(event.getPipeID());
										System.err.println("Le kernel est  : "+ka.toString());
										System.err.println("Le PeerID est  : "+pAdID.toString());
										Vector v = new Vector(2);
										v.add(bidi);
										v.add(pAdID);
										v.add(msg.getMessageElement("PeerAdvertisement"));	
										distantKernels.put(ka,v);
										System.err.println("We added the new Kernel successfully ;) ");			
        		        sendMessage(mykernel, new NetworkRequest(NetworkRequest.CONNECTION_REQUEST, distantSiteAgent));	
										net.jxta.endpoint.Message	message = createConnexionMessage();
										bidi.sendMessage(message);
										System.err.println("We send a response to connect our kernel to the new connected kernel :) ");			
								}
								else
								{
										System.err.println("Unknown distant Kernel trying to connect!!!");
								}

				}
				
else */ 
				if(msg.getMessageElement("Content").toString().equals("Message")) 
				{	
							madkit.kernel.Message message = (madkit.kernel.Message) decode(msg,"Message");	
							sendMessage(mykernel,new NetworkRequest(NetworkRequest.INJECT_MESSAGE, message));
							System.err.println("A distant Message Received we inject it to our kernel "+message.toString());						
				}
				else if(msg.getMessageElement("Content").toString().equals("ConnectionMessage")) 
				{	
							madkit.kernel.Message message = (madkit.kernel.Message) decode(msg,"Message");	// We decode the JXTA message and extract the Madkit one
							Set set = distantKernels.keySet(); // We get the keys of the distantKernels in order to fetch for the conencted one sending this connection message
							boolean found = false; // In order to optimize the research time for the distant kernel (time is money :)) )
							Iterator i = set.iterator();
							while (i.hasNext()&& found==false)
							{
								// KernelAddress distantKernel = (KernelAddress)i.next();
								 String distantKernel = (String)i.next();
								 AgentAddress siteAgent = (AgentAddress)((Vector)distantKernels.get(distantKernel)).get(1);	
								 if(siteAgent.equals(message.getSender()))
								 {
										Vector v = (Vector)distantKernels.get(distantKernel); // we get it			
										//boolean isConnected = ((Boolean)v.get(2)).booleanValue();
										System.err.println("isConnected : "+((Boolean)v.get(2)).booleanValue());
										if(!((Boolean)v.get(2)).booleanValue())
										{			
													System.err.println("'''''''''''''''''''''''''''''''Updating the old connexion  : '''''''''''''''''''''''''"+event.getPipeID());
													siteAgent = message.getSender();
													v.set(2,true);													
												v.set(1, message.getSender());
													distantKernels.remove(distantKernel); // we remove the old (incorrect input)
													distantKernels.put(message.getSender().getKernel().toString(),v); // we replace it with the new one :)
													System.err.println("DistantKernel already existing : "+distantKernels.containsKey(message.getSender().getKernel()));																															
													found=true;
													if (isGroup(myGroupName))
													{
														  println("Yeah ! I join");
				 									}
								 					else
				 							 		{
															println("Create MadkitCommunicatorGroup");
															createGroup(true,"JXTAComm",myGroupName,"JXTAAgentService",null);
				 							 		}
													requestRole("JXTAComm",myGroupName,myRoleName,null);
													
											}
//											sendMessage(mykernel, new NetworkRequest(NetworkRequest.CONNECTION_REQUEST, siteAgent));
											sendMessage(mykernel,new NetworkRequest(NetworkRequest.INJECT_MESSAGE, message));											
								 	}									
								}									
								
							/* We compare thanks to String conversion ;) this is the best :)) In Fact we optimize a one-to-n and n* 
							 * message transfer by including kernels informations via PipeAdv (for servers) and PeerAdv for clients
							 * See createBiDiPipeServerServer	  and activate for more information about the mechanism :)) 
							 / 
								System.err.println("Site agent found and the site agent sending the connection msg are equal? "+siteAgent.toString()+"||||||"+message.getSender()+"////////"+(siteAgent==message.getSender())+"//"+siteAgent.equals(message.getSender()));
									if(siteAgent!=message.getSender() && siteAgent.getKernel().toString().equals(message.getSender().getKernel().toString())) // we found the distantKernel
									{
												System.err.println("'''''''''''''''''''''''''''''''Updating the old connexion  : '''''''''''''''''''''''''"+event.getPipeID());																				
												Vector v = (Vector)distantKernels.get(distantKernel); // we get it
												v.remove(1);
												v.add(1, message.getSender());
												distantKernels.remove(distantKernel); // we remove the old (incorrect input)
												distantKernels.put(message.getSender().getKernel(),v); // we replace it with the new one :)
												System.err.println("DistantKernel already existing : "+distantKernels.containsKey(message.getSender().getKernel()));							
												
												found=true;
		     								sendMessage(mykernel, new NetworkRequest(NetworkRequest.CONNECTION_REQUEST, message.getSender()));
												if (isGroup(myGroupName))
											  {
													  println("Yeah ! I join");
			 									}
							 					else
			 							 		{
														println("Create MadkitCommunicatorGroup");
														createGroup(true,"JXTAComm",myGroupName,"JXTAAgentService",null);
		  				   				}
						  				   requestRole("JXTAComm",myGroupName,myRoleName,null);	
									}							
								}
								*/
						
				}
				else if(msg.getMessageElement("Content").toString().equals("MobilityEnabled")) 
				{
					NetworkRequest message = (NetworkRequest) decode(msg,"Message");	// We decode the JXTA message and extract the Madkit one
					KernelAddress ka = (KernelAddress)message.getArgument();
					if(distantKernels.containsKey(ka.toString()))
					{							
						System.err.println("Traitement mobilit activ reu : "+ka.getKernelName());
						//Vector v = (Vector)distantKernels.get(message.getString());
						//v.get
						sendMessage(getAgentWithRole("system","AgencyKeeper"),new NetworkRequest(NetworkRequest.ENABLE_MOBILITY,ka));					
					}					
				}
				else if(msg.getMessageElement("Content").toString().equals("MobilityDisabled")) 
				{
					NetworkRequest message = (NetworkRequest) decode(msg,"Message");	// We decode the JXTA message and extract the Madkit one
					KernelAddress ka = (KernelAddress)message.getArgument();
					if(distantKernels.containsKey(ka.toString()))
					{							
						System.err.println("Traitement message de deconnexion reu 1");
						//Vector v = (Vector)distantKernels.get(message.getString());
						//v.get
						sendMessage(getAgentWithRole("system","AgencyKeeper"),new NetworkRequest(NetworkRequest.DISABLE_MOBILITY,ka));					
					}					
				}
				else if(msg.getMessageElement("Content").toString().equals("DisconnectionMessage")) 
				{	
				
					madkit.kernel.StringMessage message = (madkit.kernel.StringMessage) decode(msg,"Message");	// We decode the JXTA message and extract the Madkit one
					if(message!=null)
						System.err.println("Un message de deconnexion reu"+message.getString());
					else
						System.err.println("EROOOOOOOOOOOOORRRRRRRR");
					if(distantKernels.containsKey(message.getString()))
					{							
						System.err.println("Traitement message de deconnexion reu 1");
						Vector v = (Vector)distantKernels.get(message.getString());
						System.err.println("Traitement message de deconnexion reu 2");
						AgentAddress siteAdd = (AgentAddress)v.get(1);
						System.err.println("Traitement message de deconnexion reu 3");
						sendMessage(mykernel, new NetworkRequest(NetworkRequest.DECONNECTED_FROM, siteAdd.getKernel().getID()));					
						System.err.println("Traitement message de deconnexion reu 4");
						distantKernels.remove(message.getString());						
						System.err.println("Traitement message de deconnexion reu 5");
					}
					
  				if(hasGUI()) 
					{
  					// System.out.println("Removing remote kernel infos");
  					//agentGUI.removeText(ka.toString());
					}
				} 

			}	
			catch (Exception e) 
			{
				e.printStackTrace();
				return;
			}
		}
		
		public OutputPipe createOutPutPipe(PeerGroup pG,PipeAdvertisement pipeAdv)
		{
			if(pG==null)
			System.err.println("NNNNNNNNNNNNNNNNNNNNOOOOOOOOOOOOOOOOOOOOOOOOOONNNNNNNNNNNNNN");
			PipeService pipeService = pG.getPipeService();
			OutputPipe out;
			try
			{
				System.out.println("Creating the Pipe :  "+pipeAdv.toString());
				out = pG.getPipeService().createOutputPipe(pipeAdv,//pipe adv
                                                     1000); //timeout
				try
				{	
					DiscoveryService discoSvc = pG.getDiscoveryService();
					discoSvc.publish(out.getAdvertisement(), DiscoveryService.ADV);
					discoSvc.remotePublish(out.getAdvertisement(), DiscoveryService.ADV);
				}
				catch(Exception err)
				{
					err.getStackTrace();
				}

			return out;
			}
			catch(Exception e)
			{
				System.err.println("ERRRRR OutPutPipe ne peut etre cr dans ce temps");	
				try
				{
					pG.getDiscoveryService().flushAdvertisement(pipeAdv);				
				}
				catch(Exception error)
				{
				}
				return null;
			}
			/**
    	 * Publier l'advertisement pour que les autres peers soient au courant du Pipe
		   */

		}
		
		public void outputPipeEvent(OutputPipeEvent ev) 
		{
			//System.out.println("PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP");
			try
			{	
					OutputPipe outPutPipe = ev.getOutputPipe();
			}
			catch(Exception e)
			{
				System.err.println("ERRRRR OutPutPipe ");	
			}
		}
		
		public 	net.jxta.endpoint.Message createConnexionMessage()
		{
			 try
			 {	
					String msg="Connexion";
					PipeService pipeService = myPeerGroup.getPipeService();
					net.jxta.endpoint.Message message = pipeService.createMessage();
					//		 Configure the message object.
					StringMessageElement sme = new StringMessageElement("Content", msg, null);
					message.addMessageElement(null,sme);
					////////
					ByteArrayMessageElement msgKernelAddress = encodeMessage("KernelAddress",getAddress().getKernel());
					ByteArrayMessageElement msgDistantAddress = encodeMessage("SiteAgentAddress",mykernel);
					ByteArrayMessageElement msgPeerAdvertisementID = encodeMessage("PeerAdvetisementID",myPeerGroup.getPeerAdvertisement().getPeerID());								
					message.addMessageElement("KernelAddress",msgKernelAddress);
					message.addMessageElement("SiteAgentAddress",msgDistantAddress);
					message.addMessageElement("PeerAdvertisementID",msgPeerAdvertisementID);
					return  message;
				}
				catch (Exception e)
				{
					System.err.println("Error while creating the connexion Message"+e.toString());	
					return null;
				}
		}
		
		public void discoveryEvent(DiscoveryEvent ev) 
		{
			DiscoveryResponseMsg res = ev.getResponse();
			String name = "unknown";
			// Get the responding peer's advertisement
			PeerAdvertisement peerAdv = res.getPeerAdvertisement();
		//	name= peerAdv.getName();
			System.err.println("ADVVVVVVVV!!!!!!!!!!!!!!!!!!!!!!!"+name);		
			Advertisement adv = null;
			Enumeration enume = res.getAdvertisements();
			if (enume != null ) 
			{
				while (enume.hasMoreElements()) 
				{
					adv = (Advertisement)enume.nextElement();	
					if(adv.getAdvType().equals("jxta:PipeAdvertisement"))
					{			
						System.err.println("PIPEEEEE!!!!!!!!!!!!!!!!!!!!!!!"+name+" : "+((PipeAdvertisement)adv).getDescription());
						PipeAdvertisement pA=(PipeAdvertisement)adv;
						String str = pA.getDescription();
						JxtaBiDiPipe biPipe= createBiDiPipeClient(myPeerGroup,pA);
					  
						if (biPipe==null)
							System.err.println("connexion with distant BiPipeServer failed");
						else
						{
							try 
							{
								// Even if the tempBiDiPipeList already contains the bidipipe it will be replaced ;)
							//	System.err.println("Sending the answer and wait	 a few seconds before doing it"+biPipe.getPipeAdvertisement().getDescription());											
									
									System.err.println("We create the BiPipeClient successfully"+pA.getDescription());		
									int index = str.indexOf("&");											
									String strSiteAddress = str.substring(index+1);
									String strKernelAddress = str.substring(0, index);
									AgentAddress addSiteAgent = new AgentAddress("mka:",strSiteAddress);									    																				
									KernelAddress ka = new KernelAddress(strKernelAddress);
									Vector v = new Vector(3);
									v.add(biPipe);
									v.add(addSiteAgent);			
									v.add(new Boolean(false));
									distantKernels.put(addSiteAgent.getKernel().toString(),v);									
									System.err.println("We added the new Kernel successfully ;) "+ka.toString());
									biPipe.setListener(this);
									sendMessage(mykernel, new NetworkRequest(NetworkRequest.CONNECTION_REQUEST, addSiteAgent));
									
									//String attribut = "Message";
									net.jxta.endpoint.Message msg = new net.jxta.endpoint.Message();
									PipeService pipeService = myPeerGroup.getPipeService();
									//StringMessageElement sme = new StringMessageElement("Content",attribut,null);
									//msg.addMessageElement(null,sme);		
									
									StringMessageElement sme = new StringMessageElement("Content", pA.getName(), null);
									msg.addMessageElement(null,sme);									
									
								///	ByteArrayMessageElement msgElem= encodeMessage("NewConnexion",adv);
								//	msg.addMessageElement("Message",msgElem);
									System.err.println("\nOn va propager les messages dans le groupe !!!!!!!!!!!!!!\n");
									myJxtarendezvous.propagateInGroup(msg, "NewConnection", "NewConnection", 60000);
																		 
									 //listener.
//								net.jxta.endpoint.Message	message = createConnexionMessage();
//								bidi.sendMessage(message);
								//net.jxta.endpoint.Message message = createConnexionMessage();	
/*								if(message!=null)
								{
									//tempBiDiPipeList.put(pA.getID(),biPipe);		
									biPipe.sendMessage(message);
								}
								else
								{
									System.err.println("ERRRRRRRRRRRRRRROR creating the connexion message!!");
								}
*/
								
							} 
							catch (Exception e) 
							{
								System.err.println("ERRRRRRRRRRRRRRROR sending message throughout BidiPipe"+e.toString());
								return;
							}
							
						}
					//	createOutPutPipe(pA);
					}
					else if(adv.getAdvType().equals("jxta:PGA"));
								//System.err.println("GROUPE"+adv.toString());
					else if(adv.getAdvType().equals("jxta:PA"))
					{	
								System.err.println("Le nom du PEER dcouvert est "+((PeerAdvertisement)adv).getName());
					}
					else;
						//		System.err.println("eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee");
					 
				//	System.out.println (" Peer name = " + adv.toString());
				}
			}
	}
	public void processIncomingMessage(Message msg, EndpointAddress ad1, EndpointAddress ad2)
	{
		System.err.println("Messsssssssssagggeee reu en propagation"+msg);
	}
		
    public boolean broadcast(PeerGroup pg, net.jxta.endpoint.Message msg) throws Exception
    {
        PipeAdvertisement pipe[] = getPipeAdvertisements(pg);
	
	if(pipe == null || pipe.length == 0)
	{
	    System.err.println("broadcast: No one to broadcast to");
	   return false;
	}
        System.err.println("Found some people to broadcast to");
        
	PipeAdvertisement pAdv;
	Advertisement a;

       
        for(int i =0; i < pipe.length; i++)
				{
           if(pipe[i]!=null)
					{	System.err.println("Sending message to " + pipe[i]);
            try {
                OutputPipe out=createOutPutPipe(pg,pipe[i]);
								sendMessage(out,msg);
            }catch(Exception e){
                e.printStackTrace();
            }
					}
        }
        return true;
    }
    
  public boolean broadcast(PeerGroup pg, String msg) throws Exception
	{
		PipeService pipeService = pg.getPipeService();
		net.jxta.endpoint.Message message = pipeService.createMessage();
		//		 Configure the message object.

		StringMessageElement sme = new StringMessageElement("Content", msg, null);
		message.addMessageElement(null,sme);
		return(broadcast(pg,message));
	}
    public PipeAdvertisement[] getPipeAdvertisements(PeerGroup pg) throws Exception
    {
			/* this returns all the pipes in the current Group*/
			Vector v = new Vector();
			Enumeration e = searchGeneric(pg, null, null, 
			DiscoveryService.ADV,100, 5);
			if((e == null) || !e.hasMoreElements())
			{
            System.err.println("Didnt find any pipe advertiseemnts");
            return null;
			}
			PipeAdvertisement pAdv = null;
			while(e.hasMoreElements())
			{
            Object obj = e.nextElement();
            try 
						{
                pAdv = (PipeAdvertisement) obj;
                v.addElement(pAdv);
                System.err.println("Found " + pAdv.getName());
						}
						catch(Exception ex)
						{
                System.err.println("Found non-pipe adv ");
             //   Advertisement adv = (Advertisement) obj;
            }
 	}
	//convert the vector to a string array
	PipeAdvertisement[] ret = new PipeAdvertisement[v.size()];
	ret = (PipeAdvertisement [])v.toArray(ret);
        v = null;
	return ret;
    }
		private void sendMessage(OutputPipe out,String msg)
		{
			PipeService pipeService = netPeerGroup.getPipeService();
			net.jxta.endpoint.Message message = pipeService.createMessage();
			//		 Configure the message object.

			StringMessageElement sme = new StringMessageElement("Content", msg, null);
			System.err.println("Sending the message");

			message.addMessageElement(null,sme);
			if (out != null)
			{
				try
				{
				//Envoyer le message.
					out.send(message);
				}
				catch (Exception e)
				{

				}
			}
			else
			{
				System.err.println("Erreur L'OutputPipe est nul ??");
			}
		}
		
		private void sendMessage(OutputPipe out,net.jxta.endpoint.Message msg)
		{
			if (out != null)
			{
				try
				{
				//Envoyer le message.
					out.send(msg);
				}
				catch (Exception e)
				{

				}
			}
			else
			{
				System.err.println("Erreur L'OutputPipe est nul ??");
			}
		}
		public InputPipe createInPutPipe(PeerGroup pg, String pipeName)
		{
			/**
			 * Cration de l'advertisement
			 */
			InputPipe inPipe=null;
			PipeService myPipe = pg.getPipeService();
			PipeAdvertisement pipeAdv =(PipeAdvertisement)AdvertisementFactory.newAdvertisement
			(PipeAdvertisement.getAdvertisementType());
				pipeAdv.setName(pipeName);
				pipeAdv.setType("JxtaUnicast");
				pipeAdv.setPipeID((ID) net.jxta.id.IDFactory.newPipeID(pg.getPeerGroupID())
			);
			/**
			 * Cration du Pipe  partir de l'advertisement ralis
			 */	
				try
				{
					 inPipe= myPipe.createInputPipe(pipeAdv, this);
				}
				catch(Exception e)
				{
					System.err.println("Error : "+inPipe);
				}
				/**
				 * Publier l'advertisement pour que les autres peers soient au courant du Pipe
				 */
				try
				{	
					DiscoveryService discoSvc = pg.getDiscoveryService();
					discoSvc.publish(pipeAdv, DiscoveryService.ADV);
					discoSvc.remotePublish(pipeAdv, DiscoveryService.ADV);
				}
				catch(Exception e)
				{
					e.getStackTrace();
				}
				return inPipe;
		}
		
		public boolean startJxta() 
		{
			System.err.println("JXTA Started : Peer Behavior activated");
			try 
			{
				netPeerGroup = PeerGroupFactory.newNetPeerGroup();
				discoSvc = netPeerGroup.getDiscoveryService();
				System.out.println(" Peer name = " + netPeerGroup.getPeerName());	
				discoSvc.addDiscoveryListener(this);
				return true;
	//			System.out.println("Error Detected and the proposed errorOrigin is : "+Cause);
			} 
			catch (Exception e) 
			{
				System.out.println("ERRRRRRRRRRRRRRRRRRRRRReur"+e.getMessage());
				return false;
			}
		}


	 public Enumeration searchGeneric(PeerGroup pg, String attr, String name, int type, int no, int timeout) throws Exception 
	 {
			Enumeration enumAdvs = null;
	    DiscoveryService discovery = pg.getDiscoveryService();
			discovery.addDiscoveryListener(this);
	    enumAdvs = discovery.getLocalAdvertisements(type,
	                                                attr, name);
	
	    if (enumAdvs.hasMoreElements() && name != null) 
			{
	      return enumAdvs;
	    }
	   
			discovery.getRemoteAdvertisements(null, type, attr, name, no, null);
	    System.err.println("We are waiting");   
			Thread.sleep(timeout);
	
			enumAdvs = discovery.getLocalAdvertisements(type,attr, name);
	    return enumAdvs;
  }

		
private static boolean configured(File home) {
        //// System.out.println("This is my FIle Home " + home);
        File platformConfig = new File(home+"\\"+jxtaConf +"\\", "PlatformConfig");
        return platformConfig.exists();
    }


    /**
     *  Creates a PlatformConfig with peer name set to name
     *
     *@param  home  node jxta home directory
     *@param  name  node given name (can be hostname)
     */
    private static void createConfig(File home, String name) {
        try {
           // FileInputStream is = new FileInputStream(home+"\\"+jxtaConf +"\\" + "PlatformConfig.master");
					  InputStream is = getResourceInputStream("PlatformConfig.master");
						home.mkdirs();
						PlatformConfig platformConfig = (PlatformConfig) AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, is);
						is.close();
			   		platformConfig.setName(name);
            File newConfig = new File(home+"\\"+jxtaConf +"\\", "PlatformConfig");
            OutputStream op = new FileOutputStream(newConfig);
            StructuredDocument doc = (StructuredDocument) platformConfig.getDocument(MimeMediaType.XMLUTF8);
            doc.sendToStream(op);
            op.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

		/**
     *  returns a resource InputStream
     *
     *@param  resource         resource name
     *@return                  returns a resource InputStream
     *@exception  IOException  if an I/O error occurs
     */
    private static InputStream getResourceInputStream(String resource) throws IOException {
        ClassLoader cl = ClassLoader.class.getClassLoader();
				return cl.getResourceAsStream(resource);
    }
		
				public void clear(PeerGroup pG)
		{
			
				try
				{
					DiscoveryService disc = pG.getDiscoveryService();
					disc.flushAdvertisements(null, DiscoveryService.PEER);
					disc.flushAdvertisements(null, DiscoveryService.GROUP);
					disc.flushAdvertisements(null, DiscoveryService.ADV);
				}
				catch (IOException e) 
				{
						System.out.println(e.toString());
				}
			
		}
		
				 public void cleanPipes(PeerGroup pG)
	 	 {
			try 
			{
				DiscoveryService discovery = pG.getDiscoveryService();
				Enumeration en = discovery.getLocalAdvertisements(DiscoveryService.ADV, null, null);
        while (en.hasMoreElements()) 
				{
						Advertisement adv = (Advertisement) en.nextElement();
						if(adv.getAdvType().equals("jxta:PipeAdvertisement"))
							discovery.flushAdvertisement(adv);
        }
      } 
			catch (IOException io) 
			{
       io.printStackTrace();
   		} 
			
			
			
		 }

		
		 public void clean(PeerGroup pG,String key,String value)
	 	 {
			try 
			{
						DiscoveryService discovery = pG.getDiscoveryService();
						Enumeration en = discovery.getLocalAdvertisements(DiscoveryService.GROUP, key, value);
		        while (en.hasMoreElements()) 
						{
								Advertisement adv = (Advertisement) en.nextElement();
								discovery.flushAdvertisement(adv);
		        }
		      } 
					catch (IOException io) 
					{
		       io.printStackTrace();
		   		} 
	  	}
			
			
public PeerGroup createSecurePeerGroup(PeerGroup nowGroup, String groupName,String login, String passwd)
{
		PeerGroupID mySecurePeerAgentsGroupID=null;
		final String GROUPID = "jxta:uuid-4d6172676572696e204272756e6f202002";
				
				try 
				{
					mySecurePeerAgentsGroupID = (PeerGroupID) net.jxta.id.IDFactory.fromURL(new java.net.URL("urn","",GROUPID));
				} 
				catch (java.net.MalformedURLException e) 
				{
				System.err.println(" Can't create securePeerAgentGroupID: MalformedURLException"+e.toString()) ;
				return null;
//				System.exit(1);
				}
				catch (java.net.UnknownServiceException e) 
				{
				System.err.println(" Can't create satellaPeerGroupID: UnknownServiceException ") ;
					return null;
				//System.exit(1);
				}
				
				// create the Peer Group by doing the following:
				// - Create a Peer Group Module Implementation Advertisement and publish it
				// - Create a Peer Group Adv and publish it
				// - Create a Peer Group from the Peer Group Adv and return this object
				PeerGroup mySecureGroup=null;
				PeerGroupAdvertisement mySecurePeerAgentsGroupAdvertisement;
				
				// Create the PeerGroup Module Implementation Adv
				
				ModuleImplAdvertisement passwdMembershipModuleImplAdv = null;
				
				// Create a ModuleImpl Advertisement for the Passwd Membership Service
				// Take a allPurposePeerGroupImplAdv ModuleImplAdvertisement parameter to
				// Clone some of its fields. It is easier than to recreate everything
				// from scratch
				
				// Try to locate where the PasswdMembership is within this ModuleImplAdvertisement.
				// For a PeerGroup Module Impl, the list of the services (including Membership)
				// are located in the Param section
				ModuleImplAdvertisement allPurposePeerGroupImplAdv=null;
				try 
				{
				allPurposePeerGroupImplAdv=nowGroup.getAllPurposePeerGroupImplAdvertisement();
				} 
				catch (java.lang.Exception e) 
				{
				System.err.println("Can't Execute: getAllPurposePeerGroupImplAdvertisement();");
				return null;
				//	System.exit(1);
				}
				ModuleImplAdvertisement passwdMembershipPeerGroupModuleImplAdv=allPurposePeerGroupImplAdv;
				ModuleImplAdvertisement passwdMembershipServiceModuleImplAdv=null;
				StdPeerGroupParamAdv passwdMembershipPeerGroupParamAdv=null;
				try 
				{
				passwdMembershipPeerGroupParamAdv = new StdPeerGroupParamAdv(allPurposePeerGroupImplAdv.getParam());
				} 
				catch (net.jxta.exception.PeerGroupException e) 
				{
				System.err.println("Can't execute: StdPeerGroupParamAdv passwdMembershipPeerGroupParamAdv = new StdPeerGroupParamAdv (allPurposePeerGroupImplAdv.getParam());");
				return null;
				//System.exit(1);
				}
				
				Hashtable allPurposePeerGroupServicesHashtable = passwdMembershipPeerGroupParamAdv.getServices();
				Enumeration allPurposePeerGroupServicesEnumeration = allPurposePeerGroupServicesHashtable.keys();
				boolean membershipServiceFound=false;
				while ((!membershipServiceFound) && (allPurposePeerGroupServicesEnumeration.hasMoreElements())) 
				{
				Object allPurposePeerGroupServiceID = allPurposePeerGroupServicesEnumeration.nextElement();
				if (allPurposePeerGroupServiceID.equals(PeerGroup.membershipClassID)) 
				{
				
				// allPurposePeerGroupMemershipServiceModuleImplAdv is the
				// all Purpose Mermbership Service for the all purpose
				// Peer Group Module Impl adv
				ModuleImplAdvertisement allPurposePeerGroupMemershipServiceModuleImplAdv= (ModuleImplAdvertisement) allPurposePeerGroupServicesHashtable.get(allPurposePeerGroupServiceID);
				//Create the passwdMembershipServiceModuleImplAdv
				
				passwdMembershipServiceModuleImplAdv = (ModuleImplAdvertisement) AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
				passwdMembershipServiceModuleImplAdv.setModuleSpecID(PasswdMembershipService.passwordMembershipSpecID);
				passwdMembershipServiceModuleImplAdv.setCode(PasswdMembershipService.class.getName());
				passwdMembershipServiceModuleImplAdv.setDescription(" Module Impl Advertisement for the PasswdMembership Service");
				passwdMembershipServiceModuleImplAdv.setCompat(allPurposePeerGroupMemershipServiceModuleImplAdv.getCompat());
				passwdMembershipServiceModuleImplAdv.setUri(allPurposePeerGroupMemershipServiceModuleImplAdv.getUri());
				passwdMembershipServiceModuleImplAdv.setProvider(allPurposePeerGroupMemershipServiceModuleImplAdv.getProvider());
				
				//Remove the All purpose Membership Service implementation
				allPurposePeerGroupServicesHashtable.remove(allPurposePeerGroupServiceID);
				// And Replace it by the Passwd Membership Service Implementation
				allPurposePeerGroupServicesHashtable.put(PeerGroup.membershipClassID,passwdMembershipServiceModuleImplAdv);
				membershipServiceFound=true;
				// Now the Service Advertisements are complete
				// Let's update the passwdMembershipPeerGroupModuleImplAdv by
				// Updating its param
				passwdMembershipPeerGroupModuleImplAdv.setParam((net.jxta.document.Element) passwdMembershipPeerGroupParamAdv.getDocument(new MimeMediaType("text/xml")));
				
				// Update its Spec ID
				// This comes from the Instant P2P PeerGroupManager Code (Thanks !!!!)
				if (!passwdMembershipPeerGroupModuleImplAdv.getModuleSpecID().equals(PeerGroup.allPurposePeerGroupSpecID)) 
				{
				passwdMembershipPeerGroupModuleImplAdv.setModuleSpecID(IDFactory.newModuleSpecID(passwdMembershipPeerGroupModuleImplAdv.getModuleSpecID().getBaseClass()));
				} 
				else 
				{
				ID passwdGrpModSpecID= ID.nullID;
				try 
				{
					passwdGrpModSpecID = IDFactory.fromURL(new URL("urn","","jxta:uuid-"+"DeadBeefDeafBabaFeedBabe00000001" +"04" +"06" ) );
				} 
				catch (java.net.MalformedURLException e) {}
				catch (java.net.UnknownServiceException ee) {}
				passwdMembershipPeerGroupModuleImplAdv.setModuleSpecID(IDFactory.newModuleSpecID(passwdMembershipPeerGroupModuleImplAdv.getModuleSpecID().getBaseClass()));
				//passwdMembershipPeerGroupModuleImplAdv.setModuleSpecID((ModuleSpecID) passwdGrpModSpecID);
				} //End Else
				membershipServiceFound=true;
				} //end if (allPurposePeerGroupServiceID.equals(PeerGroup.membershipClassID))
				}//end While
				passwdMembershipModuleImplAdv=passwdMembershipPeerGroupModuleImplAdv;
				//Publish it in the parent peer group
				DiscoveryService rootPeerGroupDiscoveryService = nowGroup.getDiscoveryService();
				
				try 
				{
				rootPeerGroupDiscoveryService.publish(passwdMembershipModuleImplAdv,
				PeerGroup.DEFAULT_LIFETIME,
				PeerGroup.DEFAULT_EXPIRATION);
				rootPeerGroupDiscoveryService.remotePublish(passwdMembershipModuleImplAdv,
				PeerGroup.DEFAULT_EXPIRATION);
				} 
				catch (java.io.IOException e) 
				{
				System.err.println("Can't Publish passwdMembershipModuleImplAdv");
				System.exit(1);
				}
				
				// Create a PeerGroupAdvertisement for the peerSecureGroup
				
				mySecurePeerAgentsGroupAdvertisement= (PeerGroupAdvertisement) AdvertisementFactory.newAdvertisement(PeerGroupAdvertisement.getAdvertisementType());
				
				// Instead of creating a new group ID each time, by using the line below
				// satellaPeerGroupAdvertisement.setPeerGroupID(IDFactory.newPeerGroupID());
				// I use a fixed ID so that each time I start SecurePeerGroup,
				// it creates the same Group
				mySecurePeerAgentsGroupAdvertisement.setPeerGroupID(mySecurePeerAgentsGroupID);
				mySecurePeerAgentsGroupAdvertisement.setModuleSpecID(passwdMembershipModuleImplAdv.getModuleSpecID());
				mySecurePeerAgentsGroupAdvertisement.setName(groupName);
				mySecurePeerAgentsGroupAdvertisement.setDescription("Secure Peer Group using Password Authentication");
				
				
				// Now create the Structured Document Containing the login and passwd informations.
				// Login and passwd are put into the Param section of the peer Group
				
				if (login!=null) 
				{
				StructuredTextDocument loginAndPasswd= (StructuredTextDocument) StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"),"Parm");
				String loginAndPasswdString=login+":"+PasswdMembershipService.makePsswd(passwd)+":";
				TextElement loginElement = loginAndPasswd.createElement("login",loginAndPasswdString);
				loginAndPasswd.appendChild(loginElement);
				// All Right, now that loginAndPasswdElement (The strucuted document
				// that is the Param Element for The PeerGroup Adv
				// is done, include it in the Peer Group Advertisement
				mySecurePeerAgentsGroupAdvertisement.putServiceParam(PeerGroup.membershipClassID,loginAndPasswd);
				}
				
				// Publish The peerGroupAdverisment in the parent peer group
				try 
				{
				rootPeerGroupDiscoveryService.publish(mySecurePeerAgentsGroupAdvertisement,
				PeerGroup.DEFAULT_LIFETIME,
				PeerGroup.DEFAULT_EXPIRATION);
				rootPeerGroupDiscoveryService.remotePublish(mySecurePeerAgentsGroupAdvertisement,PeerGroup.DEFAULT_EXPIRATION);
				} 
				catch (java.io.IOException e) 
				{
				System.err.println("Can't Publish SecurePeerGroupAdvertisement");
				System.exit(1);
				}
				
				// Finally Create the Peer Group
				
				if (mySecurePeerAgentsGroupAdvertisement==null) {
				System.err.println("mySecurePeerAgentsGroupAdvertisement is null!!");
				}
				try 
				{
					mySecureGroup=nowGroup.newGroup(mySecurePeerAgentsGroupAdvertisement);
				} 
				catch (net.jxta.exception.PeerGroupException e) 
				{
					System.err.println("Can't create SecurePeerGroup from Advertisement");
					e.printStackTrace();
					return null;
				}
				return mySecureGroup;
}

		public PeerGroup createGroup(PeerGroupAdvertisement pGA)
		{
			try
			{	
				PeerGroup peerGroup = netPeerGroup.newGroup(pGA);
				if(peerGroup!=null)
				{				
					DiscoveryService discoverySvc = netPeerGroup.getDiscoveryService();				
					discoverySvc.publish(pGA);
					discoverySvc.remotePublish(pGA);
				}
					return(peerGroup);
			}
			catch(Exception e)
			{
				System.err.println(e.toString());
				return null;
			}
		}
		
	private void joinSecurePeerGroup(PeerGroup securePeerGroup,String login,String passwd) 
	{
		// Get the Heavy Weight Paper for the resume
		// Alias define the type of credential to be provided
		StructuredDocument creds = null;
		try 
		{
				// Create the resume to apply for the Job
				// Alias generate the credentials for the Peer Group
				AuthenticationCredential authCred =new AuthenticationCredential( securePeerGroup, null, creds );
				
				// Create the resume to apply for the Job
				// Alias generate the credentials for the Peer Group
				MembershipService membershipService = securePeerGroup.getMembershipService();
				
				// Send the resume and get the Job application form
				// Alias get the Authenticator from the Authentication creds
				Authenticator auth = membershipService.apply( authCred );
				
				// Fill in the Job Application Form
				// Alias complete the authentication
				Method [] methods = auth.getClass().getMethods();
				Vector authMethods = new Vector();
				
				// Find out with fields of the application needs to be filled
				// Alias Go through the methods of the Authenticator class and copy
				// them sorted by name into a vector.
				for( int eachMethod = 0; eachMethod < methods.length; eachMethod++ ) 
				{
						if( methods[eachMethod].getName().startsWith("setAuth") ) 
						{
							if( Modifier.isPublic( methods[eachMethod].getModifiers())) 
							{
								// sorted insertion.
								for( int doInsert = 0; doInsert <= authMethods.size();doInsert++ ) 
								{
										int insertHere = -1;
										if( doInsert == authMethods.size() )
											insertHere = doInsert;
										else 
										{
												if(methods[eachMethod].getName().compareTo(((Method)authMethods.elementAt( doInsert )).getName()) <= 0 )
													insertHere = doInsert;
										} // end else
						
										if(-1!= insertHere ) 
										{
												authMethods.insertElementAt(methods[eachMethod],insertHere);
												break;
										} // end if ( -1 != insertHere)
								} // end for (int doInsert=0
							} // end if (modifier.isPublic
						} // end if (methods[eachMethod]
				} // end for (int eachMethod)
				Object [] AuthId = {login};
				Object [] AuthPasswd = {passwd};
				
				for( int eachAuthMethod=0;eachAuthMethod<authMethods.size();eachAuthMethod++ ) 
				{
					Method doingMethod = (Method) authMethods.elementAt(eachAuthMethod);
					String authStepName = doingMethod.getName().substring(7);
					if (doingMethod.getName().equals("setAuth1Identity")) 
					{
						// Found identity Method, providing identity
						doingMethod.invoke( auth, AuthId);
					} 
					else if (doingMethod.getName().equals("setAuth2_Password")) 
					{
						// Found Passwd Method, providing passwd
						doingMethod.invoke( auth, AuthPasswd );
					}
				}
				// Check if I got the Job
				// Alias Check if the authentication that was submitted was
				//accepted.
				if( !auth.isReadyForJoin()) 
				{
					System.out.println( "Failure in authentication.");
					System.out.println( "Group was not joined. Does not know how to complete authenticator");
				}
				// I got the Job, Join the company
				// Alias I the authentication I completed was accepted,
				// therefore join the Peer Group accepted.
				membershipService.join( auth );
				System.out.println("Congratulation you joined the : "+securePeerGroup.getPeerGroupName());
		} 
		catch (Exception e) 
		{
			System.out.println("Failure in authentication.");
			System.out.println("Group was not joined. Login was incorrect.");
			e.printStackTrace();
		}
	}

		
		protected void connectToRdv(PeerGroup peerGroup)
		{
    
        //Get the rdv service
     RendezVousService  rdv = peerGroup.getRendezVousService();
    //Make sure that we are connected before proceeding
    while( !rdv.isConnectedToRendezVous() )
    {
        try
        {
            Thread.sleep(5000);
        }
        catch (InterruptedException e1)
        {
            System.out.println("rdv connect interrupted");
            e1.printStackTrace();
		        }
		    }
		}
		public PeerGroup createGroup(PeerGroup grp,String name) 
		{
			PeerGroupAdvertisement adv=null;
			PeerGroup pg=null;
			DiscoveryService discoverySvc = netPeerGroup.getDiscoveryService();
			try 
			{
				ModuleImplAdvertisement implAdv = grp.getAllPurposePeerGroupImplAdvertisement();
		
				pg = grp.newGroup(null, // Assign new group ID
				implAdv, // The implem. adv
				name, // The name
				"The JXTA Madkit Communicator Group"); // Helpful descr.
		//		 print the name of the group and the peer group ID
				
				adv = pg.getPeerGroupAdvertisement();
				PeerGroupID GID = adv.getPeerGroupID();
				System.err.println(adv.toString());
				System.out.println(" Group = " +adv.getName() +
				"\n Group ID = " + GID.toString());
				discoverySvc.publish(adv);
				discoverySvc.remotePublish(adv);
				System.out.println("Group published successfully.");
			} 
			catch (Exception e) 
			{
					
			}
			return pg;
		}
				
		private boolean joinPeerGroup(PeerGroup grp) 
		{
			StructuredDocument creds = null;
			try 
			{ 
				AuthenticationCredential authCred = new AuthenticationCredential( grp, null, creds );
				MembershipService membership = grp.getMembershipService();
				Authenticator auth = membership.apply( authCred );
				if (auth.isReadyForJoin())
				{
				//	Credential myCred = membership.join(auth);
					System.out.println("Successfully joined group " + grp.getPeerGroupName());
					return true;
			} 
			else
				System.out.println("Failure: unable to join group");
				return false;
			}
			catch (Exception e)
			{ 
				return false;
			}
		}
		
		 public PeerGroupAdvertisement getPeerGroupAdvertisement(PeerGroup pg,String name, int time) throws Exception
   	 {
			Enumeration e = searchGeneric(pg, "Name", name,DiscoveryService.GROUP,1, time);
			if((e == null) || !e.hasMoreElements())
			{
        System.err.println("Didnt find any pipe advertisements");
        return null;
			}
			PeerGroupAdvertisement pGA = null;
			while(e.hasMoreElements())
			{
            Object obj = e.nextElement();
            try 
						{
                pGA = (PeerGroupAdvertisement) obj;
                System.err.println("Found PeerGroup : " + pGA.getName()+" avec adv = \n "+pGA.toString());
								return pGA;
						}
						catch(Exception ex)
						{
                System.err.println("Found non-pipe adv ");
               // Advertisement adv = (Advertisement) obj;
								return null;
            }
 			 }
				return null;
		 }
		public  JxtaBiDiPipe createBiDiPipeClient(PeerGroup pG, PipeAdvertisement pA)
		{
			try
			{
				JxtaBiDiPipe pipe = new JxtaBiDiPipe();				
				pipe.connect(pG,
					null,
					pA,
					100000,
					// register as a message listener
					this);
				return pipe;
			}
			catch(Exception e)
			{
				System.err.println("ERRRRR BidiClientPipe ne peut etre cr dans ce temps"+e.toString());	
				e.printStackTrace();
				try
				{
					pG.getDiscoveryService().flushAdvertisement(pA);				
				}
				catch(Exception error)
				{
				
				}
				return null;
			}
		}
		
		private void treatBiDiPipeMsgs(JxtaBiDiPipe pipe) 
		{
			try 
			{
				Message msg = pipe.getMessage(120000);
				// get the message element named SenderMessage
			
				MessageElement msgType;
				MessageElement msgContent;

				
				if(msg!=null)
				{  
					msgType = msg.getMessageElement(null, "Type");					
					msgContent = msg.getMessageElement(null, "Signature");
					
				// Get message
				if (msgContent.toString() == null) 
				{
					System.out.println("null msg received");
				} 
				else 
				{
					java.util.Date date = new java.util.Date(System.currentTimeMillis());
					System.out.println("Message received at :"+ date.toString());
					System.out.println("Message  Type is  :"+ msgType.toString());
					System.out.println("Message  received is :"+ msgContent.toString()+"\n");		
				//	String msgAnswer = treatRequest(msgContent.toString());
				String msgAnswer="";	
				//	System.err.println("Answer is "+msgAnswer+"ssssssssssssss");

					String answer = msgAnswer.substring(msgAnswer.indexOf("(state")+6,msgAnswer.indexOf(") (elements"));
					System.err.println("Answer is "+answer);
					Message mesg = new Message();
					StringMessageElement smeType = new StringMessageElement("Type","Answer", null);
					StringMessageElement smeText = new StringMessageElement("Answer",answer, null);
					StringMessageElement smeDetails = new StringMessageElement("Details",msgAnswer, null);
					//StringMessageElement smeType = new StringMessageElement("Signature",msgAnswer, null);
					//StringMessageElement smeText = new StringMessageElement("Role",msgAnswer, null);
					
					
					mesg.addMessageElement(null, smeType);
					mesg.addMessageElement(null, smeText);
					mesg.addMessageElement(null, smeDetails);

					Messenger out = pipe.getMessenger();
					out.sendMessage(mesg);		
//					JxtaServerPipe serverAdded = server;
//					servers.addElement(serverAdded);
				//	createBiDiPipeServer(myPeerGroup,"Pipe1.");//+servers.size());
				}
				// get the messenger
			
					}
			} 
			catch (Exception ie) 
			{
				ie.printStackTrace();
			}
		
		}

		public void disconnect()
		{					
					sendMessage(mykernel, new NetworkRequest(NetworkRequest.STOP_COMMUNICATOR));
		  		alive = false;
					
				for(Iterator i = distantKernels.values().iterator();i.hasNext();)
  				{
							madkit.kernel.StringMessage msg = new madkit.kernel.StringMessage(getAddress().getKernel().toString());
							String distantKernel = (String)i.next();
							KernelAddress ka = ((AgentAddress)((Vector)distantKernels.get(distantKernel)).get(1)).getKernel();					
							sendDistantMessage("DisconnectionMessage",msg,ka);					
				}
		}
		
		public void end()
		{
			disconnect();
  		//comm.close();
  		println("Agent SocketCommunicator killed. server is closed");
    	System.gc();
		}
		public  JxtaServerPipe createBiDiPipeServer(PeerGroup pG, String name, int timeout)
		{
				PipeAdvertisement pA =(PipeAdvertisement)AdvertisementFactory.newAdvertisement (PipeAdvertisement.getAdvertisementType());
				pA.setName(name);
				pA.setType("JxtaUnicast");
				String mobility ="0" ;
				if(getAddress().getKernel().supportMobility())
					mobility ="1";
					
				String strSite = mykernel.getName()+","+String.valueOf(mykernel.getLocalID())+"@"+mykernel.getKernel();
				String strKernel = getAddress().getKernel().getHost()+":"+getAddress().getKernel().getID()+":"+getAddress().getKernel().getKernelName()+":"+mobility+"&"+strSite;
				pA.setDescription(strKernel);
				pA.setPipeID((ID) net.jxta.id.IDFactory.newPipeID(pG.getPeerGroupID())
			);
			try
			{
				JxtaServerPipe serverPipe = new JxtaServerPipe(pG, pA);
				// we want to block until a connection is established
				serverPipe.setPipeTimeout(timeout);
				DiscoveryService desc = pG.getDiscoveryService();
				desc.publish(pA);
				desc.remotePublish(pA);
				return serverPipe;
			}
			catch(Exception e)
			{
				System.err.println("EROOOOOOOOOOORRRR"+e.toString());
				return null;
			}
		}
    
		
	
		                                  
	synchronized private void handleMessage(madkit.kernel.Message m)
    {
      madkit.kernel.Message orig=null;  
			System.err.println("************MobilityUpdate to send to all connected agency ************** 2"+m);

			if (m instanceof KernelMessage)
			{
          KernelMessage temp = (KernelMessage) m;
          orig = (madkit.kernel.Message) (temp.getArgument());
   				System.err.println("Message intercept  faire circuler outside ;)  de type : "+orig.getClass().toString());
					if(orig.getClass().toString().equals("class madkit.kernel.ConnectionMessage"))
					{
							System.err.println("KernelMessssssageeeeeeeeee"+orig.toString());					
							sendDistantMessage("ConnectionMessage",orig, orig.getReceiver().getKernel());
							return;
					}
					else if(orig.getClass().toString().equals("class madkit.kernel.DisconnectionMessage"))
					{
							System.err.println("DisconnectionMessage from : "+orig.toString());					
							//disconnectFrom();// to Be continued if we can accept disconnection from a specific PeerAgent i don't think this is mandataroy but ...
							return;					
					}
					else
					{	
						sendDistantMessage(orig, orig.getReceiver().getKernel());
						return;
					}
							
	    } 
	
		else  
        	orig = m;
        debug("sending message "+ m);
				sendDistantMessage(orig, orig.getReceiver().getKernel());
    }

		synchronized private void handleMessage(NetworkRequest m)
		{
			System.err.println("************MobilityUpdate to send to all connected agency ************** 2");
			if(m.getRequestCode()==NetworkRequest.UPDATE_AGENCIES_INFORMATIONS)
			{
				System.err.println("************MobilityUpdate to send to all connected agency **************");
				Set set = distantKernels.keySet(); // We get the keys of the distantKernels in order to fetch for the conencted one sending this connection message
				for(Iterator i = set.iterator();i.hasNext();)
  			{
								String distantKernel = (String)i.next();
								System.err.println("AAAAAAAAAAAAAAAAAAAAAAAAA"+distantKernel);
								AgentAddress siteAgent = (AgentAddress)((Vector)distantKernels.get(distantKernel)).get(1);									
								KernelAddress ka = ((AgentAddress)((Vector)distantKernels.get(distantKernel)).get(1)).getKernel();																					
								
							if(getAddress().getKernel().supportMobility())
							{
								sendDistantMessage("MobilityEnabled",m,ka);								
							}
							else
							{
								sendDistantMessage("MobilityDisabled",m,ka);		
							}															
				}		
			}
		}



}//Fin CommunicationJxta		

