/**
 * 
 */
package turtlekit.simulations.hunt2CyanVsOrange;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import turtlekit.kernel.Turtle;

/**
  @author Fabien MICHEL
  @version 2.0 25/02/2007 */
public abstract class Animat extends Turtle {

	protected int life;
	protected int visionRadius;
	private static Map<Class<Animat>, Constructor<Animat>> contructors=new HashMap<Class<Animat>, Constructor<Animat>>(2);

	/**
	 * 
	 */
	public Animat(int visionRadius,int initLife) {
		super("live");
		this.visionRadius=visionRadius;
		life=initLife;
	}

	final protected void move()
	{
		if(--life<0)
			die();
		fd(1);
	}
	

	final protected void consumeResource(){
		double resource = getPatchVariable("resource");
		if (resource>0){
			life+=resource;
			incrementPatchVariable("resource", -resource);
		}
	}


	/**
	 * @return the life
	 */
	public final int getLife() {
		return life;
	}

	/* (non-Javadoc)
	 * @see turtlekit.kernel.Turtle#toString()
	 */
	@Override
	public String toString() {
		return ""+getClass()+" : life = "+getLife();
	}

	final protected void eatPrey(Animat target){
		if(xcor()!=target.xcor() || ycor()!=target.ycor()){
			System.out.println("!!!! tentative de manger une proie à distance !!!!");
			return;
		}
	    life += target.getLife();
	    target.die();
	}
	
	final protected void reproduce() throws SecurityException{
		life-=life/2;
		Constructor<Animat> c = contructors.get(getClass());
			try {
				if(c==null){
					c = (Constructor<Animat>) getClass().getConstructor(int.class,int.class);
					contructors.put((Class<Animat>) getClass(),c);
				}
				createTurtle(c.newInstance(visionRadius,life));
			} catch (InstantiationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	}



}
