/*
 * GasObserver.java -TurtleKit - A 'star logo' in MadKit
 * Copyright (C) 2000-2002 Fabien Michel
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package turtlekit.simulations.hunt2CyanVsBlue;

import java.awt.Color;

import turtlekit.kernel.Observer;

/** This agent watch the gas simulation (nb of turtles on right or left) 
  @author Fabien MICHEL
  @version 1.1 6/12/1999 */

public class ResourceManager extends Observer
{
	double density;

	public ResourceManager (double density)
	{
		this.density=density;
	}

	public void setup()
	{
		resourceUpdate();
	}

	synchronized public void watch()
	{
		resourceUpdate();
	}

	/**
	 * 
	 */
	private void resourceUpdate() {
		for(int i=0;i<envWidth;i++)
			for(int j=0;j<envHeight;j++){
				if (Math.random() < density){
					patchGrid[i][j].incrementPatchVariable("resource", 10);
				}
				int green = (int) patchGrid[i][j].getVariableValue("resource")*8;
				patchGrid[i][j].setColor(new Color(0,green<255?green:255,0));	
			}
	}
}
