/*
 * HuntLauncher.java -TurtleKit - A 'star logo' in MadKit
 * Copyright (C) 2000-2002 Fabien Michel
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package turtlekit.simulations.hunt2CyanVsBlue; 

import turtlekit.kernel.Launcher;
import turtlekit.kernel.PatchVariable;

/** Hunt simulation launcher 
 
 @author Fabien MICHEL
 @version 1.1 6/12/2000 */

public class HuntLauncher extends Launcher
{
	
	private int nbOfprey=150;
	private int nbOfpredator=150;
	private int predatorVision=4;
	private int preyVision=4;
	private int preyInitLife=90;
	private int predatorInitLife=90;
	private boolean withResource=true;
	private double density=0.01;
	
	public HuntLauncher()
	{
		setCyclePause(10);
		setSimulationName("HUNT 2");
		setWidth(100);
		setHeight(100);
		setCellSize(5);
	}
	
	public void setNbOfprey (int add){nbOfprey = add;}
	public int getNbOfprey(){return nbOfprey;}
	public void setPredatorVision (int add){predatorVision = add;}
	public int getPredatorVision(){return predatorVision;}
	public void setNbOfpredator (int add){nbOfpredator = add;}
	public int getNbOfpredator(){return nbOfpredator;}
	
	
	protected void initializePatchVariables()
	{
		PatchVariable a = new PatchVariable("resource");
		a.setDiffuseCoef(0);
		a.setEvapCoef(0);
		addPatchVariable(a);
	}
	
	
	public void addSimulationAgents()
	{ 
		setCyclePause(10);
		if(withResource){
			addObserver(new ResourceManager(density)	, false);
		}
		addObserver(new PreyObserver(1000), true);
		addObserver(new PredatorObserver(2000), true);

		
		for (int i = 0; i < nbOfpredator; i++) //add the predator with the method addTurtle
		{
			Cyan t = new Cyan(predatorVision,predatorInitLife);
			addTurtle(t);
			Blue p = new Blue(predatorVision,predatorInitLife);
			addTurtle(p);
		}
		addViewer(6); // we choose a default viewer with a cell size of 4
	}
	
	/**
	 * @return the density
	 */
	public double getDensity() {
		return density;
	}
	
	/**
	 * @param density the density to set
	 */
	public void setDensity(double density) {
		this.density = density;
	}
	
	/**
	 * @return the withResource
	 */
	public final boolean isWithResource() {
		return withResource;
	}
	
	/**
	 * @param withResource the withResource to set
	 */
	public final void setWithResource(boolean withResource) {
		this.withResource = withResource;
	}
	
	/**
	 * @return the preyVision
	 */
	public final int getPreyVision() {
		return preyVision;
	}
	
	/**
	 * @param preyVision the preyVision to set
	 */
	public final void setPreyVision(int preyVision) {
		this.preyVision = preyVision;
	}
	
	/**
	 * @return the preyInitLife
	 */
	public final int getPreyInitLife() {
		return preyInitLife;
	}
	
	/**
	 * @param preyInitLife the preyInitLife to set
	 */
	public final void setPreyInitLife(int preyInitLife) {
		this.preyInitLife = preyInitLife;
	}
	
	/**
	 * @return the predatorInitLife
	 */
	public final int getPredatorInitLife() {
		return predatorInitLife;
	}
	
	/**
	 * @param predatorInitLife the predatorInitLife to set
	 */
	public final void setPredatorInitLife(int predatorInitLife) {
		this.predatorInitLife = predatorInitLife;
	}
}


