/*
* GasObserver.java -TurtleKit - A 'star logo' in MadKit
* Copyright (C) 2000-2007 Fabien Michel
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package turtlekit.simulations.hunt2;

import madkit.guis.SimplePlotPanel;
import turtlekit.kernel.Observer;
import turtlekit.kernel.TurtleProbe;

/** This agent watch the gas simulation (nb of turtles on right or left) 
  @author Fabien MICHEL
  @version 1.1 6/12/1999 */

@SuppressWarnings("serial")
public class PreyObserver extends Observer
{
    SimplePlotPanel plot;
    TurtleProbe allTurtles;
    int nb;

public PreyObserver (int nbOfTurtle)
{
	nb=nbOfTurtle;
}

public void initGUI()
{
	setGUIObject(plot = new SimplePlotPanel("nb of preys",499,nb));
}

public void setup()
{
	//initialize the GUI
	plot.initialisation();

	allTurtles = new TurtleProbe(getSimulationGroup(),"prey");
	addProbe(allTurtles);
}

synchronized public void watch()
{
	plot.addPoint(allTurtles.nbOfTurtles());
}
}
