/*
* TurtleKit - A 'reactive simulation platform' using MadKit Kernel
* Copyright (C) 2000-2007 Fabien Michel, Gregory Beurier
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package turtlekit2.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import turtlekit2.kernel.Patch;
import turtlekit2.kernel.Viewer;

/**
 * <p>Titre : EnvironnementPatchEditor</p>
 * <p>Description : This viewer implements classical drawing primitives (like microsoft paint) in order to draw patch within the environment</p>
 * <p></p>
 * <p>XML Attributes : None</p>
 * @author Gregory Beurier
 */

public class EnvironmentPatchEditor extends Viewer implements MouseListener, MouseMotionListener,ActionListener, MouseWheelListener
{
	final static int RECTANGLE = 0;
	final static int CIRCLE = 1;
	final static int POINT = 2;
	final static int FILL = 3;
	final static int LINE = 4;
	final static int SOLIDCIRCLE = 5;
	final static int ELLIPSE = 6;
	
	final static int TINY = 0;
	final static int MEDIUM = 1;
	final static int BIG = 2;
	final static int HUGE = 3;
	
	int drawing = POINT;
	boolean mouseClc = false;
	boolean ellipse = false;
	int radius = 0;
	int radiusSecond = 0;
	int xFirstClick, yFirstClick, xSecondClick, ySecondClick;
	int size = BIG;
		Color markColor ;
		JLabel lb,actionClick;
		public void init() {	
		}
	
		public void initGUI() {
			super.initGUI();
			createFrame();
			getOnScreen().addMouseWheelListener(this);
			getOnScreen().addMouseListener(this);
			getOnScreen().addMouseMotionListener(this);
		}

		public void createFrame(){
			JFrame frame = new JFrame("Environnement Edition");
			frame.setTitle("TurtleKit Environnement Editor");//titre
			frame.setSize(350,100);//taille
		    panel = new JPanel();//cration d'un panel
		    frame.getContentPane().add(panel, BorderLayout.CENTER);//panel ajout au container
		        
		    //cration d'un nouvel objet (ColorAction)
	        Action jauneAction = new ColorAction("Yellow", new ImageIcon("images\\jaune.gif"), Color.yellow);
	        Action vertAction = new ColorAction("Green", new ImageIcon("images\\vert.gif"), Color.green);
	        Action rougeAction = new ColorAction("Red", new ImageIcon("images\\rouge.gif"), Color.red);
	        Action noirAction = new ColorAction("Black", new ImageIcon("images\\noir.gif"), Color.black);
	        Action bleuAction = new ColorAction("Blue", new ImageIcon("images\\bleu.gif"), Color.blue);
	        Action grisAction = new ColorAction("Grey", new ImageIcon("images\\gris.gif"), Color.gray);
	        Action blancAction = new ColorAction("White", new ImageIcon("images\\blanc.gif"), Color.white);
	        Action tinyAction = new ColorAction("Tiny", new ImageIcon("images\\tiny.gif"), TINY);
	        Action mediumAction = new ColorAction("Medium", new ImageIcon("images\\medium.gif"), MEDIUM);
	        Action bigAction = new ColorAction("Big", new ImageIcon("images\\big.gif"), BIG);
	        Action hugeAction = new ColorAction("Huge", new ImageIcon("images\\huge.gif"), HUGE);
	        
	        //ajoute un libell
	        lb = new JLabel("Coord X - Y", SwingConstants.CENTER);
	        actionClick = new JLabel("Click", SwingConstants.CENTER);
	        panel.add(actionClick);
	        panel.add(lb);//ajoute du libell au panel
	        JToolBar bar= new JToolBar("Faites votre choix"); //cration d'un JToolBar avec titre
	        //ajoute des actions au jtoolbar
	        bar.add(jauneAction);
	        bar.add(vertAction);
	        bar.add(rougeAction);
	        bar.add(noirAction);
	        bar.add(bleuAction);
	        bar.add(grisAction);
	        bar.add(blancAction);
	        bar.addSeparator(); //met une sparation entre les options
	        bar.add(tinyAction);
	        bar.add(mediumAction);
	        bar.add(bigAction);
	        bar.add(hugeAction);
	        
	        //ajoute le jtoolbar au container
	        frame.getContentPane().add(bar, BorderLayout.NORTH);
	        
	        //cration d'un menu nomm Couleur
	        JMenu menu = new JMenu("Pattern");
	        JMenuItem menuItem = new JMenuItem("Rectangle");
	        menu.add(menuItem);
	        menuItem.addActionListener(this);
	        menuItem = new JMenuItem("Circle");
	        menu.add(menuItem);
	        menuItem.addActionListener(this);
	        menuItem = new JMenuItem("SolidCircle");
	        menu.add(menuItem);
	        menuItem.addActionListener(this);
	        menuItem = new JMenuItem("Ellipse");
	        menu.add(menuItem);
	        menuItem.addActionListener(this);
	        menuItem = new JMenuItem("Point");
	        menu.add(menuItem);
	        menuItem.addActionListener(this);
	        menuItem = new JMenuItem("Fill");
	        menu.add(menuItem);
	        menuItem.addActionListener(this);
	        menuItem = new JMenuItem("Line");
	        menu.add(menuItem);
	        menuItem.addActionListener(this);
	        
	        
	        

	        //création du menubar (obligatoire pour un jmenu car le jmenu ne peut etre ajout que  un jmenubar
	        JMenuBar menuBar = new JMenuBar();
	        menuBar.add(menu);
	        //ajout du menubar au container (en quelques sortes)
	        frame.setJMenuBar(menuBar);
	        frame.setVisible(true);
		}
		public void paintPatch(Graphics g, Patch p,int x,int y,int CellSize)
		{
			try{
				g.setColor(p.getColor());
				g.fillRect(x,y,CellSize,CellSize);
			}
			catch(Exception e){System.err.println("Error Viewer " + e);}
		}
		
		
		
	    public void actionPerformed(ActionEvent e) {
	    	if(e.getActionCommand().equals("Rectangle")) {
	    	 	drawing = RECTANGLE;
	    	 }else if(e.getActionCommand().equals("Circle")) {
	    	 	drawing = CIRCLE;
	    	 }else if(e.getActionCommand().equals("Point")) {
	    	 	drawing = POINT;
	    	 }else if(e.getActionCommand().equals("Fill")) {
	    	 	fill(0,0,envHeight,envHeight);
	    	 }else if(e.getActionCommand().equals("Line")) {
	    	 	drawing = LINE;
		   	 }else if(e.getActionCommand().equals("SolidCircle")) {
		   	 	drawing = SOLIDCIRCLE;
	    	 }else if(e.getActionCommand().equals("Ellipse")) {
	    	 	drawing = ELLIPSE;
	    	 }
	    	 
	    } 
		
		 public void mousePressed(MouseEvent e) {
		 	mouseClc = !mouseClc;
		 	
		 	if(mouseClc){
		 		xFirstClick = e.getX()/getCellSize();
		 		yFirstClick = e.getY()/getCellSize();
		 		actionClick.setText("X1:" + xFirstClick + " Y1:"+ yFirstClick);
		 	}else{
		 		xSecondClick = e.getX()/getCellSize();
		 		ySecondClick = e.getY()/getCellSize();
		 		actionClick.setText("X2:" + xSecondClick + " Y2:"+ ySecondClick);
		 	}
		 	if(drawing == RECTANGLE && !mouseClc){
		 		fill(xFirstClick,yFirstClick,xSecondClick,ySecondClick);
		 	}
		 	if(drawing == LINE && !mouseClc){
		 		line(xFirstClick,yFirstClick,xSecondClick,ySecondClick);
		 	}
		 	if(drawing == CIRCLE && !mouseClc){
		 		int xTmp = Math.abs(xSecondClick - xFirstClick);
		 		int yTmp = Math.abs(ySecondClick - yFirstClick);
		 		radius = (int)Math.sqrt( xTmp*xTmp + yTmp*yTmp);
		 		circle(radius,xFirstClick,-yFirstClick);
		 	}
		 	if(drawing == SOLIDCIRCLE && !mouseClc){
		 		int xTmp = Math.abs(xSecondClick - xFirstClick);
		 		int yTmp = Math.abs(ySecondClick - yFirstClick);
		 		radius = (int)Math.sqrt( xTmp*xTmp + yTmp*yTmp);
		 		solidCircle(radius,xFirstClick,-yFirstClick);
		 	}
		 	if(drawing == ELLIPSE && !mouseClc){
		 		
		 		if(!ellipse){
			 		int xTmp = Math.abs(xSecondClick - xFirstClick);
			 		int yTmp = Math.abs(ySecondClick - yFirstClick);
			 		radius = (int)Math.sqrt( xTmp*xTmp + yTmp*yTmp);
			 		mouseClc = true;
			 		ellipse = true;
		 		}
			 	else{
			 		int xTmp = Math.abs(xSecondClick - xFirstClick);
			 		int yTmp = Math.abs(ySecondClick - yFirstClick);
			 		radiusSecond = (int)Math.sqrt( xTmp*xTmp + yTmp*yTmp);
			 		ellipse = false;
			 		ellipse(radius,radiusSecond,xFirstClick,-yFirstClick);
		 		}
//		 		ellipse(radius,radius - 5, xFirstClick, -yFirstClick);
		 	}
		 }

		 void ellipse(int aMax,int bMax, int xInit, int yInit) {
		 	for(int a = 0; a<= aMax; a++){
		 		for(int b=bMax; b<=bMax; b++){
		 			
		 	int x,y ;
		 	double d1,d2 ;
		 	x = 0 ;
		 	y = b ;
		 	d1 = b*b - a*a*b + a*a/4 ;
		 	colorPoint(x+xInit,y-yInit) ;
		 	colorPoint(x+xInit,-y-yInit) ;
		 	colorPoint(-x+xInit,y-yInit) ;
		 	colorPoint(-x+xInit,-y-yInit) ;
		 	while ( a*a*(y-.5) > b*b*(x+1) ) {
		 	  if ( d1 < 0 ) {
		 	    d1 += b*b*(2*x+3) ;
		 	    x++ ; }
		 	    else {
		 	    d1 += b*b*(2*x+3) + a*a*(-2*y+2) ;
		 	    x++ ;
		 	    y-- ; }
		 	 colorPoint(x+xInit,y-yInit) ;
			 	colorPoint(x+xInit,-y-yInit) ;
			 	colorPoint(-x+xInit,y-yInit) ;
			 	colorPoint(-x+xInit,-y-yInit) ; }
		 	d2 = b*b*(x+.5)*(x+.5) +
		 	     a*a*(y-1)*(y-1) - a*a*b*b ;
		 	while ( y > 0 ) {
		 	  if ( d2 < 0 ) {
		 	    d2 += b*b*(2*x+2) + a*a*(-2*y+3) ;
		 	    y-- ;
		 	    x++ ; }
		 	    else {
		 	    d2 += a*a*(-2*y+3) ;
		 	    y-- ; }
		 	 colorPoint(x+xInit,y-yInit) ;
			 	colorPoint(x+xInit,-y-yInit) ;
			 	colorPoint(-x+xInit,y-yInit) ;
			 	colorPoint(-x+xInit,-y-yInit) ; }
				}
		 	}
		 	}
		 
		 
		 void solidCircle(int r, int xInit, int yInit) {
		 	for(int i = 0; i <=r; i++){
			 	int x,y,d ;
			 	x = 0 ;
			 	y = i ;
			 	d = 1 - i ;
			 	colorPoint(x +xInit, -y  -yInit);
			 	colorPoint(x +xInit, +y  -yInit );
			 	colorPoint(-x +xInit, +y  -yInit );
			 	colorPoint(-x +xInit,-y  -yInit );
			 	colorPoint(y +xInit, +x  -yInit );
			 	colorPoint(y +xInit,-x  -yInit );
			 	colorPoint(-y +xInit, +x  -yInit );
			 	colorPoint(-y +xInit, -x  -yInit );
			 	while ( y > x ) {
			 	  if ( d < 0 )
			 	    d += 2 * x + 3 ;
			 	    else {
			 	    d += 2 * (x - y) + 5 ;
			 	    y-- ; }
			 	  x++ ;
			 	  	colorPoint(x +xInit,-y  -yInit);
				 	colorPoint(x +xInit,+y  -yInit );
				 	colorPoint(-x +xInit, +y  -yInit );
				 	colorPoint(-x +xInit, -y  -yInit);
				 	colorPoint(y +xInit, +x  -yInit);
				 	colorPoint(y +xInit, -x  -yInit );
				 	colorPoint(-y +xInit, +x  -yInit );
				 	colorPoint(-y +xInit,-x  -yInit );
			 	 }
		 	}
		 	}
		 
		 void circle(int r, int xInit, int yInit) {
		 	int x,y,d ;
		 	x = 0 ;
		 	y = r ;
		 	d = 1 - r ;
		 	colorPoint(x +xInit, -y  -yInit);
		 	colorPoint(x +xInit, +y  -yInit );
		 	colorPoint(-x +xInit, +y  -yInit );
		 	colorPoint(-x +xInit,-y  -yInit );
		 	colorPoint(y +xInit, +x  -yInit );
		 	colorPoint(y +xInit,-x  -yInit );
		 	colorPoint(-y +xInit, +x  -yInit );
		 	colorPoint(-y +xInit, -x  -yInit );
		 	while ( y > x ) {
		 	  if ( d < 0 )
		 	    d += 2 * x + 3 ;
		 	    else {
		 	    d += 2 * (x - y) + 5 ;
		 	    y-- ; }
		 	  x++ ;
		 	 colorPoint(x +xInit,-y  -yInit);
		 	colorPoint(x +xInit,+y  -yInit );
		 	colorPoint(-x +xInit, +y  -yInit );
		 	colorPoint(-x +xInit, -y  -yInit);
		 	colorPoint(y +xInit, +x  -yInit);
		 	colorPoint(y +xInit, -x  -yInit );
		 	colorPoint(-y +xInit, +x  -yInit );
		 	colorPoint(-y +xInit,-x  -yInit );
		 	 }
		 	}
		 
		 
		 void colorize(int x, int y){
		 	if(x < envWidth && x > -1 && y < envHeight && y > -1){
		 		patchGrid[x][envHeight-1 -y].setColor(markColor);
		 	}
		 }
		 
		 void colorPoint(int x, int y){
		 	if(size == TINY){
		 		 colorize(x, y);
		 	}else {
		 		for(int i = x-size; i <= x+size;i++){
		 			for(int j = y-size; j <= y+size; j++){
		 				colorize(i, j);
		 			}
		 		}
		 	}
		 }
		 
		 void line(int xi,int yi,int xf,int yf) {
		 	int dx,dy,i,xinc,yinc,cumul,x,y ;
		 	x = xi ;
		 	y = yi ;
		 	dx = xf - xi ;
		 	dy = yf - yi ;
		 	xinc = ( dx > 0 ) ? 1 : -1 ;
		 	yinc = ( dy > 0 ) ? 1 : -1 ;
		 	dx = Math.abs(dx) ;
		 	dy = Math.abs(dy) ;
		 	colorPoint(x,y);
		 	if ( dx > dy ) {
		 	  cumul = dx / 2 ;
		 	  for ( i = 1 ; i <= dx ; i++ ) {
		 	    x += xinc ;
		 	    cumul += dy ;
		 	    if (cumul >= dx) {
		 	      cumul -= dx ;
		 	      y += yinc ; }
		 	   colorPoint(x,y); } }
		 	  else {
		 	  cumul = dy / 2 ;
		 	  for ( i = 1 ; i <= dy ; i++ ) {
		 	    y += yinc ;
		 	    cumul += dx ;
		 	    if ( cumul >= dy ) {
		 	      cumul -= dy ;
		 	      x += xinc ; }
		 	   colorPoint(x,y); } }
		 	}
		 
		 public void fill(int iInit, int jInit, int iFinal, int jFinal){
		 	if(iInit > iFinal){
	 			int tmp = iInit;
	 			iInit = iFinal;
	 			iFinal = tmp;
	 		}
	 		if(jInit > jFinal){
	 			int tmp = jInit;
	 			jInit = jFinal;
	 			jFinal = tmp;
	 		}
	 		lb.setText(iInit + " " + jInit + " " + iFinal + " " + jFinal);
		 	for(int i = iInit; i<iFinal; i++){
    	 		for(int j=jInit; j<jFinal; j++){
    	 			colorPoint(i,j);
    	 		}
    	 	}
		 }
		    public void mouseReleased(MouseEvent e) {
		   }

		    public void mouseEntered(MouseEvent e) {
		    }

		    public void mouseExited(MouseEvent e) {
//		       if(patchIndex<(patchesNames.size()-3))	patchIndex++;
//		    	else patchIndex = 0;
//		    	colorRefresh();
		    }

		    public void mouseClicked(MouseEvent e) {}
		    public void mouseDragged(MouseEvent e){
		    	if(drawing==POINT){
			    	int x = e.getX()/getCellSize();
			        int y = e.getY()/getCellSize();
			        colorPoint(x,y);
//			       System.out.println(x+" "+y+" "+markColor);
		       }
		    	
			}
		    
		    public void mouseMoved(MouseEvent e){
		    	lb.setText("X:" +e.getX()/getCellSize() + " Y:"+ (e.getY())/getCellSize());
		    }
		
		    public void mouseWheelMoved(MouseWheelEvent e) {     }

		private JPanel panel;
		class ColorAction extends AbstractAction //dfinition de l'objet ColorAction qui hrite de la classe AbstractAction
		{
		    public ColorAction(String n, Icon i, Color c) //constucteur de l'objet
		    {   
		    //mthode du package javax.swing.Action
		        putValue(Action.NAME, n);
		        putValue(Action.SMALL_ICON, i);
		        putValue(Action.SHORT_DESCRIPTION, "The color is " + n);
		        putValue("Color" ,c);
		    }
		    public ColorAction(String n, Icon i, int size) //constucteur de l'objet
		    {   
		    //mthode du package javax.swing.Action
		        putValue(Action.NAME, n);
		        putValue(Action.SMALL_ICON, i);
		        putValue(Action.SHORT_DESCRIPTION, "The color is " + n);
		        putValue("Size" ,new Integer(size));
		    }
		    
		    public void actionPerformed(ActionEvent e) //gestionnaire d'evts
		    {
		    	Object t[] = getKeys();
		    	for(int i = 0; i<t.length; i++){
		    		System.out.println(t[i]);
		    		if(t[i].equals("Color")) markColor = (Color)getValue("Color");
		    		if(t[i].equals("Size")) size = ((Integer)(getValue("Size"))).intValue();
		    	}
		    	System.out.println(markColor + " " + size);
//		        panel.setBackground(markColor);//puis le panel met la couleur comme background
		        panel.repaint();//repaint le panel (la couleur est mise  jour..)
		    }
		}
}