/*
* TurtleKit - A 'reactive simulation platform' using MadKit Kernel
* Copyright (C) 2000-2007 Fabien Michel, Gregory Beurier
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package turtlekit2.kernel;

import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * <p>Title : TabbedLauncherPanel</p>
 * <p>Description : The awful graphical Panel of TurtleKit2. XML Tree et XML editor. If somebody is interested in refining 
 * this GUI, contact me: beurier@lirmm.fr :D </p>
 * @author Gregory Beurier
 */

public class TabbedLauncherPanel extends javax.swing.JPanel implements TreeSelectionListener {
    Document document;
    String configPath;
    boolean compress = true;
    File configFile;
    AdapterNode displayedNode;
    static final int windowHeight = 460;
    static final int leftWidth = 300;
    static final int rightWidth = 340;
    static final int windowWidth = leftWidth + rightWidth;
    Launcher launcher;
    
    /** Creates new form XmlTree */
    public TabbedLauncherPanel(String path, Launcher l) {
        configPath = path;
        launcher = l;
        initComponents();
        initXmlParsing();
        jSplitPane1.setRightComponent(l.getOnScreen());
    }
    
    /** Parse the xml tree */
    private void initXmlParsing(){
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            configFile =  new File(configPath);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse( configFile);
        } catch (SAXParseException spe) {
            // Error generated by the parser
            System.out.println("\n** Parsing error"+ ", line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
            System.out.println("   " + spe.getMessage() );
            // Use the contained exception, if any
            Exception  x = spe;
            if (spe.getException() != null) x = spe.getException();
            x.printStackTrace();
            
        } catch (SAXException sxe) {
            // Error generated during parsing)
            Exception  x = sxe;
            if (sxe.getException() != null) x = sxe.getException();
            x.printStackTrace();
            
        } catch (ParserConfigurationException pce) {
            // Parser with specified options can't be built
            pce.printStackTrace();
            
        } catch (IOException ioe) {
            // I/O error
            ioe.printStackTrace();
        }
        
        
        // Set up the tree
        JTree xmlTree = new JTree(new DomToTreeModelAdapter());
        jTree1 = xmlTree;
        JScrollPane treeView = new JScrollPane(jTree1);
        treeView.setPreferredSize( new Dimension( leftWidth, windowHeight ));
        jSplitPane2.setLeftComponent(jTree1);
        
        jTree1.addTreeSelectionListener(this);
        
    }
    
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jSplitPane1 = new javax.swing.JSplitPane();
        jSplitPane2 = new javax.swing.JSplitPane();
        jTree1 = new javax.swing.JTree();
        editPanel = new javax.swing.JPanel();
        jSplitPane3 = new javax.swing.JSplitPane();
        editButtonPanel = new javax.swing.JPanel();
        saveButton = new javax.swing.JButton();
        remButton = new javax.swing.JButton();
        addButton = new javax.swing.JButton();
        launchButton = new javax.swing.JButton();
        resetButton = new javax.swing.JButton();
        commitButton = new javax.swing.JButton();
        textBoxPanel = new javax.swing.JPanel();
        rightPanel = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        setAutoscrolls(true);
        jSplitPane1.setDividerSize(10);
        jSplitPane1.setAutoscrolls(true);
        jSplitPane1.setOneTouchExpandable(true);
        jSplitPane1.setPreferredSize(new java.awt.Dimension(0, 0));
        jSplitPane2.setDividerSize(10);
        jSplitPane2.setAutoscrolls(true);
        jSplitPane2.setMinimumSize(new java.awt.Dimension(492, 382));
        jSplitPane2.setOneTouchExpandable(true);
        jTree1.setMaximumSize(new java.awt.Dimension(200, 100));
        jTree1.setMinimumSize(new java.awt.Dimension(50, 50));
        jTree1.setPreferredSize(new java.awt.Dimension(354, 548));
        jTree1.setRootVisible(false);
        jTree1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTree1MouseClicked(evt);
            }
        });

        jSplitPane2.setLeftComponent(jTree1);

        editPanel.setLayout(new java.awt.BorderLayout());

        editPanel.setAlignmentX(0.0F);
        editPanel.setAlignmentY(0.0F);
        editPanel.setAutoscrolls(true);
        editPanel.setMaximumSize(new java.awt.Dimension(0, 0));
        editPanel.setMinimumSize(new java.awt.Dimension(0, 0));
        jSplitPane3.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        editButtonPanel.setLayout(new java.awt.GridLayout(1, 0));

        saveButton.setText("Save simulation config");
        saveButton.setAutoscrolls(true);
        saveButton.setMaximumSize(new java.awt.Dimension(20, 35));
        saveButton.setMinimumSize(new java.awt.Dimension(20, 35));
        saveButton.setPreferredSize(new java.awt.Dimension(20, 30));
        saveButton.setRequestFocusEnabled(false);
        saveButton.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        saveButton.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveButtonActionPerformed(evt);
            }
        });

        editButtonPanel.add(saveButton);

        remButton.setText("removeNode");
        remButton.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        remButton.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        remButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                remButtonActionPerformed(evt);
            }
        });

        editButtonPanel.add(remButton);

        addButton.setText("addNode");
        addButton.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        addButton.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        editButtonPanel.add(addButton);
        addButton.getAccessibleContext().setAccessibleName("addButton");

        launchButton.setText("Launch");
        launchButton.setName("Launch");
        launchButton.setVerifyInputWhenFocusTarget(false);
        launchButton.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        launchButton.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        launchButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                launchButtonActionPerformed(evt);
            }
        });

        editButtonPanel.add(launchButton);

        resetButton.setText("Reset config");
        resetButton.setAutoscrolls(true);
        resetButton.setPreferredSize(new java.awt.Dimension(30, 35));
        resetButton.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        resetButton.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        resetButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resetButtonActionPerformed(evt);
            }
        });

        editButtonPanel.add(resetButton);

        commitButton.setText("Commit");
        commitButton.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        commitButton.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        commitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                commitButtonActionPerformed(evt);
            }
        });

        editButtonPanel.add(commitButton);

        jSplitPane3.setTopComponent(editButtonPanel);

        textBoxPanel.setLayout(new java.awt.GridLayout(0, 2, 30, 10));

        jSplitPane3.setRightComponent(textBoxPanel);

        editPanel.add(jSplitPane3, java.awt.BorderLayout.CENTER);

        jSplitPane2.setRightComponent(editPanel);

        jSplitPane1.setLeftComponent(jSplitPane2);

        jSplitPane1.setRightComponent(rightPanel);

        add(jSplitPane1, java.awt.BorderLayout.CENTER);

    }
    // </editor-fold>//GEN-END:initComponents

    private void commitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_commitButtonActionPerformed
        launcher.setSimulationNode(document.getDocumentElement());
        //System.out.println(((AdapterNode)(jTree1.getModel().getRoot())).getNode());
    }//GEN-LAST:event_commitButtonActionPerformed
    
    private void launchButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_launchButtonActionPerformed
        if(jTree1.getModel().isLeaf(displayedNode)){
            Element parameters = (Element) displayedNode.getNode();
            NamedNodeMap attributeList = parameters.getAttributes();
            int listLength = attributeList.getLength();
            XMLAttributes paramTable = new XMLAttributes();
            for(int k=0; k<listLength;k++) {
                paramTable.put(attributeList.item(k).getNodeName(),parameters.getAttribute(attributeList.item(k).getNodeName()));
            }
            String type = displayedNode.getNode().getNodeName();
            if(type.equals("Observer")){
                launcher.newObserver(paramTable);
            }else if(type.equals("Viewer")){
                launcher.newViewer(paramTable);
            }/*else if(type.equals("Manager")){
                launcher.newManager(paramTable);
            }*/else if(type.equals("Parameters")){
            	String nodeIdentifier = new Integer(getIndex(displayedNode.getNode().getParentNode().getParentNode())).toString()+new Integer(getIndex(displayedNode.getNode().getParentNode())).toString();
            	paramTable.put("node",nodeIdentifier);
            	paramTable.put("groupNode",new Integer(getIndex(displayedNode.getNode().getParentNode().getParentNode())).toString());
                paramTable.put("agentType", ((Element)(displayedNode.getNode().getParentNode())).getAttribute("agentType"));
                System.out.println(nodeIdentifier);
                launcher.newAgents(paramTable,1);
            }else if(type.equals("Gene")){
                System.out.println("Cannot be instancied dynamically yet.");
            }
        }else{
            String type = displayedNode.getNode().getNodeName();
            if(type.equals("Observers")){
                NodeList observersNodes = ((Element)displayedNode.getNode()).getElementsByTagName("Observer");
                launcher.initializeObservers(observersNodes);
            }else if(type.equals("Viewers")){
                NodeList viewersNodes = ((Element)displayedNode.getNode()).getElementsByTagName("Viewer");
                launcher.initializeViewers(viewersNodes);
            }/*else if(type.equals("Managers")){
                NodeList managersNodes = ((Element)displayedNode.getNode()).getElementsByTagName("Manager");
                launcher.initializeViewers(managersNodes);
            }*/else if(type.equals("Agents")){
                NodeList agentNodes = ((Element)displayedNode.getNode()).getElementsByTagName("Agent");
                launcher.createInitialPopulation(agentNodes,getIndex(displayedNode.getNode()));
            }else if(type.equals("Agent")){
            	Element agentDescription = (Element)displayedNode.getNode();
                String agentType = agentDescription.getAttribute("agentType");
                int nbAgents = Integer.parseInt(agentDescription.getAttribute("nbAgents"));
                NodeList parametersList = agentDescription.getElementsByTagName("Parameters");
                Element parameters = (Element)parametersList.item(0);
                NamedNodeMap attributeList = parameters.getAttributes();
                int listLength = attributeList.getLength();
                XMLAttributes agentAttribute = new XMLAttributes();
                for(int k=0; k<listLength;k++) {
                    agentAttribute.put(attributeList.item(k).getNodeName(),parameters.getAttribute(attributeList.item(k).getNodeName()));
                }
                String nodeIdentifier = new Integer(getIndex(displayedNode.getNode().getParentNode())).toString()+new Integer(getIndex(displayedNode.getNode())).toString();
                agentAttribute.put("node",nodeIdentifier);
                agentAttribute.put("groupNode",new Integer(getIndex(displayedNode.getNode().getParentNode())).toString());
                agentAttribute.put("agentType",agentType);
//                System.out.println(nodeIdentifier);
                launcher.newAgents(agentAttribute, nbAgents);
            }else if(type.equals("Pool")){
                System.out.println("Cannot be instancied dynamically yet.");
            }else if(type.equals("Pools")){
                System.out.println("Cannot be instancied dynamically yet.");
            }
        }
        
        
        
        launcher.launch(displayedNode.getNode());
    }//GEN-LAST:event_launchButtonActionPerformed
    
    
    
    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
        Node newNode = displayedNode.getNode().cloneNode(true);
        displayedNode.getNode().getParentNode().appendChild(newNode);
    }//GEN-LAST:event_addButtonActionPerformed
    
    private void remButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_remButtonActionPerformed
        displayedNode.getNode().getParentNode().removeChild(displayedNode.getNode());
    }//GEN-LAST:event_remButtonActionPerformed
    
    private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveButtonActionPerformed
        saveXml(configFile);
    }//GEN-LAST:event_saveButtonActionPerformed
    
    public void saveXml(File file){
        try{
            //FileOutputStream fos = new FileOutputStream(configFile);
            Transformer serializer;
            ByteArrayOutputStream bout;
            serializer = TransformerFactory.newInstance().newTransformer();
            bout = new ByteArrayOutputStream();
            serializer.transform(new DOMSource(document), new StreamResult(bout));
            FileWriter fw = new FileWriter(file,false);
            DOMSource source = new DOMSource(document);
            fw.write(bout.toString());
            fw.flush();
            fw.close();
            
        } catch(Exception e){
            System.err.println("A l'arrache: problemes d'ecritures" + e);
        }
    }
    
    private void resetButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetButtonActionPerformed
        initXmlParsing();
        textBoxPanel.removeAll();
    }//GEN-LAST:event_resetButtonActionPerformed
    
    private void jTree1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTree1MouseClicked
        
    }//GEN-LAST:event_jTree1MouseClicked
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JButton commitButton;
    private javax.swing.JPanel editButtonPanel;
    private javax.swing.JPanel editPanel;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JSplitPane jSplitPane2;
    private javax.swing.JSplitPane jSplitPane3;
    private javax.swing.JTree jTree1;
    private javax.swing.JButton launchButton;
    private javax.swing.JButton remButton;
    private javax.swing.JButton resetButton;
    private javax.swing.JPanel rightPanel;
    private javax.swing.JButton saveButton;
    private javax.swing.JPanel textBoxPanel;
    // End of variables declaration//GEN-END:variables
    // An array of names for DOM node-types
    // (Array indexes = nodeType() values.)
    static final String[] typeName = {
        "none",
                "Element",
                "Attr",
                "Text",
                "CDATA",
                "EntityRef",
                "Entity",
                "ProcInstr",
                "Comment",
                "Document",
                "DocType",
                "DocFragment",
                "Notation",
    };
    static final int ELEMENT_TYPE =   Node.ELEMENT_NODE;
    static final int ATTR_TYPE =      Node.ATTRIBUTE_NODE;
    static final int TEXT_TYPE =      Node.TEXT_NODE;
    static final int CDATA_TYPE =     Node.CDATA_SECTION_NODE;
    static final int ENTITYREF_TYPE = Node.ENTITY_REFERENCE_NODE;
    static final int ENTITY_TYPE =    Node.ENTITY_NODE;
    static final int PROCINSTR_TYPE = Node.PROCESSING_INSTRUCTION_NODE;
    static final int COMMENT_TYPE =   Node.COMMENT_NODE;
    static final int DOCUMENT_TYPE =  Node.DOCUMENT_NODE;
    static final int DOCTYPE_TYPE =   Node.DOCUMENT_TYPE_NODE;
    static final int DOCFRAG_TYPE =   Node.DOCUMENT_FRAGMENT_NODE;
    static final int NOTATION_TYPE =  Node.NOTATION_NODE;
    
    // The list of elements to display in the tree
    static final String[] treeElementNames = {
        "Simulations",
                "Simulation",
                "Flavors",
                "RandomFlavors",
                "Flavor",
                "Pools",
                "Pool",
                "Gene",
                "Agents",
                "Agent",
                "Parameters",
                "Managers",
                "Manager",
                "Viewers",
                "Viewer",
                "Observers",
                "Observer",
                
    };
    boolean treeElement(String elementName) {
        for (int i=0; i<treeElementNames.length; i++) {
            if ( elementName.equals(treeElementNames[i]) ) return true;
        }
        return false;
    }
    
    public int getIndex(Node node){
    	Element father = (Element)(node.getParentNode());
    	NodeList fatherSons = father.getElementsByTagName(node.getNodeName());
    	for(int i=0;i<fatherSons.getLength();i++){
            Node compareNode = fatherSons.item(i);
            if(compareNode == node) return i;
    	 }
    	return 0;
    }
    
    public void valueChanged(TreeSelectionEvent e) {
        TreePath p = e.getNewLeadSelectionPath();
        if (p != null) {
            AdapterNode adpNode = (AdapterNode) p.getLastPathComponent();
            adpNode.content();
        }
    }
    
    /** This class wraps a DOM node and returns the text we want to
     display in the tree. It also returns children, index values,
     and child counts. */
    public class AdapterNode{
        Node domNode;
        XMLAttributes xmlTable;
        Hashtable key_value = new Hashtable();
        Hashtable value_key = new Hashtable();
        Hashtable stringValue_key = new Hashtable();
        Hashtable stringKey_value = new Hashtable();
        Hashtable keyRemove = new Hashtable();
        
        public AdapterNode(org.w3c.dom.Node node) {
            domNode = node;
        }
        
        public String toString() {
            String s = "";
            /*s = typeName[domNode.getNodeType()];*/
            String nodeName = domNode.getNodeName();
            if (! nodeName.startsWith("#")) {
                s += " " + nodeName;
            }
            if (compress) {
                String t = domNode.toString().trim();
                int x = t.indexOf("\n");
                if (x >= 0) t = t.substring(0, x);
                s += " " + t;
                return s;
            }
            return s;
        }
        
        public String content() {
            displayedNode = this;
            textBoxPanel.removeAll();
            textBoxPanel.repaint();
            String s = "";
            NamedNodeMap attributes = domNode.getAttributes();
            int listLength = attributes.getLength();
            xmlTable = new XMLAttributes();
            for(int k=0; k<listLength;k++) {
                xmlTable.put(attributes.item(k).getNodeName(),((Element)domNode).getAttribute(attributes.item(k).getNodeName()));
                JTextField key = new JTextField(attributes.item(k).getNodeName());
                JTextField value = new JTextField(((Element)domNode).getAttribute(attributes.item(k).getNodeName()));
                
                key_value.put(key, value);
                value_key.put(value,key);
                stringValue_key.put(value.getText(), key.getText());
                stringKey_value.put(key.getText(),value.getText());
                key.addCaretListener(new CaretListener(){
                    public void caretUpdate(CaretEvent e) {
                        JTextField localKey = (JTextField)e.getSource();
                        JTextField localObject = (JTextField)key_value.get(localKey);
                        String localOldKeyName = (String)(stringValue_key.get(localObject.getText()));
                        ((Element)domNode).removeAttribute(localOldKeyName);
                        ((Element)domNode).setAttribute(localKey.getText(),localObject.getText());
                        stringValue_key.remove(stringKey_value.get(localOldKeyName));
                        stringKey_value.remove(localOldKeyName);
                        stringValue_key.put(localObject.getText(),localKey.getText());
                        stringKey_value.put(localKey.getText(),localObject.getText());
                        jTree1.repaint();
                    }
                }
                );
                
                value.addCaretListener(new CaretListener(){
                    public void caretUpdate(CaretEvent e) {
                        JTextField localObject = (JTextField)e.getSource();
                        JTextField localKey = (JTextField)value_key.get(localObject);
                        String localOldObjectName = (String)(stringKey_value.get(localKey.getText()));
                        ((Element)domNode).setAttribute(localKey.getText(),localObject.getText());
                        stringKey_value.remove(stringValue_key.get(localOldObjectName));
                        stringValue_key.remove(localOldObjectName);
                        stringValue_key.put(localObject.getText(),localKey.getText());
                        stringKey_value.put(localKey.getText(),localObject.getText());
                        jTree1.repaint();
                    }
                }
                );
                
                textBoxPanel.add(key);
                textBoxPanel.add(value);
                
            }
            s+= xmlTable.toString();
            return s;
        }
        
        
        
       
        
      /**
       * Return children, index, and count values
       */
        public int index(AdapterNode child) {
            //System.err.println("Looking for index of " + child);
            int count = childCount();
            for (int i=0; i<count; i++) {
                AdapterNode n = this.child(i);
                if (child.domNode == n.domNode) return i;
            }
            return -1; // Should never get here.
        }
        
        public AdapterNode child(int searchIndex) {
            //Note: JTree index is zero-based.
            Node node = domNode.getChildNodes().item(searchIndex);
            if (compress) {
                // Return Nth displayable node
                int elementNodeIndex = 0;
                for (int i=0; i<domNode.getChildNodes().getLength(); i++) {
                    node = domNode.getChildNodes().item(i);
                    if (node.getNodeType() == ELEMENT_TYPE && treeElement(node.getNodeName()) && elementNodeIndex++ == searchIndex) {
                        break;
                    }
                }
            }
            return new AdapterNode(node);
        }
        
        public int childCount() {
            if (!compress) {
                // Indent this
                return domNode.getChildNodes().getLength();
            }
            int count = 0;
            for (int i=0; i<domNode.getChildNodes().getLength(); i++) {
                Node node = domNode.getChildNodes().item(i);
                if (node.getNodeType() == ELEMENT_TYPE && treeElement( node.getNodeName() )) {
                    ++count;
                }
            }
            return count;
        }
        
        public Node getNode(){
            return domNode;
        }
    }
    
    /**
     * Utility class for DOM to Tree.
     * */
    public class DomToTreeModelAdapter implements javax.swing.tree.TreeModel {
        
        public Object  getRoot() {
            //System.err.println("Returning root: " +document);
            return new AdapterNode(document);
        }
        public boolean isLeaf(Object aNode) {
            AdapterNode node = (AdapterNode) aNode;
            if (node.childCount() > 0) return false;
            return true;
        }
        public int getChildCount(Object parent) {
            AdapterNode node = (AdapterNode) parent;
            return node.childCount();
        }
        public Object getChild(Object parent, int index) {
            AdapterNode node = (AdapterNode) parent;
            return node.child(index);
        }
        public int getIndexOfChild(Object parent, Object child) {
            AdapterNode node = (AdapterNode) parent;
            return node.index((AdapterNode) child);
        }
        public void valueForPathChanged(TreePath path, Object newValue) {
            
        }
        
        private Vector listenerList = new Vector();
        public void addTreeModelListener(TreeModelListener listener) {
            if ( listener != null
                    && ! listenerList.contains( listener ) ) {
                listenerList.addElement( listener );
            }
        }
        public void removeTreeModelListener(TreeModelListener listener) {
            if ( listener != null ) {
                listenerList.removeElement( listener );
            }
        }
        
        
        
        public void fireTreeNodesChanged( TreeModelEvent e ) {
            Enumeration listeners = listenerList.elements();
            while ( listeners.hasMoreElements() ) {
                TreeModelListener listener =
                        (TreeModelListener) listeners.nextElement();
                listener.treeNodesChanged( e );
            }
        }
        public void fireTreeNodesInserted( TreeModelEvent e ) {
            Enumeration listeners = listenerList.elements();
            while ( listeners.hasMoreElements() ) {
                TreeModelListener listener =
                        (TreeModelListener) listeners.nextElement();
                listener.treeNodesInserted( e );
            }
        }
        public void fireTreeNodesRemoved( TreeModelEvent e ) {
            Enumeration listeners = listenerList.elements();
            while ( listeners.hasMoreElements() ) {
                TreeModelListener listener =
                        (TreeModelListener) listeners.nextElement();
                listener.treeNodesRemoved( e );
            }
        }
        public void fireTreeStructureChanged( TreeModelEvent e ) {
            Enumeration listeners = listenerList.elements();
            while ( listeners.hasMoreElements() ) {
                TreeModelListener listener =
                        (TreeModelListener) listeners.nextElement();
                listener.treeStructureChanged( e );
            }
        }
    }
}
