package turtlekit2.guis;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

import org.flexdock.demos.util.DemoUtility;
import org.flexdock.demos.view.ViewDemo;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.util.SwingUtility;
import org.flexdock.view.Titlebar;
import org.flexdock.view.View;
import org.flexdock.view.Viewport;

import turtlekit2.kernel.Launcher;

public class ViewerGUI extends JPanel  implements DockingConstants{

	/**
	 * @param simuViewer
	 */
	public ViewerGUI() {
		super(new BorderLayout(0, 0));
		DockingManager.setFloatingEnabled(true);
		setBorder(new EmptyBorder(5, 5, 5, 5));
		Viewport viewport = new Viewport();
		add(viewport, BorderLayout.CENTER);
		
		View startPage = createStartPage();
		View view1 = createView("solution.explorer", "Solution Explorer");
		View view2 = createView("task.list", "Task List");
		View view3 = createView("class.view", "Class View");
		View view4 = createView("message.log", "Message Log");

		viewport.dock(startPage);
		startPage.dock(view1, WEST_REGION, .4f);
		startPage.dock(view2, SOUTH_REGION, .4f);
		startPage.dock(view4, EAST_REGION, .4f);
		view1.dock(view3, SOUTH_REGION, .4f);
		JToolBar toolBar = TkActionsFactory.createSimulationToolbar(new Launcher(),"24");
        add(toolBar, BorderLayout.PAGE_START);
		
		
	}

	
	private View createView(String id, String text) {
		View view = new View(id, text);
		view.addAction(CLOSE_ACTION);
		view.addAction(PIN_ACTION);

		JPanel p = new JPanel();
		//		p.setBackground(Color.WHITE);
		p.setBorder(new LineBorder(Color.GRAY, 1));

		JTextField t = new JTextField(text);
		t.setPreferredSize(new Dimension(100, 20));
		p.add(t);

		view.setContentPane(p);
		return view;
	}

	private View createStartPage() {
		String id = "startPage";
		View view = new View(id, null, null);
		view.setTerritoryBlocked(CENTER_REGION, true);
		view.setTitlebar(new Titlebar("simu",TkActionsFactory.createSimulationActions(new Launcher(), "16")));
        view.setContentPane(new ViewerPanel());
        View v = createView("t", "t");
        v.setTerritoryBlocked(CENTER_REGION, true);
		return view;
	}


	public static void main(String[] args) {
		DockingManager.setFloatingEnabled(true);
		
		JFrame f = new JFrame();
		f.setSize(800, 600);
		f.setContentPane(new ViewerGUI());
		SwingUtility.centerOnScreen(f);
        DemoUtility.setCloseOperation(f);
        f.setVisible(true);
	}

}
