/**
 * 
 */
package turtlekit2.guis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.util.SwingUtility;
import org.flexdock.view.Titlebar;
import org.flexdock.view.View;
import org.flexdock.view.Viewport;

/**
 * @author fab
 *
 */
public class SimuGUI extends JPanel  implements DockingConstants{
	/**
	 * 
	 */
	public SimuGUI() {
		super(new BorderLayout(0, 0));
		DockingManager.setFloatingEnabled(true);
		setBorder(new EmptyBorder(5, 5, 5, 5));
		Viewport viewport = new Viewport();
		add(viewport, BorderLayout.CENTER);

		View startPage = createViewerPage();
		View startPage2 = createViewerPage();
		View view1 = createView("solution.explorer", "Solution Explorer");
		View view2 = createView("task.list", "Task List");
		View view3 = createView("class.view", "Class View");

		
		viewport.dock(startPage);
		viewport.dock(startPage2);
		startPage.dock(view1, WEST_REGION, .4f);
		startPage.dock(view2, SOUTH_REGION, .4f);
		view1.dock(view3, SOUTH_REGION, .4f);
}

	private View createView(String id, String text) {
		View view = new View(id, text);
		view.addAction(CLOSE_ACTION);
		view.addAction(PIN_ACTION);

		JPanel p = new JPanel();
		//		p.setBackground(Color.WHITE);
		p.setBorder(new LineBorder(Color.GRAY, 1));

		JTextField t = new JTextField(text);
		t.setPreferredSize(new Dimension(100, 20));
		p.add(t);

		view.setContentPane(p);
		return view;
	}

	private View createViewerPage() {
		String id = "viewerPage";
		View view = new View(id, null, null);
		view.setTerritoryBlocked(CENTER_REGION, true);
		view.setTitlebar(new Titlebar("simu"));
        view.setContentPane(new ViewerGUI());
		return view;
	}
	/**
	 * @param args
	 */
	public static void main(String[] args) {
	
		JFrame f = new JFrame();
		f.setSize(800, 600);
		f.setContentPane(new SimuGUI());
		SwingUtility.centerOnScreen(f);
        DemoUtility.setCloseOperation(f);
        f.setVisible(true);
	}

}
