/*
 * Genetic Package Copyright (C) 2002-2007 Gregory Beurier
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package turtlekit2.genetic;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
/**GUI of Pool.
 @author Gregory BEURIER
 */
public class PoolGUI extends JPanel {
	ExtendedJPopupMenu genomePopupMenu;

	Pool myPool;

	public PoolGUI(Pool pool) {
		myPool = pool;
		refresh();
	}

	public void createPopupMenu(){
		genomePopupMenu = new ExtendedJPopupMenu();

		JMenuItem saveGenome = new JMenuItem("Save");
		JMenuItem replaceGenome = new JMenuItem("Replace");
		JMenuItem resetGenome = new JMenuItem("Reset");
		JMenuItem noteGenome = new JMenuItem("Note Genome");
		JMenuItem setFitness = new JMenuItem("SetFitness");
		JMenuItem setState = new JMenuItem("SetState");
		JMenuItem removeGenome = new JMenuItem("Remove");
		JMenuItem addGene = new JMenuItem("Add Gene to Genome");
		genomePopupMenu.add(saveGenome);
		genomePopupMenu.add(replaceGenome);
		genomePopupMenu.add(resetGenome);
		genomePopupMenu.add(noteGenome);
		genomePopupMenu.add(setFitness);
		genomePopupMenu.add(setState);
		genomePopupMenu.add(removeGenome);
		genomePopupMenu.add(addGene);

		saveGenome.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				saveGenomeEvent(evt);
			}
		});

		replaceGenome.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				replaceGenomeEvent(evt);
			}
		});
		
		resetGenome.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				resetGenomeEvent(evt);
			}
		});
		
		noteGenome.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				noteGenomeEvent(evt);
			}
		});

		setFitness.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				setFitnessEvent(evt);
			}
		});
		
		setState.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				setStateEvent(evt);
			}
		});
		
		removeGenome.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				removeGenomeEvent(evt);
			}
		});
		
		addGene.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent evt) {
				addGeneEvent(evt);
			}
		});
	}
	
	public void createPanelContent(){
		this.setLayout(new GridLayout(myPool.getSize(), 3, 25, 5));
		for (int i = 0; i < myPool.getSize(); i++) {
			ExtendedJButton genomeButton = new ExtendedJButton("Genome "+ new Integer(i).toString(), myPool.getGenome(i), i);
			genomeButton.addMouseListener(new MouseListener() {
				public void mouseClicked(MouseEvent m) {
					if ((m.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
						displayGenome(((ExtendedJButton) (m.getSource())).getGenome(),((ExtendedJButton) (m.getSource())).getIndex());
					}
				}
				public void mouseEntered(MouseEvent e) {}
				public void mousePressed(MouseEvent m) {
					if ((m.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {
						genomePopupMenu.show(m.getComponent(), m.getX(), m.getY(), ((ExtendedJButton) (m.getSource())).getGenome());
					}
				}
				public void mouseReleased(MouseEvent m) {
					if ((m.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {
						genomePopupMenu.show(m.getComponent(), m.getX(), m.getY(), ((ExtendedJButton) (m.getSource())).getGenome());
					}
				}

				public void mouseExited(MouseEvent e) {}
			});
			JLabel genomeAttribute = new JLabel(new Integer(myPool.getGenome(i).getState()).toString());
			JLabel genomeFitness = myPool.getGenome(i).getFitnessLabel();
			this.add(genomeButton);
			this.add(genomeFitness);
			this.add(genomeAttribute);
		}
	}
	
	public void refresh(){
		this.removeAll();
		createPopupMenu();
		createPanelContent();
	}
	
	public Genome getSelectedGenome(ActionEvent evt){
		JMenuItem me = (JMenuItem) (evt.getSource());
		ExtendedJPopupMenu parentMenu = (ExtendedJPopupMenu) (me.getParent());
		return ((Genome) (parentMenu.getObject()));
	}
	
	public void saveGenomeEvent(ActionEvent evt) {
		GeneticFileManager.saveGenome(this,getSelectedGenome(evt));
	}

	public void replaceGenomeEvent(ActionEvent evt) {
		Genome newGenome = GeneticFileManager.loadGenome(this);
		if(newGenome != null){
			int index = myPool.indexOf(getSelectedGenome(evt));
			myPool.remove(getSelectedGenome(evt));
			myPool.add(index, newGenome);
			refresh();
		}
	}

	public void resetGenomeEvent(ActionEvent evt) {
		getSelectedGenome(evt).reset();
	}
	
	public void noteGenomeEvent(ActionEvent evt) {
		String inputValue = JOptionPane.showInputDialog("Please input a new fitness value");
		getSelectedGenome(evt).setHadocFitness(new Double(inputValue).doubleValue());
	}
	
	public void setFitnessEvent(ActionEvent evt) {
		String inputValue = JOptionPane.showInputDialog("Please input a new fitness value");
		getSelectedGenome(evt).setFitness(new Double(inputValue).doubleValue());
	}
	
	public void setStateEvent(ActionEvent evt) {
		String inputValue = JOptionPane.showInputDialog("Please input a new state value");
		getSelectedGenome(evt).setState(new Integer(inputValue).intValue());
	}
	
	public void removeGenomeEvent(ActionEvent evt) {
		myPool.remove(getSelectedGenome(evt));
		refresh();
	}

	public void addGeneEvent(ActionEvent evt) {
		Gene newGene = GeneticFileManager.loadGene(this);
		if(newGene != null){
			Genome selectedGenome = getSelectedGenome(evt);
			selectedGenome.add(newGene);
			System.out.println("This genome should be now incompatible with others genomes");
		}
	}
	
	public void displayGenome(Genome g) {
		displayGenome(g, 0);
	}

	public void displayGenome(Genome g, int index) {
		JFrame genomeFrame = new JFrame("Genome " + index + " from " + g.getPoolName());
		genomeFrame.setSize(350, 200);// taille
		JPanel genomePan = g.getPanel();
		genomeFrame.getContentPane().add(genomePan,	java.awt.BorderLayout.CENTER);
		genomeFrame.setVisible(true);
	}
}
