/*
 * Genetic Package Copyright (C) 2002-2007 Gregory Beurier
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package turtlekit2.genetic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import turtlekit2.kernel.Observer;
import turtlekit2.kernel.XMLAttributes;



/**
 * <p>Title : Fitness Manager Class.  </p>
 * <p>Description : Managers are observers scheduled by Metamanager. Their first role is to observe a specific group of agents
 * to evaluate them and give a fitness value to their genomes. </p>
 * <p></p>
 * <p>XML Attributes : given in the metamanger class</p>
 * <p>Monitor: determines which agents are observed by the manager. default is all.
 * Options: 
 * "pool". Monitor the pool given by "Monitored".
 * "node". Monitor the pool given by "Monitored".
 * "role". Monitor the pool given by "Monitored".
 * "group". Monitor the pool given by "Monitored".
 * </p>
 * <p>Monitored: specify the monitored agents for pool, role, node, group.</p>
 * <p>Name:optional for name. default is FitnessManager</p>
 * <p></p>
 * @author Gregory Beurier
 */  
public class Manager extends Observer {

	boolean refreshDisplay = true; //temporaire A VIRER !!! a cause de probleme affichage agents pas cres
	ArrayList<GTurtle> monitoredAgents = new ArrayList<GTurtle>();
	MetaManager metaManager;
	double fitness = - 10000;
	double fitnessMax = 100;
	JFrame agentFrame = new JFrame();
	JPanel agentsPan = new JPanel();
	Hashtable<GTurtle, Genome> agentGenome = new Hashtable<GTurtle, Genome>();
	
	public Manager(){}
	public void setManagerAttributes(XMLAttributes attributes){
		attrib = attributes;
	}
	
	
	public void clear(){
		monitoredAgents.clear();
		agentGenome.clear();
	}
	
	public void update(int simuStep){
		System.out.println(attrib.getString("Name") + " activated at step: " + simuStep);
		if(refreshDisplay && attrib.containsKey("Display") && attrib.getBool("Display")) {
			createFrame();
			refreshDisplay = false;
		}
	}//updated methods
	synchronized public void watch() {} //updated methods

	public void setFitnessTo(GTurtle turtle, double fitness){
		for(int i=0; i<monitoredAgents.size();i++){
			if((monitoredAgents.get(i)).equals(turtle))
				(monitoredAgents.get(i)).getGenome().setFitness(fitness);
		}
	}
	
	public void createFrame(){
		String name = "FitnessManager";
		if(getAttrib().containsKey("Name")) name = getAttrib().getString("Name");
        agentFrame.setTitle(name);
        agentFrame.setSize(650,300);
        agentsPan.removeAll();
        agentsPan.setLayout(new java.awt.GridLayout(monitoredAgents.size(),3, 25, 5));
        for(int i =0; i<monitoredAgents.size();i++ ){
            ExtendedJButton agentButton = new ExtendedJButton(monitoredAgents.get(i).getName(), monitoredAgents.get(i).getGenome(),i);
            agentButton.addActionListener(new ActionListener(){
                public void actionPerformed(ActionEvent m){
                	monitoredAgents.get( ((ExtendedJButton)(m.getSource())).getIndex()).createFrame();
                }
            });
            JLabel toString = new JLabel("Tmp");
            JLabel genome = new JLabel(monitoredAgents.get(i).getGenome().toString());
            agentsPan.add(agentButton);
            agentsPan.add(toString);
            agentsPan.add(genome);
        }
        agentFrame.getContentPane().add(agentsPan, java.awt.BorderLayout.CENTER);
        //agentFrame.show();
    }
	public void setFitnessToAll(double fitness){
		for(int i=0; i<monitoredAgents.size();i++){
			note((monitoredAgents.get(i)),fitness);
		}
	}
	
	public void note(GTurtle agent, double fitness){
		double fitnessHarmonized = (fitness/getFitnessMax())*100;
		(agentGenome.get(agent)).setFitness(this,fitnessHarmonized);
//		System.out.println(((Genome)(agentGenome.get(agent))));
	}
	
	public void noteAll(int fitness){
		for(int i=0;i<getMonitoredAgents().size();i++){
			GTurtle probedAgent = getMonitoredAgents().get(i);
			note(probedAgent,fitness);
		}
	}
	
	public void addAgentToMonitor(GTurtle turtle, Genome originalGenome){
		monitoredAgents.add(turtle);
		agentGenome.put(turtle,originalGenome);
		refreshDisplay = true;
	}
	public String toString(){
		return attrib.toString();
	}
	
	public double getFitnessMax() {
		return fitnessMax;
	}
	public void setFitnessMax(double perfectFitness) {
		this.fitnessMax = perfectFitness;
	}
	/**
	 * @return Returns the monitoredAgents.
	 */
	public ArrayList<GTurtle> getMonitoredAgents() {
		return monitoredAgents;
	}
	/**
	 * @param monitoredAgents The monitoredAgents to set.
	 */
	public void setMonitoredAgents(ArrayList<GTurtle> monitoredAgents) {
		this.monitoredAgents = monitoredAgents;
	}
	/**
	 * @return Returns the metaManager.
	 */
	public MetaManager getMetaManager() {
		return metaManager;
	}
	/**
	 * @param metaManager The metaManager to set.
	 */
	public void setMetaManager(MetaManager metaManager) {
		this.metaManager = metaManager;
	}
}
