/*
* Genetic Package for TurtleKit 2: TurtleKit - A 'reactive simulation platform' using MadKit Kernel
* Copyright (C) 2002-2007 Gregory Beurier
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package turtlekit2.genetic;


import turtlekit2.kernel.XMLAttributes;


/**
 * <p>Titre : Gene java interface</p>
 * <p>Description : It defines the standard methods used for genes in the genetic engine.
 * You have to instanciate it in order to define new genes. </p>
 * <p></p>
 * <p>XML Attributes : depends on subclasses</p>
 * GeneClass: the class of the Gene. default is "turtlekit2.genetic.BitGene".
 * @author Gregory Beurier
 */  

public interface Gene {
	//attributes methods
	public String getName();
	public void setName(String name);
	public void setAttrib(XMLAttributes geneAttribute);
	public XMLAttributes getAttrib();
	
	//genetic methods
	public void cross(Gene fatherGene, Gene motherGene);
	public void mutate();
	public void setFixed(boolean fix);
	public boolean isFixed();
	
	//gene utils
	public Object clone();
	public boolean isEqual(Gene gene);
	public void init();
}