/*
* Genetic Package for TurtleKit 2: TurtleKit - A 'reactive simulation platform' using MadKit Kernel
* Copyright (C) 2002-2007 Gregory Beurier
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package turtlekit2.genetic;

import javax.swing.JButton;

/**
 * GUI Class

@author Gregory BEURIER
 */
public class ExtendedJButton extends JButton{
    Object g;
    int index;
    
    public ExtendedJButton(String name, Genome gen, int i){
        super(name);
        g = (Object)gen;
        index = i;
    }
    
    public ExtendedJButton(String name, Gene gen, int i){
        super(name);
        g = (Object)gen;
        index = i;
    }
    
    public ExtendedJButton(String name, GTurtle tur, int i){
        super(name);
        g = (Object)tur;
        index = i;
    }
    
    public GTurtle getTurtle(){
    	return (GTurtle)g;
    }
    public Genome getGenome(){
        return (Genome)g;
    }
    
    public Gene getGene(){
        return (Gene)g;
    }
    
    public int getIndex(){
        return index;
    }
}