/*
 * TurboMethodActivator.java - Simulation: the general classes for handling simulation in MadKit
 * Copyright (C) 1998-2007 Fabien Michel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package madkit.simulation.activators;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import madkit.kernel.AbstractAgent;
import madkit.kernel.Activator;

/** Optimized version of the SingleMethodActivator can only invoke a simple method with no parameters
@version 2.0
@author Fabien Michel*/

public class TurboMethodActivator extends Activator<AbstractAgent>
{     
	final private String method;
	/** methods maps an agent to its corresponding Method object for runtime invocation*/
	final protected Map<AbstractAgent,Method> methods;
	private boolean debug=false;

	public TurboMethodActivator(final String methodName, final String groupName, final String roleName)
	{
		super(groupName, roleName);
		method = methodName;
		methods = new HashMap<AbstractAgent, Method>();
	}

	public TurboMethodActivator(final String methodName, final String communityName, final String groupName, final String roleName)
	{
		super(communityName, groupName, roleName);
		method = methodName;
		methods = new HashMap<AbstractAgent, Method>();
	}

	public String getMethodName()	{
		return method;
	}

	synchronized public void initialize()	{
		for (final AbstractAgent a: getCurrentAgentsList())
			setMethodFor(a);
	}

	synchronized public void update(final AbstractAgent theAgent, final boolean added)	{
		if(added)
			setMethodFor(theAgent);
		else
			methods.remove(theAgent);
	}

	synchronized public void execute()
	{
		for(final Map.Entry<AbstractAgent, Method> entry : methods.entrySet())	{
				try {
					entry.getValue().invoke(entry.getKey());
				} catch (final IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (final IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (final InvocationTargetException e) {					
					if (debug) {
						e.printStackTrace();
					}
				}
		}
	}

	final private void setMethodFor(final AbstractAgent theAgent)
	{
		try	{
			methods.put(theAgent,theAgent.getClass().getMethod(method));
		}
		catch (final NoSuchMethodException e)	{
			System.err.println("Can't find method: "+method+" on "+theAgent.toString()+"\nHints: - verify that the agent is correctly placed in your organization\n       - verify that the agent implements the Refenrenceable interface");
		}
	}
	
	/**
	 * @param b true means that the activator will not display caught errors due to invocation problems. This is useful when agents are often killed and relaunched during the same simulation. This avoids to have exception messages when invoking methods on dead agents.  
	 */
	public void setDebugOff(boolean b){
		debug = !b;
	}



}









