package modulecoGUI.graphicBuilder;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import javax.swing.table.AbstractTableModel;

import modulecoFramework.utils.graphicalWatcher.watchers.LineChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.NormalWatcher;

public class SeriesTableModel extends AbstractTableModel {
	
	Map mapSeries;
	NormalWatcher normalWatcher;
	
	private Object[] objects = new Object[0];/*{
			"Test",
			new Color(120,255,120)
	};*/
	
	private String[] columnNames = new String[]{"Nom de la Srie","Couleur"};
	/*private Object[][] data = new Object[][]{objects};*/
	
	public SeriesTableModel(NormalWatcher normalWatcher) {
		super();
		this.normalWatcher = normalWatcher;
		mapSeries = new HashMap();
	}
	
	public void updateSeries() {
		//System.out.println("updateSeries");
		fireTableDataChanged();
	}

	public int getColumnCount() {
		return columnNames.length;
	}
	
	public int getRowCount() {
		//System.out.println("getNumberOfSeries : "+normalWatcher.getNumberOfSeries());
		return normalWatcher.getNumberOfSeries();
	}
	
	public String getColumnName(int col) {
		return columnNames[col];
	}
	
	public Object getValueAt(int row, int col) {
		//System.out.println("getValueAt : "+row+" , "+col);
		//System.out.println("seriesName : "+normalWatcher.getSerieName(row));
		//System.out.println("color : "+normalWatcher.getColor(row));
		if (col==0) {
			return normalWatcher.getSerieName(row);
		}
		else if (col==1){
			return normalWatcher.getColor(row);
		}
		return null;
	}
	
	public Class getColumnClass(int c) {
		//System.out.println("getColumnClass : "+0+" , "+c);
		//if (getValueAt(0, c) != null) {
			return getValueAt(0, c).getClass();
		//}
		//return String.class;
	}
	
	/*
	 * Don't need to implement this method unless your table's
	 * editable.
	 */
	public boolean isCellEditable(int row, int col) {
		return true;
	}
	
	/*
	 * Don't need to implement this method unless your table's
	 * data can change.
	 */
	public void setValueAt(Object value, int row, int col) {
		//System.out.println("Set value at "+row+" , "+col);
		if (col==0) {
			normalWatcher.setSerieName(row,value.toString());
			System.out.println("new Serie name for row "+row+" : "+normalWatcher.getSerieName(row));
		}
		else if (col==1) {
			normalWatcher.setColor(row,(Color)value);
		}
		fireTableCellUpdated(row, col);
		fireTableDataChanged();
	}
}
