package modulecoGUI.graphicBuilder;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;

import modulecoFramework.utils.graphicalWatcher.probes.Filter;
import modulecoFramework.utils.graphicalWatcher.watchers.CountWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.LineChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.NormalWatcher;

public class FilterTableModel extends AbstractTableModel {
	
	Filter filter;
	Object bean;
	Field[] fields;
	Map mapClass;
	
	private String[] columnNames = new String[]{"Log","Propriet","Oprateur","Valeur"};
	
	public FilterTableModel(Object o, Filter filter) {
		super();
		this.filter = filter;
		this.bean = o;
		mapClass = new HashMap();
		fields = this.bean.getClass().getFields();
		for (int i = 0; i < fields.length; i++) {
			mapClass.put(fields[i].getName(),fields[i].getType());
		}
	}
	
	public void updateSeries() {
		//System.out.println("updateSeries");
		fireTableDataChanged();
	}

	public int getColumnCount() {
		return columnNames.length;
	}
	
	public int getRowCount() {
		//System.out.println("getNumberOfSeries : "+normalWatcher.getNumberOfSeries());
		if (filter.getNbFiltres() == 0) {
			return 2;
		}
		return filter.getNbFiltres()+1;
	}
	
	public String getColumnName(int col) {
		return columnNames[col];
	}
	
	public Object getValueAt(int row, int col) {
		if (filter.getNbFiltres() == 0) {
			if (row == 0) {
				if (col == 1) {
					return fields[0].getName();
				}
				else if (col == 2) {
					return "==";
				}
				else {
					return "";
				}
			}
			else {
				return "";
			}
		}
		else if (row == this.getRowCount()-1) {
			return "";
		}
		/*if (col==0 && row==0) {
			return "";
		}*/
		else if (col==0) {
			String s = filter.getLogicalOperator(row);
			if (s != null) {
				return filter.getLogicalOperator(row);
			}
			else {
				return "";
			}
		}
		else if (col==1){
			return filter.getProperty(row);
		}
		else if (col==2){
			int op = filter.getOp(row);
			if (op == Filter.EQUAL) {
				return "==";
			}
			else if (op == Filter.DIFF) {
				return "<>";
			}
			else if (op == Filter.INF) {
				return "<";
			}
			else if (op == Filter.SUP) {
				return ">";
			}
			else if (op == Filter.INF_OR_EQUAL) {
				return "<=";
			}
			else if (op == Filter.SUP_OR_EQUAL) {
				return ">=";
			}
		}
		else if (col==3){
			return filter.getValue(row);
		}
		return null;
	}
	
	/*public Class getColumnClass(int c) {
		return getValueAt(0, c).getClass();
	}*/
	
	/*
	 * Don't need to implement this method unless your table's
	 * editable.
	 */
	public boolean isCellEditable(int row, int col) {
		if (filter.getNbFiltres() == 0 && col == 0) {
			return false;
		}
		if (row == this.getRowCount()-1 && col!=0) {
			return false;
		}
		return true;
	}
	
	/*
	 * Don't need to implement this method unless your table's
	 * data can change.
	 */
	public void setValueAt(Object value, int row, int col) {

		if (filter.getNbFiltres() == 0) {
			System.out.println("Adding first constraints");
			System.out.println(value+" : "+value.getClass().getName());
			filter.addConstraints(fields[0].getName(),this.createInitialObject(fields[0].getType()),Filter.EQUAL,null);
		}
		
		if (col==0 && row==this.getRowCount()-1) {
			System.out.println(value);
			filter.addConstraints(fields[0].getName(),this.createInitialObject(fields[0].getType()),Filter.EQUAL,(String) value);
		}
		else if (col==0 && value.equals("")) {
			filter.removeConstraints(row);
		}
		else if (col==0) {
			filter.setLogicalOperator(row, (String) value);
		}
		if (col == 1) {
			String oldProperty = filter.getProperty(row);
			if (! oldProperty.equals((String)value)) {
				filter.setProperty(row, (String)value);
				filter.setValue(row, this.createInitialObject((Class)mapClass.get(filter.getProperty(row))));
			}
		}
		else if (col == 2) {
			String op = (String) value;
			if (op.equals("==")) {
				filter.setOp(row, Filter.EQUAL);
			}
			else if (op.equals("<>")) {
				filter.setOp(row, Filter.DIFF);
			}
			else if (op.equals("<=")) {
				filter.setOp(row, Filter.INF_OR_EQUAL);
			}
			else if (op.equals("<")) {
				filter.setOp(row, Filter.INF);
			}
			else if (op.equals(">=")) {
				filter.setOp(row, Filter.SUP_OR_EQUAL);
			}
			else if (op.equals(">")) {
				filter.setOp(row, Filter.SUP);
			}
		}
		if (col == 3) {
			System.out.println("Setting value : "+value+" - "+value.getClass());
			filter.setValue(row, this.getObject(fields[row].getType(),(String)value));
		}
		fireTableCellUpdated(row, col);
		fireTableDataChanged();
	}
	
	public Object getObject(Class c, String value) {
		Object o = null;
		if (c.equals(Integer.class) || c.equals(int.class)) {
			o = new Integer(value);
		}
		else if (c.equals(Double.class) || c.equals(double.class)) {
			o = new Double(value);
		}
		else if (c.equals(Long.class) || c.equals(long.class)) {
			o = new Long(value);
		}
		else if (c.equals(Float.class) || c.equals(float.class)) {
			o = new Float(value);
		}
		else if (c.equals(Boolean.class) || c.equals(boolean.class)) {
			o = new Boolean(value);
		}
		else if (c.equals(String.class)) {
			o = new String(value);
		}
		return o;
	}
	
	public Object createInitialObject(Class c) {
		Object o=null;
		if (c.equals(Integer.class) || c.equals(int.class)) {
			o = new Integer(0);
		}
		else if (c.equals(Double.class) || c.equals(double.class)) {
			o = new Double(0.0);
		}
		else if (c.equals(Long.class) || c.equals(long.class)) {
			o = new Long(0);
		}
		else if (c.equals(Float.class) || c.equals(float.class)) {
			o = new Float(0);
		}
		else if (c.equals(Boolean.class) || c.equals(boolean.class)) {
			o = new Boolean(true);
		}
		else if (c.equals(String.class)) {
			o = new String("");
		}
		return o;
	}
	
	public Object getBean() {
		return this.bean;
	}

	public Class getPropertyType(int row) {
		return fields[row].getType();
	}
}
