package modulecoGUI.graphicBuilder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.MemoryProbeTest;
import modulecoFramework.utils.graphicalWatcher.watchers.AbstractChartWatcher;
import modulecoFramework.utils.graphicalWatcher.watchers.LineChartWatcher;
import modulecoGUI.grapheco.AbstractCAgentRepresentation;

public class DynamicPieChart extends AbstractCAgentRepresentation{

	ChartPanel chartPanel;
	AbstractChartWatcher abstractChartWatcher;
	JFreeChart chart;
	DefaultPieDataset pieDataset;
	
	public DynamicPieChart(AbstractChartWatcher abstractChartWatcher) {
		
		this.name = "DynamicPieChart";
		
		this.abstractChartWatcher = abstractChartWatcher;
		
		this.setName("DynamicLineChart");
		this.setLayout(new BorderLayout());
		
		/*System.out.println("---------------------------------");
		System.out.println("New DynamicLineChart v2");
		System.out.println("\tNombre de srie : "+abstractChartWatcher.getNumberOfSeries());*/
		
		pieDataset = new DefaultPieDataset();
		
		for (int i = 0; i < abstractChartWatcher.getNumberOfSeries(); i++) {
			pieDataset.setValue(abstractChartWatcher.getSerieName(i), abstractChartWatcher.getLastValue(i));
		}

		chart = ChartFactory.createPieChart
        				("Sample Pie Chart",   // Title
        						pieDataset,           // Dataset
        						true,
        						true,
        						true// Show legend  
        				);
		
		PiePlot piePlot = (PiePlot) chart.getPlot();
		piePlot.setIgnoreNullValues(false);
		//piePlot.setIgnoreZeroValues(false);
		
		for (int i = 0; i < pieDataset.getItemCount(); i++) {
			System.out.println(i+" : ");
			Color color = abstractChartWatcher.getColor(i);
			piePlot.setSectionPaint(i,color);
		}
		
		chartPanel = new ChartPanel(chart);
		chartPanel.setMouseZoomable(true,true);
		this.add(chartPanel,BorderLayout.CENTER);
		this.validate();
		this.repaint();
		
	}
	
	public void updateImage() {
		double[] values;
		for (int i = 0; i < abstractChartWatcher.getNumberOfSeries(); i++) {
			pieDataset.setValue(abstractChartWatcher.getSerieName(i), abstractChartWatcher.getLastValue(i));
		}
	}

	public void resetImage() {
		
	}
	
	public JFreeChart getChart() {
		return chart;
	}

	
	
}
