/*
 * Created on 7 juin 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package modulecoGUI.cAgentEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/**
 * @author boudis
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class JConfigureAdditionnalParameters extends JPanel implements ActionListener {

	Object bean;
	int minRowHeight = 24;
	int intercellSpacing = 1;
	JDialog jDialog;
	
	JPanel jPanelButton;
	JButton jButtonOK;
	
	JTable tableParameters;
	
	public JConfigureAdditionnalParameters(Object bean, Component parent) {
		
		this.bean = bean;
		//this.setSize(new Dimension(600,600));
		this.build();
		jDialog = this.createDialog(parent);
		
	}
	
	public void build() {
		
		PropertyTableModel tableModelParameters = new PropertyTableModel(this.bean);
		
        PropertyColumnModel columnModelParameters = new PropertyColumnModel();
        tableParameters = new JTable(tableModelParameters, columnModelParameters);
		
        this.setTable(tableParameters);
        JScrollPane jScrollPane = new JScrollPane(tableParameters);
        
        jButtonOK = new JButton("OK");
        jButtonOK.addActionListener(this);
        
        jPanelButton = new JPanel(new FlowLayout());
        jPanelButton.add(jButtonOK);
        
        this.setLayout(new BorderLayout());
        
        this.add(jScrollPane,BorderLayout.CENTER);
        this.add(jPanelButton,BorderLayout.SOUTH);
        
        //System.out.println(jScrollPane.getPreferredSize());
        //System.out.println(tableParameters.getPreferredSize()+" ; "+tableParameters.getTableHeader().getPreferredSize().getHeight());
        //double H = tableParameters.getTableHeader().getPreferredSize().getHeight() + tableParameters.getPreferredSize().getHeight();
        //double W = tableParameters.getPreferredSize().getWidth();
        //this.setSize(new Dimension((int)W,(int)H+40));
        //this.setVisible(true);
        
        //Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        //this.setLocation((int)(dimension.getWidth()-this.getWidth())/2,(int)(dimension.getHeight()-this.getHeight())/2);
        
        //this.setAlwaysOnTop(true);
        
	}
	
	private void setTable(JTable table) {
		
        table.setGridColor(UIManager.getColor("control"));
        table.setBackground(UIManager.getColor("control"));
        table.setAutoResizeMode(JTable.AUTO_RESIZE_ALL_COLUMNS);
		
		table.setIntercellSpacing(new Dimension(10,intercellSpacing));
		
		for (int i=0;i<table.getRowCount();i++) {
        	Component c1 = table.getCellRenderer(i,1).getTableCellRendererComponent(table, table.getValueAt(i,1), false, false, i, 1);
        	Component c2 = table.getCellRenderer(i,2).getTableCellRendererComponent(table, table.getValueAt(i,2), false, false, i, 2);
        	Component c3 = table.getCellRenderer(i,3).getTableCellRendererComponent(table, table.getValueAt(i,3), false, false, i, 3);
        	
        	double c1H = c1.getPreferredSize().getHeight();
        	double c2H = c2.getPreferredSize().getHeight();
        	double c3H = c3.getPreferredSize().getHeight();
        	
        	if (c1H > c2H && c1H > c3H && c1H > minRowHeight) {
        		table.setRowHeight(i,(int)c1H);
        	}
        	else if (c2H > c1H && c2H > c3H && c2H > minRowHeight) {
        		table.setRowHeight(i,(int)c2H);
        	}
        	else {
        		table.setRowHeight(i,minRowHeight);
        	}
        }
		
		table.getTableHeader().setVisible(false);
		
	}
	
	public int showConfigureAdditionnalParameters() {
		jDialog.pack();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		jDialog.setLocation((screenSize.width-jDialog.getWidth())/2,(screenSize.height-jDialog.getHeight())/2);
		jDialog.setVisible(true);
		return 1;
	}
	
	protected JDialog createDialog(Component parent) throws HeadlessException {
		
		Container cont = SwingUtilities.getAncestorOfClass(JFrame.class, parent);
		if (cont!=null) {
			JDialog dialog = new JDialog((JFrame)cont);
	 		dialog.getContentPane().add(this);
	 		dialog.setModal(true);
	 		dialog.setTitle("Configurer les paramtres additionnels : ");
	 		dialog.invalidate();
	 		dialog.repaint();
		 	return dialog;
		}
		
		return null;
	}

	public void actionPerformed(ActionEvent evt) {
		
		if (evt.getSource().equals(jButtonOK)) {
			tableParameters.validate();
			jDialog.setVisible(false);
		}
		
	}
	
}
