/*
 * Created on 11 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package modulecoGUI;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import madkit.boot.Madkit;
import modulecoGUI.XMLGuiReader.XMLGuiReader;

/**
 * @author Thibaud Roussillat
 *
 * Correspond  la barre de commande en haut de l'interface. Les actions de l'utilisateur
 * sur les diffrents boutons sont relais au CentralControl
 */
public class JToolBarCommandes extends JToolBar implements ActionListener {

	/** serialVersionUID **/
	private static final long serialVersionUID = -2973030260914772908L;
	
	/** Le centralControl **/
	CentralControl centralControl;
	
	/** Les boutons de controle de la simulation - ceux-ci ne sont activ (setEnable(true) 
	 * que quand cela est ncessaire... (open ne fait pas parties de cette liste cela)
	 */
	List controlButtonList;
	
	/**
	 * Constructor : construit une nouvelle JToolBarCommande
	 * @param centralControl : le centralcontrol  contacter pour relayer les actions
	 */
	public JToolBarCommandes(CentralControl centralControl) {
		
		this.centralControl = centralControl;
		this.controlButtonList = new ArrayList();
		this.build();
		this.setControlButtonEnable(false);
		
	}
	
	/**
	 * Permet de mettre  Enable ou Disable les boutons de control de la simulation
	 * @param b : true = enable , false = disable
	 */
	public void setControlButtonEnable(boolean b) {
		for (Iterator i=controlButtonList.iterator();i.hasNext();) {
			((AbstractButton) i.next()).setEnabled(b);
		}
	}

	/**
	 * Construit les composants graphiques de JToolBar
	 */
	private void build() {
		
		/**
		 * TODO Changer les icones des boutons pour avoir quelque chose de plus classe
		 */
		JButton jButtonOpen = makeButton("Open","open",
				XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonOpen"),
				XMLGuiReader.getAltText("JToolBarCommandes/ButtonOpen"));
		this.add(jButtonOpen);
		
		this.addSeparator();
		
		JButton jButtonReload = makeButton("Reload","reload",
				XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonReload"),
				XMLGuiReader.getAltText("JToolBarCommandes/ButtonReload"));
		controlButtonList.add(jButtonReload);
		this.add(jButtonReload);
		
		this.addSeparator();
		
		JButton jButtonPlay = makeButton("Play","play",
				XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonPlay"),
				XMLGuiReader.getAltText("JToolBarCommandes/ButtonPlay"));
		controlButtonList.add(jButtonPlay);
		this.add(jButtonPlay);
		
		JButton jButtonStepByStep = makeButton("StepByStep","spetbystep",
				XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonStepByStep"),
				XMLGuiReader.getAltText("JToolBarCommandes/ButtonStepByStep"));
		controlButtonList.add(jButtonStepByStep);
		this.add(jButtonStepByStep);
		
		JButton jButtonPause = makeButton("Pause","pause",
				XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonPause"),
				XMLGuiReader.getAltText("JToolBarCommandes/ButtonStepByStep"));
		controlButtonList.add(jButtonPause);
		this.add(jButtonPause);
		
		JButton jButtonStop = makeButton("Stop","stop",
				XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonStop"),
				XMLGuiReader.getAltText("JToolBarCommandes/ButtonStepByStep"));
		controlButtonList.add(jButtonStop);
		this.add(jButtonStop);
		
		this.addSeparator();
		
		JButton jButtonHisto = makeButton("Histo","newBarChart",
				XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonNewBarChart"),
				XMLGuiReader.getAltText("JToolBarCommandes/ButtonNewBarChart"));
		controlButtonList.add(jButtonHisto);
		this.add(jButtonHisto);
		
		JButton jButtonCurve = makeButton("Curve","newLineChart",
				XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonNewLineChart"),
				XMLGuiReader.getAltText("JToolBarCommandes/ButtonNewLineChart"));
		controlButtonList.add(jButtonCurve);
		this.add(jButtonCurve);
		
		JButton jButtonPieChart = makeButton("PieChart","newPieChart",
				XMLGuiReader.getToolTipText("JToolBarCommandes/ButtonNewPieChart"),
				XMLGuiReader.getAltText("JToolBarCommandes/ButtonNewPieChart"));
		controlButtonList.add(jButtonPieChart);
		this.add(jButtonPieChart);
		
		this.addSeparator();
		
		this.add(this.makeJLabel("Timer","GVT is 0","The timer","Icon Timer"));
		
	}
	
	/**
	 * makeButton : construit un nouveau bouton de Control en prenant en paramtre :
	 * @param imageName : le nom de l'image dans le repertoire images/JToolBarCommandes
	 * @param actionCommand : le nom de l'actionCommand
	 * @param toolTipText :  le toolTipText
	 * @param altText : le text au cas o l'image n'existe pas
	 * @return un JButton
	 */
	protected JButton makeButton(String imageName, String actionCommand, String toolTipText, String altText) {
		
		//Create and initialize the button.
		JButton button = new JButton();
		button.setActionCommand(actionCommand);
		button.setToolTipText(toolTipText);
		button.addActionListener(this);

		//Look for the image.
		URL url = getClass().getResource("/images/JToolBarCommandes/"+imageName+".gif");

        if (url != null) {                      //image found
			button.setIcon(new ImageIcon(url, altText));
		} 
		else {                                     //no image found
			button.setText(altText);
			System.err.println("Resource not found: " + "/images/JToolBarCommandes/"+imageName+".gif");
		}
		return button;
	}
	
	protected JLabel makeJLabel(String imageName, String label, String toolTipText, String altText) {
		
		URL url = getClass().getResource(imageName+".gif");
        JLabel jLabel;
        if(url != null) {
        	jLabel = new JLabel(label,new ImageIcon(url,altText),JLabel.LEFT);
        }
        else {
        	jLabel = new JLabel(label,new ImageIcon(altText),JLabel.LEFT);
        }
		UIManager.put("jLabelIteration", jLabel);
		return jLabel;
		
	}

	/**
	 * Gre les actions faites par l'utilisateur et les envoie 
	 * au centralControl
	 */
	public void actionPerformed(ActionEvent e) {
		
		String actionCommand = e.getActionCommand();
		if ("open".equals(actionCommand)) {
			centralControl.openJFileChooserForModele();
		}
		
		else if ("reload".equals(actionCommand)) {
			centralControl.reload();
		}
		
		else if ("play".equals(actionCommand)) {
			centralControl.simulationStart();
		}
		
		else if ("spetbystep".equals(actionCommand)) {
			centralControl.simulationMstep();
		}
		
		else if ("pause".equals(actionCommand)) {
			centralControl.simulationStop();
		}
		
		else if ("stop".equals(actionCommand)) {
			centralControl.simulationStop();
		}
		
		else if ("newBarChart".equals(actionCommand)) {
			centralControl.createChart(CentralControl.BAR_CHART);
		}
		else if ("newLineChart".equals(actionCommand)) {
			centralControl.createChart(CentralControl.LINE_CHART);
		}
		else if ("newPieChart".equals(actionCommand)) {
			centralControl.createChart(CentralControl.PIE_CHART);
		}
		
	}

	/**
	 * Appeler par le centralControl pour mettre  jour le nombre d'itration du modle
	 */
	public void updateIter(int iter) {
		JLabel jLabel = (JLabel)UIManager.get("jLabelIteration");
		jLabel.setText("GVT is "+Integer.toString(iter));
		jLabel.repaint();
	}
	
}
