package modulecoFramework.utils.graphicalWatcher.watchers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import madkit.kernel.ReferenceableAgent;
import modulecoFramework.Moduleco;
import modulecoFramework.utils.graphicalWatcher.probes.AutoCountMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.CountMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.MemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.SumMemoryProbe;

public class CountWatcher extends AbstractChartWatcher implements ReferenceableAgent {

	//List listProbes;
	//Vector vectorProbes;
	
	Map mapProbes;
	Map mapColors;
	Map mapAfficher;
	
	Vector vectorNames;
	Vector values;
	
	int numberOfSeries = 0;

	int noNameProbe=0;
	
	/** Pour le moment ne peut contenir qu'une probe... */
	//CountMemoryProbe countMemoryProbe;
	
	/**
	 * 
	 *
	 */
	public CountWatcher() {
		mapProbes = new HashMap();
		mapColors = new HashMap();
		mapAfficher = new HashMap();
		vectorNames = new Vector();
		values = new Vector();
	}
	
	public void activate() {
		this.requestRole(Moduleco.COMMUNITY, "WatcherGroup","WatcherRole", null);
	}
	
	public void observeAgents() {
		values = new Vector();
		for (Iterator iter = mapProbes.values().iterator(); iter.hasNext(); ) {
			((CountMemoryProbe) iter.next()).step();
		}
		//countMemoryProbe.step();
	}
	
	public String getSerieName(int i) {
		return (String)vectorNames.get(i);
	}
	
	/**
	 * 
	 * @param memoryProbe
	 * @param name permit to reference the probe on the Watcher
	 */
	public void addMemoryProbe(CountMemoryProbe memoryProbe, String name) {
		if (name == null) {
			name = "DefaultName "+noNameProbe++;
		}
		this.addProbe(memoryProbe);
		mapProbes.put(name,memoryProbe);
		mapColors.put(name,new Color(125,22,240));
		vectorNames.add(name);
		numberOfSeries ++;
		memoryProbe.step();
		values.add(Double.valueOf(memoryProbe.getLastValue()));
	}
	
	public Boolean getAfficher(int row) {
		return (Boolean)mapAfficher.get(vectorNames.get(row));
	}
	
	public void setAfficher(int row, Boolean boolean1) {
		mapAfficher.put(vectorNames.get(row),boolean1);
	}
	
	public void addMemoryProbe(CountMemoryProbe memoryProbe) {
		this.addMemoryProbe(memoryProbe,"probe"+(noNameProbe++));
	}
	
	
	public void removeMemoryProbe(CountMemoryProbe memoryProbe) {
		
		System.out.println("Try Removing probes : ");
		if (mapProbes.containsValue(memoryProbe)) {
			System.out.println("Removing probes : ");
			String name="";
			Object key=null;
			for (Iterator i=mapProbes.keySet().iterator();i.hasNext();){
				key = i.next();
				if (mapProbes.get(key).equals(memoryProbe)) {
					break;
				}				
			}
			mapProbes.remove(key);
			name = (String) key;
			for (int i = 0; i < vectorNames.size(); i++) {
				if (vectorNames.get(i).equals(name)) {
					values.remove(i);
				}
			}
			vectorNames.remove(name);
			numberOfSeries--;
		}
		
	}
	
	public double getLastValue(int numSerie) {
		return ((MemoryProbe)mapProbes.get(vectorNames.get(numSerie))).getLastValue();
	}

	public int getNumberOfSeries() {
		return numberOfSeries;
	}

	public void setSerieName(int numSerie, String name) {
		String oldName = (String)vectorNames.get(numSerie);
		MemoryProbe p = (MemoryProbe) mapProbes.get(oldName);
		mapProbes.remove(oldName);
		mapProbes.put(name,p);
		Color color = (Color) mapColors.get(oldName);
		mapColors.remove(oldName);
		mapColors.put(name,color);
		vectorNames.remove(numSerie);
		vectorNames.add(numSerie,name);
	}
	
	public void setColor(int numSerie, Color color) {
		String name = (String)vectorNames.get(numSerie);
		mapColors.put(name,color);
		System.out.println("setting color to "+color);
	}
	
	public Color getColor(int numSerie) {
		String name = (String)vectorNames.get(numSerie);
		Color color = (Color)mapColors.get(name);
		return color;
	}
	
	public void afficher() {
		/*System.out.println("---------------------------");
		System.out.println("LineChartWatcher :");
		System.out.println("\tvectorNames : ");*/
		
		for (int i = 0; i < vectorNames.size(); i++) {
			System.out.println("\t\t"+i+" : "+vectorNames.get(i));
		}
		/*System.out.println("\tmapProbes : ");
		for (Iterator i=mapProbes.keySet().iterator();i.hasNext();) {
			Object key = i.next();
			System.out.println("\t\t"+key+" : "+mapProbes.get(key));
		}*/
		
		/*
		System.out.println("\t");
		System.out.println("\t");
		System.out.println("\t");*/
	}

	public Object getFiltre(int numSerie) {
		return ((CountMemoryProbe)mapProbes.get(vectorNames.get(numSerie))).getFilter();
	}

	public void recalculate() {
		for (Iterator iter = mapProbes.values().iterator(); iter.hasNext(); ) {
			((CountMemoryProbe) iter.next()).recalculate();
		}
	}

}

