package modulecoFramework.utils.graphicalWatcher.watchers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import madkit.kernel.ReferenceableAgent;
import modulecoFramework.Moduleco;
import modulecoFramework.utils.graphicalWatcher.probes.AutoCountMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.AbstractMemoryProbe;
import modulecoFramework.utils.graphicalWatcher.probes.SumMemoryProbe;

public class CopyOfLineChartWatcher extends AbstractChartWatcher implements ReferenceableAgent {

	List listProbes;
	Vector vectorProbes;
	Map mapProbes;
	Map mapColors;
	int numberOfSeries = 0;
	
	Vector vectorNames;
	
	Vector values;
	boolean countProbe = false;
	
	int noNameProbe=0;
	
	public CopyOfLineChartWatcher() {
		listProbes = new ArrayList();
		vectorProbes = new Vector();
		mapProbes = new HashMap();
		mapColors = new HashMap();
		vectorNames = new Vector();
		values = new Vector();
	}
	
	public void activate() {
		this.requestRole(Moduleco.COMMUNITY, "WatcherGroup","WatcherRole", null);
	}
	
	public void observeAgents() {
		values = new Vector();
		
		if (countProbe) {
			AutoCountMemoryProbe cmp = (AutoCountMemoryProbe) vectorProbes.get(0);
			cmp.step();
			int nb = cmp.getNbSeries();
			for (int i=0;i<nb;i++) {
				values.add(Double.valueOf(cmp.getLastValue(nb)));
			}
		}
		else {
			for (Iterator i=listProbes.iterator();i.hasNext();) {
				AbstractMemoryProbe mp = (AbstractMemoryProbe) i.next();
				mp.step();
				values.add(Double.valueOf(mp.getLastValue()));
			}
		}
	}
	
	public String getSerieName(int i) {
		return (String)vectorNames.get(i);
	}
	
	/**
	 * 
	 * @param memoryProbe
	 * @param name permit to reference the probe on the Watcher
	 */
	public void addMemoryProbe(AbstractMemoryProbe memoryProbe, String name) {
		this.addProbe(memoryProbe);
		listProbes.add(memoryProbe);
		vectorProbes.add(memoryProbe);
		/**
		 * TODO : throw exception existing name for this watcher !!!
		 */
		mapProbes.put(name,memoryProbe);
		mapColors.put(name,new Color(125,22,240));
		vectorNames.add(name);
		memoryProbe.step();
	}
	
	public void addMemoryProbe(AbstractMemoryProbe memoryProbe) {
		this.addMemoryProbe(memoryProbe,"probe"+(noNameProbe++));
	}
	
	public void addCountProbe(AutoCountMemoryProbe countMemoryProbe) {
		countProbe = true;
		listProbes.clear();
		vectorProbes.clear();
		this.addMemoryProbe(countMemoryProbe);
		numberOfSeries = countMemoryProbe.getNbSeries();
	}
	
	/**
	 * use this method to add all memoryProbe (SumMemoryProbe, AvgMemoryProbe,...) expected CountMemoryProbe
	 * @param memoryProbe
	 */
	public void addNormalProbe(AbstractMemoryProbe memoryProbe, String name) {
		/* il y a avait une countProbe donc on l'enlve... */
		if (countProbe) {
			listProbes.clear();
			vectorProbes.clear();
			countProbe = false;
		}
		this.addMemoryProbe(memoryProbe, name);
		numberOfSeries ++;
	}
	
	public void removeMemoryProbe(AbstractMemoryProbe memoryProbe) {
		System.out.println("Try Removing probes : ");
		if (mapProbes.containsValue(memoryProbe)) {
			System.out.println("Removing probes : ");
			String name="";
			Object key=null;
			for (Iterator i=mapProbes.keySet().iterator();i.hasNext();){
				key = i.next();
				if (mapProbes.get(key).equals(memoryProbe)) {
					break;
				}				
			}
			mapProbes.remove(key);
			name = (String) key;
			listProbes.remove(memoryProbe);
			vectorProbes.remove(memoryProbe);
			vectorNames.remove(name);
			numberOfSeries--;
		}
		
	}
	
	public double getLastValue(int numSerie) {
		if (countProbe) {
			double result = ((AutoCountMemoryProbe)vectorProbes.get(0)).getLastValue(numSerie);
			System.out.println("\tResult : "+result);
			return result;
		}
		else {
			return ((AbstractMemoryProbe)vectorProbes.get(numSerie)).getLastValue();
		}
	}
	
	public double getValue(int pas, int numSerie) {
		if (countProbe) {
			return ((AutoCountMemoryProbe)vectorProbes.get(0)).getValue(pas);
		}
		else {
			return ((AbstractMemoryProbe)vectorProbes.get(numSerie)).getValue(pas);
		}
	}

	public int getNumberOfSeries() {
		return numberOfSeries;
	}

	public void setSerieName(int row, String name) {
		String oldName = (String)vectorNames.get(row);
		AbstractMemoryProbe p = (AbstractMemoryProbe) mapProbes.get(oldName);
		mapProbes.remove(oldName);
		mapProbes.put(name,p);
		vectorNames.add(row,name);
	}
	
	public void setColor(int row, Color color) {
		String name = (String)vectorNames.get(row);
		mapColors.put(name,color);
		System.out.println("setting color to "+color);
	}
	
	public Color getColor(int row) {
		String name = (String)vectorNames.get(row);
		Color color = (Color)mapColors.get(name);
		System.out.println("getting color to "+color);
		return color;
	}

}
