package modulecoFramework.utils.graphicalWatcher.probes;

import java.util.Iterator;

import madkit.kernel.AbstractAgent;

public class StdMemoryProbe extends AbstractMemoryProbe{

	public StdMemoryProbe(String community, String group, String role, String property) {
		super(community, group, role, property);
	}

	public Double calculate() {
		
		/** Calcul de la moyenne **/
		double sum = 0.0;
		int nb=0;
		for (Iterator<AbstractAgent> i=(Iterator<AbstractAgent>) this.getAgentsIterator();i.hasNext();) {
			try {
				sum = sum + this.getDouble(i.next());
				nb++;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		double moyenne = sum / (double)nb;
		
		/** Calcul de la variance **/
		double sumVar = 0.0;
		for (Iterator<AbstractAgent> i=(Iterator<AbstractAgent>) this.getAgentsIterator();i.hasNext();) {
			try {
				sumVar = sumVar + (this.getDouble(i.next())-moyenne);
				nb++;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		double var = sumVar / (double) nb;
		
		return new Double(Math.sqrt(var));
		
	}
	
	public double[] getValues() {
		return new double[0];
	}
	
}
