package modulecoFramework.utils.graphicalWatcher.probes;

import java.util.Vector;

import madkit.simulation.probes.ReflexiveProbe;

/**
 * 
 * @author Thibaud Roussillat
 * @date 14/06/05
 */

public abstract class MemoryProbeTest extends AbstractMemoryProbe{

	Vector[] values;
	int nbSeries=1;

	public MemoryProbeTest(String community, String group, String role, String property) {
		
		super(community, group, role, property);
		System.out.println("Building a Memory Probe...");
		
		values = new Vector[nbSeries];
		for (int i=0;i<nbSeries;i++) {
			values[i] = new Vector();
		}
		
	}
	
	public void step() {
		for (int i=0;i<nbSeries;i++) {
			values[i].add(calculate());
		}
	}
	
	public abstract Double calculate();
	
	public double getValue(int i, int serie) {
		return ((Double)values[serie].get(i)).doubleValue();
	}
	
	public double getLastValue(int serie) {
		return ((Double)values[serie].lastElement()).doubleValue();
	}

	public int getNbSeries() {
		return nbSeries;
	}

	public void setNbSeries(int nbSeries) {
		this.nbSeries = nbSeries;
	}
	
	

}
