package modulecoFramework.utils.graphicalWatcher.probes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import madkit.kernel.AbstractAgent;
import madkit.simulation.probes.ReflexiveProbe;

public class AutoCountMemoryProbe extends AbstractMemoryProbe {

	Map hashMapValues;
	Vector vectorValues;
	
	public AutoCountMemoryProbe(String community, String group, String role, String property) {
		super(community, group, role, property);
		hashMapValues = new HashMap();
		vectorValues = new Vector();
	}

	public double getLastValue(int numSerie) {
		/*System.out.println("getLastValue for serie : "+numSerie);
		System.out.println("value in vector : "+vectorValues.get(numSerie));
		System.out.println("value in hashMap : "+hashMapValues.get(vectorValues.get(numSerie)));*/
		return ((Integer) hashMapValues.get(vectorValues.get(numSerie))).doubleValue();
	}
	
	public int getNbSeries() {
		//return vectorValues.size();
		return hashMapValues.size();
	}
	
	public String getSerieName(int numSerie) {
		if (vectorValues != null) {
			return vectorValues.get(numSerie).toString();
		}
		return "no name available";
	}
	
	public double[] getValues() {
		double[] values = new double[hashMapValues.size()];
		Object[] val = hashMapValues.values().toArray();
		for (int i=0;i<values.length;i++) {
			values[i] = ((Integer) val[i]).doubleValue();
		}
		return values;
	}
	
	public Double calculate() {
		
		//System.out.println("Calculate for Count Probe...");
		//System.out.println("\tNombre d'agents : " + this.numberOfAgents());
		
		for (Iterator i=hashMapValues.keySet().iterator();i.hasNext();) {
			hashMapValues.put(i.next(),new Integer(0));
		}
		
		for (Iterator<AbstractAgent> i=(Iterator<AbstractAgent>) this.getAgentsIterator();i.hasNext();) {
			
			AbstractAgent agent = i.next();
			Object value = this.getObject(agent);
			
			Set keySet = hashMapValues.keySet();
			
			if (hashMapValues.containsKey(value)) {
				Integer nb = (Integer)hashMapValues.get(value);
				hashMapValues.put(value, new Integer(nb.intValue() +1));
			}
			else {
				hashMapValues.put(value,new Integer(1));
				vectorValues.add(value);
			}
			
		}
		
		/*System.out.println("Les valeurs : ");
		for (Iterator i=hashMapValues.keySet().iterator();i.hasNext();) {
			Object o = i.next();
			System.out.println(o+" : "+hashMapValues.get(o));
		}*/
		
		return new Double(-1.0);
		
	}
	
}
