package modulecoFramework.utils.dataRecorder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import madkit.kernel.AbstractAgent;
import madkit.kernel.Probe;
import madkit.kernel.ReferenceableAgent;
import madkit.kernel.Watcher;
import madkit.simulation.probes.ReflexiveProbe;
import modulecoFramework.Moduleco;
import modulecoFramework.simulation.scheduling.ModulecoScheduler;

/**
 *
 * @author Thibaud Roussillat
 * Cette classe permet d'enregistrer les valeurs des diff�rentes variables du
 * mod�le au cours de la simulation. Nous distinguons ici les variables du monde de celle des
 * agents pour faciliter la tache � l'utilisateur lors de l'utilisation de l'interface.
 * TODO : Attention, ici l'�criture des donn�es dans un fichier se fait directement (sortie au
 * format csv). Il sera indispensable par la suite de le faire au travers diff�rents objets,
 * permettant ainsi de changer de format ais�ment.
 *
 */
public class Recorder extends Watcher implements ReferenceableAgent {

       /** serialVersionUID **/
       private static final long serialVersionUID = -4741661027688183040L;

       /** Map contenant les probes pour sonder les variables **/
       public Map mapWorldProbe;
       public Map mapAgentProbe;
       //public Map mapProbe;

       /** Map contenant pour chaque variables l'ensemble des valeurs de chaque agent **/
       public Map mapWorldValues;
       public Map mapAgentValues;

       /** Sp�cifie si l'on doit enregistrer les donn�es dans un fichier **/
       public boolean writeDataInFile = true;

       /** Le fichier dans lequel on doit �crire et son writer **/
       /** TODO : faire cela � travers un objet qui g�re le format de sortie **/
       public File file;
       public FileWriter fileWriter;

       /** Le nombre d'it�ration **/
       public double iteration = 0;

       /**
        * Set the separator between values in the output file
        * A comm is recommended for the format Comma-Separated-Values (Excel CSV)
        */
       protected static String valuesSeparator = ",";

       /** Les arrayList qui contienne les noms des variables enregistrables, enregistr� et non enregistr� **/
       public List recordableWorldProperties;
       public List recordedWorldProperties;
       public List notRecordedWorldProperties;

       public List recordableAgentProperties;
       public List recordedAgentProperties;
       public List notRecordedAgentProperties;

       public String filePath;
       public String directoryPath;

       public boolean headerRecorded = false;

       /** --------- **/
       public Recorder() {

               mapAgentProbe = new HashMap();
               mapWorldProbe = new HashMap();

               mapAgentValues = new HashMap();
               mapWorldValues = new HashMap();

               recordableWorldProperties = new ArrayList();
               recordedWorldProperties = new ArrayList();
               notRecordedWorldProperties = new ArrayList();

               recordableAgentProperties = new ArrayList();
               recordedAgentProperties = new ArrayList();
               notRecordedAgentProperties = new ArrayList();

               /** R�cup�ration du chemin du fichier **/
               new File(System.getProperty("user.dir") + File.separator + "outputs" + File.separator).mkdir();
               directoryPath = System.getProperty("user.dir") + File.separator + "outputs";
               filePath = directoryPath + File.separator + Moduleco.getCurrentModelName() + ".csv";

               /** On cr�� un nouveau fichier pour v�rifier qu'un avec le m�me nom n'existe pas **/
               file = new File(filePath);
               if (file.exists()) {
                       int i = 0;
                       do {
                               //filePath = directoryPath + File.separator + Moduleco.getCurrentModelName() +"("+i+")" + ".csv";
                               filePath = directoryPath + File.separator + Moduleco.getCurrentModelName() +"_"+i + ".csv";
                               file = new File(filePath);
                               i++;
                       } while (file.exists());
               }
               //file.delete(); // Ce fichier est supprim�, il sera recr�e � l'�criture

       }

       public void activate() {

               this.requestRole(Moduleco.COMMUNITY, "WatcherGroup","WatcherRole", null);

               this.recordableWorldProperties = this.findRecordableWorldProperties();
               for (Iterator iter = recordableWorldProperties.iterator(); iter.hasNext();) {
                       notRecordedWorldProperties.add((String) iter.next());
               }

               this.recordableAgentProperties = this.findRecordableAgentProperties();
               for (Iterator iter = recordableAgentProperties.iterator(); iter.hasNext();) {
                       notRecordedAgentProperties.add((String) iter.next());
               }

       }

       /**
        *
        * @param community : the community
        * @param group : the group
        * @param role : the role
        * @return a list with the properties in the tab outputParameters[]
        */
       public List findRecordableProperties(String community, String group, String role) {

               Probe p = new Probe(community,group,role);
               this.addProbe(p);

               Iterator i = p.getCurrentAgentsList().iterator();
               List recordableProperties = null;

               if (i.hasNext()) {
                       Object agent = i.next();
                       String[] outputParameters = new String[0];
                       try {
                               outputParameters = (String[]) agent.getClass().getField("outputParameters").get(agent);
                       } catch (IllegalArgumentException e) {
                               e.printStackTrace();
                       } catch (SecurityException e) {
                               e.printStackTrace();
                       } catch (IllegalAccessException e) {
                               e.printStackTrace();
                       } catch (NoSuchFieldException e) {
                               e.printStackTrace();
                       }

                       recordableProperties = new ArrayList();
                       if(outputParameters !=  null)
                       for (int j = 0; j < outputParameters.length; j++) {
                               recordableProperties.add(outputParameters[j]);
                       }
               }

               this.removeProbe(p);

               return recordableProperties;
       }

       /** **/
       public List findRecordableAgentProperties() {

               String community = Moduleco.COMMUNITY;
               String group = Moduleco.AGENTS_GROUP;
               String role = "basicAgent";

               return this.findRecordableProperties(community, group, role);

       }

       /** **/
       public List findRecordableWorldProperties() {

               String community = Moduleco.COMMUNITY;
               String group = Moduleco.AGENTS_GROUP;
               String role = "environment";

               return this.findRecordableProperties(community, group, role);

       }

       /** **/
       public String[] getRecordedAgentProperies() {
               String[] properties = new String[recordedAgentProperties.size()];
               int i=0;
               for (Iterator iter = recordedAgentProperties.iterator(); iter.hasNext();) {
                       properties[i] = (String) iter.next();
                       i++;
               }
               return properties;
       }
        /** **/
       public String[] getNotRecordedAgentProperies() {
               String[] properties = new String[notRecordedAgentProperties.size()];
               int i=0;
               for (Iterator iter = notRecordedAgentProperties.iterator(); iter.hasNext();) {
                       properties[i] = (String) iter.next();
                       i++;
               }
               return properties;
       }

       /** **/
       public String[] getRecordedWorldProperies() {
               String[] properties = new String[recordedWorldProperties.size()];
               int i=0;
               for (Iterator iter = recordedWorldProperties.iterator(); iter.hasNext();) {
                       properties[i] = (String) iter.next();
                       i++;
               }
               return properties;
       }
        /** **/
       public String[] getNotRecordedWorldProperies() {
               String[] properties = new String[notRecordedWorldProperties.size()];
               int i=0;
               for (Iterator iter = notRecordedWorldProperties.iterator(); iter.hasNext();) {
                       properties[i] = (String) iter.next();
                       i++;
               }
               return properties;
       }

       public void recordAgentProperty(String property) {
               ReflexiveProbe rp = new ReflexiveProbe(Moduleco.COMMUNITY,Moduleco.AGENTS_GROUP,"basicAgent",property);
               this.addProbe(rp);
               mapAgentProbe.put(property,rp);
               notRecordedAgentProperties.remove(property);
               recordedAgentProperties.add(property);
       }

       public void eraseAgentProperty(String property) {
               ReflexiveProbe rp = (ReflexiveProbe) mapAgentProbe.get(property);
               this.removeProbe(rp);
               mapAgentProbe.remove(property);
               mapAgentValues.remove(property);
               recordedAgentProperties.remove(property);
               notRecordedAgentProperties.add(property);
       }

       public void recordWorldProperty(String property) {
               ReflexiveProbe rp = new ReflexiveProbe(Moduleco.COMMUNITY,Moduleco.AGENTS_GROUP,"environment",property);
               this.addProbe(rp);
               mapWorldProbe.put(property,rp);
               notRecordedWorldProperties.remove(property);
               recordedWorldProperties.add(property);
       }

       public void eraseWorldProperty(String property) {
               ReflexiveProbe rp = (ReflexiveProbe) mapWorldProbe.get(property);
               this.removeProbe(rp);
               mapWorldProbe.remove(property);
               mapWorldValues.remove(property);
               recordedWorldProperties.remove(property);
               notRecordedWorldProperties.add(property);
       }

       public File getFile() {
               return this.file;
       }

       public void setFilePath(String path) {
               if (! path.equals(filePath)) {
                       this.filePath = path;
                       file = new File(this.filePath);
                       headerRecorded = false;
               }

       }

       public String getFilePath() {
               return this.filePath;
       }

       public void observeAgents() {
       iteration=ModulecoScheduler.getGVT();
       //System.out.println("User Recorder : " + iteration);
               this.observeNewWorldValue();
               this.observeNewAgentValue();
               //System.out.println("Recording Agents");
               this.record();
       }

       private void observeNewWorldValue() {

               for (Iterator iter = mapWorldProbe.keySet().iterator(); iter.hasNext();) {

                       /* R�cup�ration de la sone */
                       String nomVar = (String) iter.next();
                       ReflexiveProbe p = (ReflexiveProbe) mapWorldProbe.get(nomVar);

                       /* Recup�ration du vecteur de valeur */
                       Vector values = (Vector) mapWorldValues.get(nomVar);
                       if (values == null) {
                               values = new Vector();
                               mapWorldValues.put(nomVar,values);
                       }

                       /* Parcours des agents */
                       Vector valuesT = new Vector();
                       for (AbstractAgent agt : p.getCurrentAgentsList()) {
	                          valuesT.add(p.getObject(agt));
                       }

                       values.add(valuesT);

               }

       }

       private void observeNewAgentValue() {

               for (Iterator iter = mapAgentProbe.keySet().iterator(); iter.hasNext();) {

                       /* R�cup�ration de la sone */
                       String nomVar = (String) iter.next();
                       ReflexiveProbe p = (ReflexiveProbe) mapAgentProbe.get(nomVar);

                       /* Recup�ration du vecteur de valeur */
                       Vector values = (Vector) mapAgentValues.get(nomVar);
                       if (values == null) {
                               values = new Vector();
                               mapAgentValues.put(nomVar,values);
                       }

                       /* Parcours des agents */
                       Vector valuesT = new Vector();
                       for (Iterator<AbstractAgent> i = (Iterator<AbstractAgent>) p.getAgentsIterator(); i.hasNext();) {
                               valuesT.add(p.getObject(i.next()));
                       }

                       values.add(valuesT);

               }

       }

       public void recordAllWorldProperty() {

               String community = Moduleco.COMMUNITY;
               String group = Moduleco.AGENTS_GROUP;
               String role = "environment";

               Probe p = new Probe(community,group,role);
               this.addProbe(p);

               Iterator<AbstractAgent> i = (Iterator<AbstractAgent>) p.getAgentsIterator();
               if (i.hasNext()) {
                       Object agent = i.next();
                       String[] outputParameters = new String[0];
                       try {
                               outputParameters = (String[]) agent.getClass().getField("outputParameters").get(agent);
                       } catch (IllegalArgumentException e) {
                               e.printStackTrace();
                       } catch (SecurityException e) {
                               e.printStackTrace();
                       } catch (IllegalAccessException e) {
                               e.printStackTrace();
                       } catch (NoSuchFieldException e) {
                               e.printStackTrace();
                       }
           if(outputParameters !=  null) {
                               for (int j = 0; j < outputParameters.length; j++) {
                                       ReflexiveProbe rp = new ReflexiveProbe(community,group,role,outputParameters[j]);
                                       this.addProbe(rp);
                                       mapWorldProbe.put(outputParameters[j],rp);
                                       notRecordedWorldProperties.remove(outputParameters[j]);
                                       recordedWorldProperties.add(outputParameters[j]);
                               }
           }
               }

               this.removeProbe(p);
       }

       public void recordAllAgentProperty() {

               String community = Moduleco.COMMUNITY;
               String group = Moduleco.AGENTS_GROUP;
               String role = "basicAgent";

               Probe p = new Probe(community,group,role);
               this.addProbe(p);

               Iterator i = p.getAgentsIterator();
               if (i.hasNext()) {
                       Object agent = i.next();
                       String[] outputParameters = new String[0];
                       try {
                               outputParameters = (String[]) agent.getClass().getField("outputParameters").get(agent);
                       } catch (IllegalArgumentException e) {
                               e.printStackTrace();
                       } catch (SecurityException e) {
                               e.printStackTrace();
                       } catch (IllegalAccessException e) {
                               e.printStackTrace();
                       } catch (NoSuchFieldException e) {
                               e.printStackTrace();
                       }
           if(outputParameters !=  null) {
                               for (int j = 0; j < outputParameters.length; j++) {
                                       ReflexiveProbe rp = new ReflexiveProbe(community,group,role,outputParameters[j]);
                                       this.addProbe(rp);
                                       mapAgentProbe.put(outputParameters[j],rp);
                                       notRecordedAgentProperties.remove(outputParameters[j]);
                                       recordedAgentProperties.add(outputParameters[j]);
                               }
           }
               }

               this.removeProbe(p);
       }

       public void record() {

               if (writeDataInFile) {

                       /* Si le fichier est nul : cr�ation du fichier et du fileWriter */
                       //if (file==null) {
                       if (! headerRecorded) {
                               /* Cr�ation du fichier */
                               file = new File(this.filePath);
                               /* Cr�ation du FileWriter et �criture de l'ent�te */
                               try {
                                       fileWriter = new FileWriter(file);
                                       this.recordHeader(fileWriter);
                                       fileWriter.close();
                                       headerRecorded = true;
                               } catch (IOException e) {
                                       e.printStackTrace();
                               }
                       }

                       try {
                               fileWriter = new FileWriter(file,true);
                               fileWriter.write("\n");
                               /* Write the time step */
                               fileWriter.write(""+iteration);
                       } catch (IOException e1) {
                               e1.printStackTrace();
                       }

                       /* Ecriture des valeurs pour le Monde */
                       for (Iterator iter = mapWorldValues.keySet().iterator(); iter.hasNext();) {
                               /* Ecriture des valeurs de la variable */
                               Object key = iter.next();
                               //System.out.println("Property : " + key);
                               Vector valuesT = (Vector) ((Vector) mapWorldValues.get(key)).lastElement();
                               try {
                                       for (int i = 0; i < valuesT.size(); i++) {
                                               //System.out.println("\tValues : "+valuesT.get(i));
                                               try {
                                                       Object value = valuesT.get(i);
                                                       /*if (value != null) {
                                                               System.out.println("\t\t"+value.getClass().getName());
                                                       }*/
                                                       String valueString = value.toString();
                                                       // Remplace '.' by ';' to match Excel format
                                                       if (Number.class.isAssignableFrom(value.getClass())) {
                                                               //valueString = valueString.replace(".",",");
                                                       }
                                                       else {
                                                               if (valueString.contains(";")) {
                                                                       valueString = "\"".concat(valueString.concat("\""));
                                                               }
                                                       }
                                                       fileWriter.write(valuesSeparator+valueString);
                                               }
                                               catch (Exception e) {
                                                       fileWriter.write(valuesSeparator);
                                               }
                                       }
                               } catch (IOException e) {
                                       e.printStackTrace();
                               }
                       }

                       /* Ecriture des valeurs pour les Agents */
                       for (Iterator iter = mapAgentValues.keySet().iterator(); iter.hasNext();) {
                               /* Ecriture des valeurs de la variable */
                               Object key = iter.next();
                               //System.out.println("Property : " + key);
                               Vector valuesT = (Vector) ((Vector) mapAgentValues.get(key)).lastElement();
                               try {
                                       for (int i = 0; i < valuesT.size(); i++) {
                                               //System.out.println("\tValues : "+valuesT.get(i));
                                               try {
                                                       Object value = valuesT.get(i);
                                                       /*if (value != null) {
                                                               System.out.println("\t\t"+value.getClass().getName());
                                                       }*/
                                                       String valueString = value.toString();
                                                       // Remplace '.' by ';' to match Excel format
                                                       //if (value.getClass().isAssignableFrom(Number.class)) {
                                                       if (Number.class.isAssignableFrom(value.getClass())) {
                                                               //valueString = valueString.replace(".",",");
                                                       }
                                                       else {
                                                               if (valueString.contains(";")) {
                                                                       valueString = "\"".concat(valueString.concat("\""));
                                                               }
                                                       }
                                                       fileWriter.write(valuesSeparator+valueString);
                                               }
                                               catch (Exception e) {
                                                       fileWriter.write(valuesSeparator);
                                               }
                                       }
                               } catch (IOException e) {
                                       e.printStackTrace();
                               }
                       }

                       try {
                               fileWriter.close();
                       } catch (IOException e) {
                               // TODO Auto-generated catch block
                               e.printStackTrace();
                       }

               }
       }

       private void recordHeader(FileWriter fileWriter) {

               try {
                       /* Ecriture de la colonne T */
                       fileWriter.write("T");

                       /* Ecriture du nom des agents pour World*/
                       for (Iterator iter = mapWorldProbe.keySet().iterator(); iter.hasNext();) {
                               /* Ecriture du nom de la variable */
                               Object key = iter.next();
                               /* Ecriture des noms d'agents pour World*/
                               Probe p = (Probe) mapWorldProbe.get(key);
                               for (Iterator i = p.getAgentsIterator(); i.hasNext();) {
                                       AbstractAgent aa = (AbstractAgent) i.next();
                                       fileWriter.write(valuesSeparator+aa.getName());
                               }
                       }

                       /* Ecriture du nom des agents pour Agent*/
                       for (Iterator iter = mapAgentProbe.keySet().iterator(); iter.hasNext();) {
                               /* Ecriture du nom de la variable */
                               Object key = iter.next();
                               /* Ecriture des noms d'agents */
                               Probe p = (Probe) mapAgentProbe.get(key);
                               for (Iterator i = p.getAgentsIterator(); i.hasNext();) {
                                       AbstractAgent aa = (AbstractAgent) i.next();
                                       fileWriter.write(valuesSeparator+aa.getName());
                               }
                       }

                       /* Saut de ligne */
                       fileWriter.write("\n");

                       /* Saut de case sous le T */
                       fileWriter.write("T");

                       /* Ecriture du nom de chaque variable pour World */
                       for (Iterator iter = mapWorldProbe.keySet().iterator(); iter.hasNext();) {
                               /* Ecriture du nom de la variable */
                               Object key = iter.next();
                               fileWriter.write(valuesSeparator+key);
                               /* Ecriture des blancs */
                               Probe p = (Probe) mapWorldProbe.get(key);
                               Iterator i = p.getAgentsIterator();
                               i.next();
                               while (i.hasNext()){
                                       fileWriter.write(valuesSeparator);
                                       i.next();
                               }
                       }

                       /* Ecriture du nom de chaque variable pour Agent */
                       for (Iterator iter = mapAgentProbe.keySet().iterator(); iter.hasNext();) {
                               /* Ecriture du nom de la variable */
                               Object key = iter.next();
                               fileWriter.write(valuesSeparator+key);
                               /* Ecriture des blancs */
                               Probe p = (Probe) mapAgentProbe.get(key);
                               Iterator i = p.getAgentsIterator();
                               i.next();
                               while (i.hasNext()){
                                       fileWriter.write(valuesSeparator);
                                       i.next();
                               }
                       }

               } catch (FileNotFoundException e) {
                       e.printStackTrace();
               } catch (IOException e) {
                       e.printStackTrace();
               }

       }

}
