/*
 * Created on 8 juin 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package modulecoFramework.utils;

import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import modulecoFramework.modeleco.EWorld;

/**
 * @author boudis
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ModelWriter {

	EWorld world;
	
	public ModelWriter(EWorld world) {
		
		this.world = world;
		
	}
	
	public void record(File f) {
		
		//File f = new File(fileName);
		System.out.println("ModelWriter.java : Recording parameters in File : "+f.getAbsolutePath());
		
		try {
			Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
			
			Element racine = document.createElement("model");
			racine.setAttribute("name",world.getModelParameters().getName());
			racine.setAttribute("length",String.valueOf(world.getModelParameters().getLength()));
			racine.setAttribute("neighbourhood",world.getModelParameters().getNeighbourhood());
			racine.setAttribute("zone",world.getModelParameters().getZone());
			
			/* Scheduling */
			Element scheduling = document.createElement("scheduling");
			
			Element role = document.createElement("role");
			role.setAttribute("name","basicAgent");
			role.setAttribute("activationType",world.getModelParameters().getTimeScheduler());
			role.setAttribute("activationOrder","1");
			
			scheduling.appendChild(role);
			
			racine.appendChild(scheduling);

			/* World */
			
			Element wElement = document.createElement("world");
			
			recordAdditionalObject(document,wElement,world);
			
			racine.appendChild(wElement);
			
			/* End */
			document.appendChild(racine);
			
			this.transformerXmlToFile(document, f);
			
		} catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	/**
	 * TODO : rcrire pour grer les ventuels champs qui ne serait pas mis en public 
	 * et donc non accessible... notamment entour la ligne 117 de try catch
	 * @param document
	 * @param element
	 * @param o
	 */
	public void recordAdditionalObject(Document document, Element element, Object o) {
		
		try {
			
			Field field = o.getClass().getField("inputParameters");
			String[] params = (String[]) field.get(o);
			
			//System.out.println("Recording " + o.getClass() + " , "+o.toString());
			
			/*Field[] fields = o.getClass().getFields();
			for (int i=0;i<fields.length;i++) {
				//System.out.println(fields[i].getName());
			}*/
			
			/* Pour chaque paramtre d'entre spcifier... */
			for (int i=0;i<params.length;i++) {
				
				Element elem = document.createElement(params[i]);
				
				Object value = o.getClass().getField(params[i]).get(o);
				
				/* Pour les valeurs  choix multiples... */
				try {
					HashMap mapString = (HashMap)o.getClass().getField("hashMapChoiceString").get(o);
					HashMap mapValue = (HashMap)o.getClass().getField("hashMapChoiceValue").get(o);
					Object[] strings = (Object[]) mapString.get(params[i]);
					Object[] objects = (Object[]) mapValue.get(params[i]);
					if ( strings != null && objects != null ) {
						for (int j=0;j<objects.length;j++) {
							if (objects[j].equals(value)) {						
								elem.setAttribute("value",strings[j].toString());
								try {
									Object obj = objects[j].getClass().getField("inputParameters");
									if (obj != null) {
										recordAdditionalObject(document, elem, value);
									}
								}
								catch (Exception e) {	
								}
							}
						} 
					}
					else {
						elem.setAttribute("value",value.toString());
					}
				}
				catch (Exception e) {
					//Quand getField(hashMap) a renvoy une erreur donc qd aucune valeur  choix multiple
					elem.setAttribute("value",value.toString());
				}
				
				element.appendChild(elem);
				
			}
			
		} catch (SecurityException e1) {
			e1.printStackTrace();
		} catch (NoSuchFieldException e1) {
			e1.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
		
	}
	
	public void transformerXmlToFile(Document document, File file) {
		   try {
		      // Cration de la source DOM
		      Source source = new DOMSource(document);

		      // Cration du fichier de sortie
		      //File file = new File(fichier);
		      Result resultat = new StreamResult(file.getAbsoluteFile());

		      // Configuration du transformer
		      TransformerFactory fabrique = TransformerFactory.newInstance();
		      Transformer transformer = fabrique.newTransformer();
		      transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		      transformer.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

		      // Transformation
		      transformer.transform(source, resultat);
		      
		   }catch(Exception e){
		      e.printStackTrace();
		   }
		}
	
	public void transformerXml(Document document, String fichier) {
		   try {
		      // Cration de la source DOM
		      Source source = new DOMSource(document);

		      // Cration du fichier de sortie
		      File file = new File(fichier);
		      Result resultat = new StreamResult(fichier);

		      // Configuration du transformer
		      TransformerFactory fabrique = TransformerFactory.newInstance();
		      Transformer transformer = fabrique.newTransformer();
		      transformer.setOutputProperty(OutputKeys.INDENT, "yes");
		      transformer.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

		      // Transformation
		      transformer.transform(source, resultat);
		      
		   }catch(Exception e){
		      e.printStackTrace();
		   }
		}
	
}
