/*
 * ModulecoActivator.java
 *
 * Created on 7 fvrier 2005, 17:09
 */

package modulecoFramework.simulation.scheduling;

import madkit.kernel.Activator;
import modulecoFramework.Moduleco;

/**
 * Basic Activator for Moduleco scheduling
 * @author Fabien Michel
 */
public abstract class ModulecoActivator extends Activator implements Comparable{
       
    private int index;

    /**
     * Creates a new instance of ModulecoActivator
     * @param role : the role to be played
     * @param orderIndex : the index of activation
     */
    public ModulecoActivator(String role, int orderIndex) {
        super(Moduleco.COMMUNITY,Moduleco.AGENTS_GROUP,role);
        index=orderIndex;
    }
    
    public int compareTo(Object o)
    {
        return index - ((ModulecoActivator) o).index;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
    
    public abstract SimEvent execute(double GVT, SimEvent theEvent);
}
