/**
 * EAgent.java
 * Copyright (c)enst-bretagne
 * @author Antoine.Beugnard@enst-bretagne.fr ; Denis.Phan@enst-bretagne.fr ;
 *         sebastien.chivoret@ensta.org
 * @version 1.0  May 2000
 * @version 1.2  August 2002
 * @version 1.4.2 June 2004
 */
package modulecoFramework.modeleco;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import modulecoFramework.medium.Medium;
import modulecoFramework.*;
import modulecoFramework.medium.NeighbourMedium;

// MadKit
import madkit.kernel.*;
// MadKit
/**
 * Je suis une classe abstraite qui reprsente des agents. Un agent connait des
 * voisins. L'volution est dcrite dans la mthode compute. La validation de
 * l'volution dans la mthode commit.
 * <p>
 * Bien que runnable, je m'excute dans le Thread courrant-celui du monde.
 * <p>
 * Les sous classes concrtes doivent redfinir compute, commit, getState et
 * toString.
 * <p>
 * Sous classes concrtes connues :
 * @see elem.Agent,
 * @see dp.Agent,
 * @see life.Agent La methode edit() est spcialise dans les sous-classes.
 *      Copyright: (c)enst-bretagne
 */
public abstract class EAgent extends AbstractAgent implements CAgent, ReferenceableAgent {
	/**
	 * agent ID is a number specific tothe Agent from 0 to (size-1)
	 */
	public int agentID;
	/**
	 * The Agent knows their world
	 */
	protected EWorld world;
	/**
	 * EAgent Medium for interaction between agents
	 */
	protected Medium[] mediums;
	protected int numbersOfMediums = 0; // The number of Mediums
	/**
	 * connectivity in the Agent neighbours'medium
	 */
	public int connectivity; // DP 13/09/2002
	/**
	 * Communications with probes by the way of Array List
	 */
	public ArrayList neighbours;
	
	/**
     * Reprsente sous forme de String les variables d'entre  afficher
     * TODO : reflchir sur le positionnement de ce tableaux. Voir pr le migrer ds une classe abstraite
     * pour la partager avec EAgent.
     */
	public String[] inputParameters; //Thib 31/5/05
	public String[] outputParameters; //Thib 31/5/05
	
	public HashMap hashMapChoiceValue; //Thib 09/08/05
    public HashMap hashMapChoiceString; //Thib 09/08/05
	
	public EAgent() {
		//fixed_ae=null; //SC 19.06.01
		mediums = new Medium[1];
		mediums[0] = new NeighbourMedium();
		
		inputParameters=new String[]{};
    	outputParameters=new String[]{};
    	
    	hashMapChoiceString = new HashMap();
    	hashMapChoiceValue = new HashMap();
    	
	}
	/**
	 * Required to be a CAgent
	 * Invoked by subclass <tt>ENeighbourWorld</tt>, when a new agent is created.
	 * <p>
	 * method get info is invoked after the agent constructor but before
	 * probe(descriptors) updates and initialisation.
	 * Mandatory method (inherited from its abstract superclass in <tt>EAgent</tt>)
	 * 
	 * @see modulecoFramework.modeleco.ENeighbourWorld
	 * @see modulecoFramework.modeleco.CAgent
	 */
	//
	//public abstract void getInfo();
	/**
	 * Invoked by SimulationControl.initSimulation() Initialise this EAgent
	 * Required to be a CAgent
	 * 
	 * @see modulecoFramework.modeleco.SimulationControl.initSimulation()
	 */
	public abstract void init();
	/**
	 * method to be invoked by the scheduler contain the internal deliberation
	 * of this EAgent Required to be a CAgent
	 * 
	 * @see modulecoFramework.modeleco.scheduler
	 */
	public abstract void compute();
	/**
	 * method to be invoked by the scheduler to implement the validation of
	 * cstate change after compute
	 * 
	 * @see modulecoFramework.modeleco.scheduler
	 */
	public abstract void commit();
	/**
	 * method terminate() close the current simulation for this agent invoked by
	 * EWorld.terminate()
	 * 
	 * @see modulecoFramework.modeleco.EWorld.terminate()
	 * @see modulecoFramework.modeleco.SimulationControl.terminate()
	 */
	public void terminate() {
		System.out.println("EAgent.terminate()");
		//closed();
	}
	//======================================================================
	public String pack() {
		String n = this.getClass().getName();
		return n.substring(0, n.lastIndexOf('.'));
	}
	/**
	 * setAgentID from ENeighbourWorld
	 */
	public void setAgentID(int agentID) {
		this.agentID = agentID;
		//System.out.println("EAgent.setAgentID = "+agentID);
	}
	public int getAgentID() {
		return agentID;
	}
	public void inverseState() {
		// BUG : PREVOIR DE REPRCUTER AUX INTERFACES ?
	}
	public Medium[] getMediums() {
		return mediums;
	}
	
	/**
	 * Permet d'accder  l'tat de l'EAgent
	 */
	public ArrayList getNeighbours() { // ajout DP 11/07/2002
		return neighbours;
	}
	
	public void setNeighbours(ArrayList nghbrs) { // ajout DP 18/09/2001
		neighbours = nghbrs;
		//System.out.println("EAgent.setNeighbours()");
	}
	
	public String toString() {
		return "AgentID : " + (new Integer(agentID)).toString();
		//EAgent.toString() ; Devrait tre redfinie...";
	}
	
	public void setWorld(EWorld w) {
		world = w;
	}
	
	public EWorld getWorld() {
		return world;
	}
        
    ///////////////////////	MadKit
	public void activate() {
            playRole("basicAgent");
            //init(); //thib 03/08/05 -> mthode appel dans initAll du monde
	}
	
    /**takes a role within the simulation*/
	public void playRole(String roleName) {
		requestRole(Moduleco.COMMUNITY, Moduleco.AGENTS_GROUP, roleName, null);
	}

	/**gives up a role within the simulation*/
	public void leaveRole(String roleName) {
		leaveRole(Moduleco.COMMUNITY, Moduleco.AGENTS_GROUP, roleName);
	}

	/** should be overide when the agent are in a discrete event simulation mode*/
	public double nextEventDeltaTime() {
		return 1;
	}
	//////////////////////// MadKit
	
	 /** 
     * Ajoute le paramtre de nom donn au vecteur inputParameters
     * @param s : le nom du paramtre
     */
    public void addInputParameters(String s) {
    	String[] temp = inputParameters;
    	inputParameters = new String[temp.length+1];
    	for (int i = 0; i < temp.length; i++) {
			inputParameters[i] = temp[i];
		}
    	inputParameters[temp.length] = s;
    }
    
    /** 
     * Ajoute les paramtres dont les noms sont dans le vecteur au vecteur inputParameters
     * @param s : le nom du paramtre
     */
    public void addInputParameters(String[] s) {
    	String[] temp = inputParameters;
    	inputParameters = new String[temp.length+s.length];
    	for (int i = 0; i < temp.length; i++) {
			inputParameters[i] = temp[i];
		}
    	for (int i = 0; i < s.length; i++) {
    		inputParameters[temp.length+i] = s[i];
		}
    	
    }
    
    /** 
     * Ajoute le paramtre de nom donn au vecteur outputParameters
     * @param s : le nom du paramtre
     */
    public void addOutputParameters(String s) {
    	String[] temp = outputParameters;
    	outputParameters = new String[temp.length+1];
    	for (int i = 0; i < temp.length; i++) {
    		outputParameters[i] = temp[i];
		}
    	outputParameters[temp.length] = s;
    }
    
    /** 
     * Ajoute les paramtres dont les noms sont dans le vecteur au vecteur outputParameters
     * @param s : le nom du paramtre
     */
    public void addOutputParameters(String[] s) {
    	String[] temp = outputParameters;
    	outputParameters = new String[temp.length+s.length];
    	for (int i = 0; i < temp.length; i++) {
    		outputParameters[i] = temp[i];
		}
    	for (int i = 0; i < s.length; i++) {
    		outputParameters[temp.length+i] = s[i];
		}
    	
    }
    
    /** 
     * Permet d'ajouter diffrents choix pour une variables
     * @param parameterName : le nom de la variable
     * @param choicesNames : tableau contenant le nom des choix
     * @param choicesValues : tableau contenant les valeurs des choix
     */
    public void addInputParametersChoices(String parameterName, String[] choicesNames, Object[] choicesValues) {
    	hashMapChoiceString.put(parameterName,choicesNames);
    	hashMapChoiceValue.put(parameterName,choicesValues);
    }
	
}