/**
 * Title: Moduleco - modulecoFramework.abstractModels.WorldGame.java <p>
 * Description:  Abstract Generic Game World Class <p>
 * Copyright : (c)enst-bretagne
 * @author Denis.Phan@enst-bretagne.fr
 * @version 1.4  February, 2004
 */

package modulecoFramework.abstractModels;

import modulecoFramework.modeleco.ENeighbourWorld;

/**
 * 
 * @author Denis.Phan@enst-bretagne.fr
 * 
 *
 */
public abstract class EWorldGame extends ENeighbourWorld {
	
	public int s1AgainstS1, s2AgainstS1, s1AgainstS2, s2AgainstS2;
	public String revisionRuleIndex;

	public EWorldGame() {
		
		super();
		
		revisionRuleIndex = "Last neighbourhood best payoff";
		
		inputParameters = new String[]{"s1AgainstS1","s1AgainstS2","s2AgainstS1","s2AgainstS2","revisionRuleIndex"};
		
		hashMapChoiceString.put("revisionRuleIndex",new String[]{"Last neighbourhood best payoff", "Last neighbourhood best average payoff"});
		hashMapChoiceValue.put("revisionRuleIndex",new String[]{"Last neighbourhood best payoff", "Last neighbourhood best average payoff"});
		
	}

	public void init() {
		
	}

	// === Data management ===

	public int getS1AgainstS1() {
		return s1AgainstS1;
	}
	public int getS1AgainstS2() {
		return s1AgainstS2;
	}
	public int getS2AgainstS1() {
		return s2AgainstS1;
	}
	public int getS2AgainstS2() {
		return s2AgainstS2;
	}
	public void setS1AgainstS1(int s1AgainstS1) {
		this.s1AgainstS1 = s1AgainstS1;
		//payoffMatrix[0][0] = this.s1AgainstS1;
	}
	public void setS2AgainstS1(int s2AgainstS1) {
		this.s2AgainstS1 = s2AgainstS1;
		//payoffMatrix[1][0] = this.s2AgainstS1;
	}

	public void setS1AgainstS2(int s1AgainstS2) {
		this.s1AgainstS2 = s1AgainstS2;
		//payoffMatrix[0][1] = this.s1AgainstS2;
	}

	public void setS2AgainstS2(int s2AgainstS2) {
		this.s2AgainstS2 = s2AgainstS2;
		//payoffMatrix[1][1] = this.s2AgainstS2;
	}

	public String getRevisionRuleIndex() {
		return revisionRuleIndex;
	}

	public void setRevisionRuleIndex(String s) {
		revisionRuleIndex = s;
	}

}