/*
 * Moduleco.java
 *
 * Created on 19 janvier 2005, 16:18
 */

package modulecoFramework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.*;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import madkit.boot.Madkit;

/**
 * @author Fabien Michel - Modify by Thibaud Roussillat
 * @version 1.5.1a - Last modify 19 September 2005
 * Class utilisee regulierement par plusieur partie de Moduleco pour obtenir certaines
 * informations
 */
public class Moduleco {
    
	/** Communaute Moduleco */
    public final static String COMMUNITY="moduleco";
    /** Groupe du modele */
    public final static String MODEL_GROUP = "model";
    /** Groupe des agents */
    public final static String AGENTS_GROUP = "ecoAgent";
    /** Role de l'environnement */
    public final static String ENVIRONMENT_ROLE = "environment";
    /** Groupe des "engine" de simulation */
    public final static String ENGINE_GROUP = "engine";
    
    /** Nom du modele courant */
    private static String currentModelName="No Model Selected";
    
    /**
     * 
     * @return the current model name
     */
    public static String getCurrentModelName() {
        return currentModelName;
    }
    
    /**
     * 
     * @param aCurrentModelName : the current model Name
     */
    public static void setCurrentModelName(String aCurrentModelName) {
        currentModelName = aCurrentModelName;
    }
    
    /**
     * Liste les modeles disponibles en regardant les jar present
     * dans le repertoire ./lib et en verifiant qu'un fichier portant l'extension .modulecoModel
     * est present e l'interieur
     * @return la liste des modeles disponible sous forme de string
     */
    public static List getModelsList(){
        List c = new ArrayList();
        File[] fileListing = new File(Madkit.libDirectory).listFiles();
        for(int i=0;i<fileListing.length;i++){
            if(fileListing[i].getName().endsWith(".jar")){
                try {
                    for (Enumeration e=new JarFile(fileListing[i]).entries();e.hasMoreElements();){
                        ZipEntry entry = (ZipEntry) e.nextElement();
                        if (entry.getName().endsWith(".modulecoModel")){
                            c.add(fileListing[i].getName().replaceFirst(".jar",""));
                            break;
                        }
                    }
                } catch (MalformedURLException e){
                    System.err.println("Error: bad jar file " + fileListing[i]);
                } catch (IOException e){
                    System.err.println("Error: not a jar file " + fileListing[i]);
                }
            }
        }
        Collections.sort(c);
        return c;
    }
    
    /**
     * Use the Madkit Class Loader to find a class in the jars of the repertory ./lib
     * @param name : the name of the searched class
     * @return the classe
     * @throws ClassNotFoundException
     */
    public static Class getClass(String name) throws ClassNotFoundException{
       return Madkit.getClassLoader().loadClass(name);
    }
    
    /**
     * 
     * @return the xml parameters file of the current model
     */
    public static File getParametersFile(){
    	/**
    	 * TODO: verify which parameter file is used
    	 */
        String s = System.getProperty("user.dir");
        if(new File(s+File.separator+"models"+File.separator+currentModelName).exists())
            return new File(s+File.separator+"models"+File.separator+currentModelName+File.separator+currentModelName+".parameters");
        else
            return new File(s+File.separator+"plugins"+File.separator+"moduleco"+File.separator+"models"+File.separator+currentModelName+File.separator+currentModelName+".parameters");
    }
    
    /**
     * Cherche dans le jar le fichier xml d'aide associe au modele courant
     * @return an InputStream of the xml help file of the current model 
     */
    public static InputStream getModelHelperInputStream() {
    	
    	/* Cree un nouveau fichier e partir du jar */
    	File file = new File(Madkit.libDirectory+File.separator+currentModelName+".jar");
    	InputStream is = null;
    	try {
    		/* Cree le jar file */
			JarFile jarFile = new JarFile(file);
			/* Recherche le fichier d'aide */
			ZipEntry zipEntry = jarFile.getEntry(currentModelName+".xml");
			if (zipEntry != null) {
				/* Cree le inputStream si le fichier a ete trouve */
				is = jarFile.getInputStream(zipEntry);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		return is;
		
    }
    
}