/** class MyOwnDiscreteChoice.Agent.java
 * Title:        Moduleco<p>
 * Description:
 * Copyright:    Copyright (c)enst-bretagne
 * @author Thibaud Roussillat
 * @version 1.0 - 5 Avril 2005
 */

package models.yvesAlea;

import java.util.Iterator;
import java.util.ArrayList;
import java.util.Random;

import madkit.kernel.ReferenceableAgent;
import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.randomeco.JavaGaussian;
import modulecoFramework.modeleco.randomeco.RandomSD;

public class Agent extends EAgent {
	
	/**
	 * State est l'tat actuel de l'agent
	 * 1 : participe  la norme 1
	 * 2 : participe  la norme 2
	 */
	public int norme;
	
	/**
	 * newState est le nouvel tat de l'agent calcul avant le commit
	 * 1 : participe  la norme 1
	 * 2 : participe  la norme 2
	 */
	protected int newNorme;

	/**
	 * Indique si on doit tracer l'agent ou pas...
	 */
	protected boolean trace = true;
	
	protected World world;
	
	public Agent() {
		super();
		inputParameters = new String[] {"norme"};
		outputParameters = new String[] {"norme"};
	}
	
	//Part I - Initialisation of the agent =================
	/**
	* getInfo()
	* receieve Info from the Eworld Before connection and initialisation
	* @see modulecoFramework.modeleco.ENeighbourWorld
	*
	*/
	public void getInfo() {
	}
	
	/**
	* init()
	*/
	public void init() {

		world = (World) this.getWorld();
		
		if (Math.random() < world.getTauxParticipationInitNorme1()) {
			norme = 1;
		}
		else {
			norme = 2;
		}
		
	}
	

	// Part II - Agent's computations
	
	/**
	 * compute()
	 * ici : 
	 * T1 = N1 / (N1 + N2)
	 * T2 = N2 / (N1 + N2)
	 * 
	 */
	public void myCompute() {
		
		double G1 = world.getGain1();
		double G2 = world.getGain2();
		double T1 = world.getTauxParticipationNorme1();
		double T2 = world.getTauxParticipationNorme2();
		
		double C1 = G1*T1;
		double C2 = G2*T2;
		
		if ( C1 > C2) {
			norme = 1;
		}
		else {
			norme = 2;
		}
		
	}

	public void commit() {
		
	}
	
	public void compute() {
		
	}
	
	/**
	*commit()
	*/
	public void myCommit() {
		
		norme = newNorme;

	}
	
	
	// Part III - Data Exchanges =================
	
	/**
	 * Return stable state (Competitor number)
	 * methode call from XXX at each Canevas update (including between iterations)
	 */ 
	public Object getState() {
		return new Boolean(norme == 1 ? true : false);
	}

	public String toString() {
		return (new Integer(norme)).toString();
	}

	/**
	 * getConnectivity()
	 * @return la connectivit de l'agent c'est  dire le nombre de "relation" qu'il a
	 */
	public int getConnectivity() {
		
		connectivity = neighbours.size();
		return connectivity;

	}
	
	public void trace(String s) {
		if (trace) {
			System.out.println(s);
		}
      }

	/**
	 * @return
	 */
	public boolean getBooleanState() {
		return (norme == 1);
	}

	public int getNorme() {
		return norme;
	}
	/**
	 * @param norme The state to set.
	 */
	public void setNorme(int norme) {
		this.norme = norme;
	}
}