/** class MyOwnDiscreteChoice.Agent.java
 * Title:        Moduleco<p>
 * Description:
 * Copyright:    Copyright (c)enst-bretagne
 * @author Thibaud Roussillat
 * @version 1.0 - 5 Avril 2005
 */

package models.seminaire;

import java.util.Iterator;
import java.util.ArrayList;
import java.util.Random;

import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.randomeco.JavaGaussian;
import modulecoFramework.modeleco.randomeco.RandomSD;

public class Agent extends EAgent {
	
	/**
	 * State est l'tat actuel de l'agent
	 * 0 : n'assiste pas au sminaire
	 * 1 : assiste au sminaire
	 */
	public int state;
	
	/**
	 * newState est le nouvel tat de l'agent calcul avant le commit
	 * 0 : n'assiste pas au sminaire
	 * 1 : assiste au sminaire
	 */
	protected int newState;
	
	/**
	 * Price : reprsente le prix du produit  l'tape i
	 * Pour le moment, ce prix est fix au dbut et ne varie pas
	 * dans le temps.
	 */
	//protected double price;
	
	/**
	* Eta : reprsente le pourcentage de voisin qui assiste au sminaire
	*/
	protected double eta;
	
	/**
	* H : fraction de participant au dessous duquel l'agent n'assiste pas au sminaire
	*/
	public double h;

	/**
	 * random (PRECISER)
	 */
	protected RandomSD random2;

	/**
	 * Indique si on doit tracer l'agent ou pas...
	 */
	protected boolean trace = false;
	
	public Agent() {
		super();
		inputParameters = new String[0];
		outputParameters = new String[] {"state","h"};
		this.trace("[Agent()]");
	}
	
	//Part I - Initialisation of the agent =================
	/**
	* getInfo()
	* receieve Info from the Eworld Before connection and initialisation
	* @see modulecoFramework.modeleco.ENeighbourWorld
	*
	*/
	public void getInfo() {
	}
	
	/**
	* init()
	*/
	public void init() {
		//this.trace("[Agent().init]");

		this.trace("[Agent().init] : ");
		
		h = ((World) this.getWorld()).getH();
		if (h <= ((World)this.getWorld()).getParticipationInit()) {
			this.state = 1;
		}
		else {
			this.state = 0;
		}
		
		// On calcul  partir de combien de participant la personne participera au sminaire
		//World w = (World) this.getWorld();
		/*double seuilMin = w.getSeuilMin();
		double seuilMax = w.getSeuilMax();
		double tauxSeuil0 = w.getTauxSeuil0();
		double tauxSeuil1 = w.getTauxSeuil1();
		
		this.trace("\t - seuilMin : "+seuilMin);
		this.trace("\t - seuilMax : "+seuilMax);
		this.trace("\t - tauxSeuil0 : "+tauxSeuil0);
		this.trace("\t - tauxSeuil1 : "+tauxSeuil1);
		
		double k = Math.random();
		if (k<=tauxSeuil0) {
			h = 0;
		}
		else if (k>=1-tauxSeuil1) {
			h = 1;
		}
		else {
			do {
				if (w.getRandom().equals("Gaussienne")) {
					JavaGaussian jg = new JavaGaussian();
					h = (jg.nextGaussian() / 8) + 0.5;
				}
				else {
					h = Math.random();
				}
			} while ( h<=seuilMin || h>=seuilMax );
		}*/

		//this.trace("\t ----> h = "+h);
		//System.out.println("\t ----> h = "+h);
		
	}
	

	// Part II - Agent's computations
	
	
	/**
	* computeEta() :
	* Calcul de pourcentage d'agent dans le voisinage qui ont adopt
	* la norme c'est  dire qui ont un tat > 0
	*/

	public double computeEta() {
		
		double f;
		double connect;
		double Nc;
		double N;

		/*neighbours = ((NeighbourMedium) mediums[0]).getNeighbours();
		
		int nbAdopter = 0;
		for (Iterator i = neighbours.iterator(); i.hasNext();) {
			Agent ag = ((Agent) i.next());
			if (ag.state > 0) {
				nbAdopter++;
			}
		}*/
		//int nbAdopter = world.getTauxParticipation();
		
		// Attention, si le voisinage est diffrent du monde, l'agent lui-mme n'est pas compter...
		/*if (this.state == 1) {
			System.out.println("\tJe suis partant !");
			nbAdopter++;
		}*/
		//System.out.println("\tNB Adopt : " + nbAdopter + "/ Neighbour size : " + neighbours.size());
		
		//f = (double) nbAdopter / neighbours.size();
		//return f;
		
		return ((World) this.getWorld()).getTauxParticipation();
	}

	/**
	*compute()
	*/

	public void compute() {
		trace("--------------------------------");
		trace("[Agent.compute()] : " + this.agentID);
		eta = computeEta();
		//trace("\t -> eta = "+eta);
		if ( eta > h) {
			newState = 1;
			trace("\t newState = 1 | h : "+h+" ; eta : "+eta);
		}
		else {
			newState = 0;
			trace("\t newState = 0 | h : "+h+" ; eta : "+eta);
		}
	}

	/**
	*commit()
	*/
	public void commit() {
		
		trace("[Agent.commit()] : " + this.agentID);
		state = newState;

	}
	
	
	// Part III - Data Exchanges =================
	
	/**
	 * Return stable state (Competitor number)
	 * methode call from XXX at each Canevas update (including between iterations)
	 */ 
	public Object getState() {
		//System.out.println(" agent.getState() "+state+" | "+newState);
		return new Boolean(state == 0 ? false : true);
	}

	public String toString() {
		//System.out.println(" agent.toString() ");
		return (new Integer(state)).toString();
	}

	/**
	 * getConnectivity()
	 * @return la connectivit de l'agent c'est  dire le nombre de "relation" qu'il a
	 */
	public int getConnectivity() {
		
		connectivity = neighbours.size();
		return connectivity;

	}
	
	public void trace(String s) {
		if (trace) {
			System.out.println(s);
		}
      }

	/**
	 * @return
	 */
	public boolean getBooleanState() {
		return (state > 0);
	}

	/**
	 * @return Returns the h.
	 */
	public double getH() {
		return this.h;
	}
	/**
	 * @param h The h to set.
	 */
	public void setH(double h) {
		this.h = h;
	}
	/**
	 * @param state The state to set.
	 */
	public void setState(int state) {
		this.state = state;
	}
}