/** class explorationExploitation.Seller.java
 * Title:        Moduleco<p>
 * Description:  EAgent who represents one competitor company
 * Copyright:    Copyright (c)enst-bretagne
 * @author philippe LeGoff, Denis.Phan@enst-bretagne.fr
 * @version 1.2  august,5, 2002
 */

   package models.explorationExploitation;

// import java.util.Iterator;
   import java.util.ArrayList;

   import modulecoFramework.modeleco.EAgent;
   import modulecoFramework.modeleco.randomeco.CRandomDouble;

// import modulecoGUI.grapheco.descriptor.IntegerDataDescriptor;
// import modulecoGUI.grapheco.descriptor.DoubleDataDescriptor;
// import modulecoGUI.grapheco.descriptor.ChoiceDataDescriptor;
// import modulecoGUI.grapheco.descriptor.BooleanDataDescriptor;
// import modulecoGUI.grapheco.descriptor.InfoDescriptor;
// import modulecoGUI.grapheco.descriptor.LongDataDescriptor;


import java.io.BufferedReader;
import java.io.FileReader;
import java.io.File;
import java.io.IOException ;

   public class Seller extends EAgent {
   
      protected int firmID;
      protected double price ;
      protected CRandomDouble random;
      protected Market market;
      protected static String entree ;
   
      protected double Gains;
      protected double nuB[][];
      protected int prix;   
      protected static double a ;//facteur d'escompte: a = 0.95 => environ 20 coups = n; a = 0.99 => environ 100 coups.
   // Distribution de proba de la population de joueurs B [offre q][priode p]
      protected double gains[];
      protected  int Nsucces [];
      protected  int Nechec [];
      protected int periode;
      protected  double somme [];
      protected  double sommecarres [];
      protected  double moyenne [];
      protected  double moyenne_pop [];
   
      protected  double ecartytpe [];
      protected  double cste;
      protected  double variance [];
      protected double moyietoile[]; 
      protected  double maxnu [];//110 = nbre max de repetition du jeu
      protected  double nu [];
      protected double nudebut[][][];
      protected  int ietoile;
      protected  int N[];//N = nbre de fois o on a joue le bras i  la periode d.
      protected  double maxnuGittins ;             
   
      protected double Vev;
      protected double V;
      protected int prixmedian;
   
      protected double muv;
      protected double coeffav;
      protected double coeffbv;
      protected String distribution_popv;
   
   
   
      public Seller () {
      
      }
      public Seller (int num) {
      
      
         firmID = num+1;
      
      }
   
   
      public void getInfo() {
      
      }
      public Object getState() {
         return new Integer(firmID);
      }
   
      public void commit() {
         //System.out.println(" Seller.commit()DEBUT ");   
      
      
         for (int i=0;i<11;i++)
         {
         
            gains[i] = 0 ;
         
            if (i == prix)
            {
               if (market.sendResultatTransaction())
               { 
                  gains[i] = 10 * i ;
                  moyenne_pop[i] = ( moyenne_pop[i] * N[i] + 1 )/(N[i] + 1); 
                  Nsucces[i] = Nsucces[i] + 1;
               }
               else 
               {
                  moyenne_pop[i] = (moyenne_pop[i] * N[i])/(N[i] + 1);
                  Nechec[i] = Nechec[i] + 1;
               }
            
               N[i] = N[i] + 1  ;
               Gains = ((periode - 1)*Gains + gains[i])/periode;
            
            }
         
            calculnu (i,periode);
         }
      
      
      }
   
   
      public void compute() {
      
         periode = periode + 1;
         prix = maxindiceGittins(periode-1);
         market.getPrice(prix);
      
      }
   
      public void inverseState() {
      
      }
   
      public void init() {
        // System.out.println("Seller.init()");
         getInfo();
         //System.out.println("                   f                  "+endOfGame);
         distribution_popv=((World) world).getdistribution_pop_vendeur();
         Vev=((World) world).getve_vendeur();
         System.out.println("                   f                  "+Vev);
      
         muv=((World) world).getmu_vendeur();
         coeffav=((World) world).getcoeffa_vendeur();
         coeffbv=((World) world).getcoeffb_vendeur();
         market = ((World) world).getMarket();
         initialisation();// initialisation des tableaux et constantes
         entree();// lit les indices de Gittins dans le fichier entree1.txt 
      
         if (distribution_popv.equalsIgnoreCase("Logistic")){
         
            initnudebut(); }
      
         premiersCoups(1);
         periode=0;
      
      
      
      
      
      
      
      
        /// System.out.println("Seller.init()FIN ");
      }
   
      public void setMenuPrice(){
      }
   
      public void initnudebut(){
      
         for (int k=0; k<11 ; k++){
            for(int j=1; j<41; j++){
               for(int i=1; i<41; i++){ 
               
                  V= Vev - Math.log(1/nuB[j][i]-1);
                  nudebut[k][j][i]= 1 / (1+Math.exp((k-V)/muv)) ;
               }}      
         }
      
      
      
      }
   
   
   
   
      public void setPrice(double d){
         price=d;
      }
   
      public void initialisation(){
      
      
      
      
         Nsucces = new int[11];
         Nechec = new int [11];
         somme = new double [11];
         sommecarres = new double  [11];
         moyenne = new double [11];
         moyenne_pop = new double [11];
         ecartytpe = new double  [11];
         variance = new double [11];
         maxnu = new double [11];//110 = nbre max de repetition du jeu
         nu = new double [11];
         nudebut = new double [11][41][41];
         N = new int [11];  
         a = 0.99;
         cste = (Math.sqrt(2.))/(2*Math.sqrt(1-a));
         gains = new double [11];
         moyietoile = new double [11];
         //System.out.println("Fin initialisation "+endOfGame);
      
         for (int i=0 ; i <11 ; i++){
            Nsucces[i] = 1;
            Nechec [i] = 1;
            N[i]=2;
            somme[i]=0;
            sommecarres[i]=0;
            moyenne_pop[i]=0.5;
            if (distribution_popv.equalsIgnoreCase("Logistic")){
               moyenne_pop[i]=1/(1+Math.exp((i-Vev)/muv));
            //System.out.println(" moy pop" + i + "  " + moyenne_pop[i]); 
            }
         
         }
         //System.out.println("Fin initialisation");
      
      
      }
     
      public void entree() {
         //String s="";
         try
         {
         
            String directoryName=modulecoGUI.grapheco.CentralControl.getModulecoPathRoot() + "models"+File.separator+ "explorationExploitation";
            String fileName="entree1.txt";
            File file=new File(directoryName,fileName);
         
            char r[] ;
            r = new char[6];
            nuB = new double[41][41];
            BufferedReader in = new BufferedReader(new FileReader(file.getPath()));
         
            for(int j=1; j<41; j++){
               for(int i=1; i<40; i++){ 
               
                  in.read(r,0,6);
               //s = new String (r);
                  nuB[j][i] = Float.valueOf(String.valueOf(r)).doubleValue();
                  in.read();
                  //System.out.println(nuB[j][i]);
                  //System.out.println(i);
                  //System.out.println(j);
               
               }
               in.read(r,0,6);
               nuB[j][40] = Float.valueOf(String.valueOf(r)).doubleValue();
               in.readLine();
              //System.out.println(nuB[40][j]);
               //System.out.println(40);
               //System.out.println(j);
            }
            in.close();
         }
         
            catch(IOException e){
              // System.out.print("entree1.dat Error: " + e);
            }
         //return s;
      }
 
   
      public void premiersCoups(int periode) {
         int d = periode - 1;//1er coup => d = 0.
      
         for (int i=0;i<11;i++)
         {
         
            calculnu (i,d);
         }
      
      }
   
   
   
      public void calculnu(int i, int d){
      
         int j=10*i;
         calculstatistiques (i,d);//mise  jour des statistiques
      
         if (Nsucces [i] < 41 && Nechec [i] <41)
         {
            nu [i] = j * nuB [Nechec[i]][Nsucces[i]];
         
            if (distribution_popv.equalsIgnoreCase("Logistic"))
            {
               nu[i] = j * nudebut[i][Nechec[i]][Nsucces[i]];
            //System.out.println("nu" + i   + "  " +  nu[i]); 
            
            }
         
         }
         else
         {  
            nu [i] = moyenne [i] + ((ecartytpe [i])*cste)/(N[i]);
         }      
      
      
      
      
      
      
      
      }
   
   
   
      public void calculstatistiques(int i, int d){
        //somme [i] = 0; 
         if (d > 0) somme [i] = somme [i] + gains[i];
         //sommecarres [i] = 0;
         if (d > 0) sommecarres [i] = sommecarres [i] + gains[i]*gains[i];
         moyenne [i] = somme [i]/(N[i]);
         variance [i] = sommecarres [i] / N[i] -  moyenne [i]*moyenne [i];
         ecartytpe [i] = Math.sqrt(variance[i]);
      
      
      }
   
      public int maxindiceGittins(int d)
      {
         maxnuGittins = 0;
         for (int i = 0; i < 11; i++){
            if (nu [i] > maxnuGittins)
            {
               maxnuGittins = nu[i];
               ietoile  = i;
            }
         }
      
         return ietoile;
      
      }
   
      public  int getNbSucces(int prix){
         //System.out.println("dsjglskjgklsglksjdkfjsdkfjdsk      succes   "  +prix+ "   "+Nsucces[prix][periode]);
         int i =Nsucces[prix];
         return i;
      
      
      
      }
   
      public  double getMoyenne(int prix){
      
         //System.out.println("get moy moy pop" +prix  + "  " + moyenne_pop[prix]); 
      
         //System.out.println("dsjglskjgklsglksjdkfjsdkfjdsk      succes   "  +prix+ "   "+Nsucces[prix][periode]);
         return moyenne_pop[prix];
      
      
      
      }
   
   
      public int getNbEchec(int prix){
         //System.out.println("dsjglskjgklsglksjdkfjsdkfjdsk       echec  "  +prix +"    "+Nechec[prix][periode]);
      
         return Nechec[prix];
      
      }
      public double getIndicePrixGittins(int prix){
      
         return nu[prix];
      }
   
      public double getGains(){
      
         return Gains;
      }
   
      public double getPrix(){
         System.out.println(periode-1);
         System.out.println(10*ietoile);
         return (double)(10*ietoile);
      }
   
      public String toString() {
        // System.out.println(" Seller.toString() ");
         return (new Integer(firmID)).toString();
      }
   
      public ArrayList getDescriptors(){
         //System.out.println("Seller.getDescriptors()");
         //DoubleDataDescriptor(CAgent ag, String textLabel, String nameVariable, double doubleVariable, boolean editable)
      //DoubleDataDescriptor(CAgent ag, String textLabel, String nameVariable, double doubleVariable, boolean editable, int precision)
      //DoubleDataDescriptor(CAgent ag, String textLabel, String nameVariable, double doubleVariable, boolean editable, int precision, int codeColor)
         descriptors.clear();
         return descriptors;
      }
   
   
   
   }

