/*
 
 * @(#)Agent.java	1.1 09-Mar-04
 
 */

package models.emptyModel;

import java.util.ArrayList;
import modulecoFramework.modeleco.EAgent;

/**
 *
 * Describe the behaviour of an agent.
 *
 * <p>
 *
 * Each agent is characterised by a <tt>value</tt> which changes randomly at
 *
 * each time step. His <tt>state</tt> depends on the sign of the <tt>value</tt>
 *
 * (green if positive, red if negative).
 *
 *
 *
 * @author Gilles Daniel (gilles@cs.man.ac.uk)
 *
 * @version 1.0, 23-Feb-04
 *
 * @version 1.1, 09-Mar-04
 *
 * @see models.emptyModel.World
 *
 */

public class Agent extends EAgent {
    
    /**
     *
     * The value of the agent (1 or -1).
     *
     */
    
    public int value;
    
    
    /**
     *
     * The state of the agent.
     *
     * <p>
     *
     * <tt>value</tt>= 1 ---> <tt>state == 'green'<br>
     *
     * <tt>value</tt> =-1 ---> <tt>state == 'red'
     *
     */
    
    public boolean state;
    
    /**
     *
     * Create a new <tt>agent</tt>.
     *
     */
    
    public Agent() {
        
        super();
        if (agentID == 0) System.out.println("-->EAgent()");
        inputParameters = new String[]{"value"};        
        outputParameters = new String[]{"state","value"};
        //System.out.println("new [Agent()]");
        
    }
    
    /**
     *
     * Initialise the agent when the <tt>world</tt> is created.
     *
     */
    
    public void init() {
    	
    	if (agentID == 0) System.out.println("-->Agent.init()");
    	
        /**
         * Initialise the value at the creation of the agent
         */
        value = generateRandomValue();
        
        /**
         *
         * Initialise the state of the agent
         *
         */
        
        updateState();
       
    }
    
    /**
     *
     * Implement HERE the behaviour of the agent.
     *
     * <p>
     *
     * Invoked at each time step.
     *
     */
    
    public void compute() {
        
    	if (agentID == 0) System.out.println("-->EAgent.compute()");
    	
        value = generateRandomValue();
        
    }
    
    /**
     *
     * Just after compute, the agent commit.
     *
     * <p>
     *
     * Invoked at each time step
     *
     */
    
    public void commit() {
    	
    	if (agentID == 0) System.out.println("-->EAgent.commit()");
    	
        updateState();
    }
    
    /**
     * Get the state of the agent Could be a boolean, an Integer, a Double,
     * etc.
     */
    
    public Object getState() {
        return new Boolean(state);
    }
    
    /**
     * Condiftions to change the state of the agent, and its color in the left
     * panel (<em>Canevas</em>)
     */
    
    public void updateState() {
        if (value == 1)
            state = true;
        else
            state = false;
    }
    
    /**
     *
     * Hack used by the <em>Canevas</em>
     *
     * @return a boolean
     *
     * @see models.emptyModel.Canevas
     *
     */
    
    public boolean getBooleanState() {
        
        return state;
        
    }
    
    /**
     * Value accessor
     * @return value
     */
    
    public int getValue() {
        return value;
    }
    
    /**
     * Set the <tt>value</tt>
     * @param value
     */
    
    public void setValue(int value) {
        this.value = value;
    }
    
    /**
     *
     * @return a random value equal to 1 or -1
     *
     */
    
    public int generateRandomValue() {
        
        int exp = (int) (2 * Math.random()) + 1; // exp = 0 or 1
        
        return (int) Math.pow(-1, exp); // return 1 or -1
        
    }
    
    public double nextEventDeltaTime(){
        return 	-Math.log(Math.random())/0.5;// an action every 2 units of time in average; // Poisson law
    }
    
}

