/**
 * Title:   moduleco.models.emergenceClasses. World
 * Reference : Axtell, Epstein, Young (2000)
 * http://www.brookings.edu/es/dynamics/papers/classes/
 * * Copyright:    Copyright (c)enst-bretagne
 * @author denis.phan@enst-bretagne.fr modify by thibaud.roussillat@gmail.com
 * @version 2.0 August 2005
 */

package models.emergenceClasses;

import java.util.ArrayList;
import java.lang.reflect.Constructor;

import modulecoFramework.modeleco.ENeighbourRandomPairwiseWorld;
import modulecoFramework.modeleco.randomeco.CRandomInt;
import modulecoFramework.modeleco.randomeco.CRandomDouble;


public class World extends ENeighbourRandomPairwiseWorld {
	
	public CRandomInt randomDot, randomDotTag;
	public CRandomDouble randomTremble;
	public long seedDot;
	public long seedDotTag;
	public long seedT;
	public String random_T; // randomDot_s,
	private static String randomPath = "modulecoFramework.modeleco.randomeco.";
	public double tremble;
	public int memoryLength;
	public ArrayList[] simplexFeatureSet;
	public SimplexFeature ar1, ar2, ar3; //mixedNashEquilibrium;
	public WorldFeature wr;
	public int[][] PayoffMatrix;
	public String initialLocation, tag;
	
	/**
	 * Constructor
	 */
	public World() {
		
		super();
		
		//System.out.println("New World()");
		
		//this.setDefaultValues();
		
		this.addInputParameters(new String[] {"seedDot","initialLocation","seedT","random_T","tremble","memoryLength","tag","seedDotTag"});
		
		/* Choix multiple pour initialLocation */
		hashMapChoiceString.put("initialLocation",new String[]{"Random","HighLow"});
		hashMapChoiceValue.put("initialLocation",new String[]{"Random","HighLow"});
		
		/* Choix multiple pour random_T */
		hashMapChoiceString.put("random_T",new String[]{"Default","JavaRandom"});
		hashMapChoiceValue.put("random_T",new String[]{"Default","JavaRandom"});
		
		/* Choix multiple pour tag */
		hashMapChoiceString.put("tag",new String[]{"no tag", "2 tags"});
		hashMapChoiceValue.put("tag",new String[]{"no tag", "2 tags"});
		
		outputGraphics = new String[] {"SimplexCanevas","SimplexCanevas2"};
		
		PayoffMatrix = new int[3][3];
		PayoffMatrix[0][0] = 0;
		PayoffMatrix[0][1] = 0;
		PayoffMatrix[0][2] = 70;
		PayoffMatrix[1][0] = 0;
		PayoffMatrix[1][1] = 50;
		PayoffMatrix[1][2] = 50;
		PayoffMatrix[2][0] = 30;
		PayoffMatrix[2][1] = 30;
		PayoffMatrix[2][2] = 30;
		
	}
	
	/**
	 * Invoked by ENeighbourWorld.populateAll(nsClass) to be executed first,
	 * before the end of this world's constructor during each world's creation
	 * process. *
	 */
	public void getInfo() {
		PayoffMatrix = new int[3][3];
		PayoffMatrix[0][0] = 0;
		PayoffMatrix[0][1] = 0;
		PayoffMatrix[0][2] = 70;
		PayoffMatrix[1][0] = 0;
		PayoffMatrix[1][1] = 50;
		PayoffMatrix[1][2] = 50;
		PayoffMatrix[2][0] = 30;
		PayoffMatrix[2][1] = 30;
		PayoffMatrix[2][2] = 30;
	}
	
	/** 
	 * Populate()
	 */
	public void populate() {
		super.populate();
		//double sf01 = (double) (1.0 / 4.0);
		//double sf02 = (double) (1.0 / 2.0);
		//double sf03 = (double) (1.0 / 4.0);
		//System.out.println("World.populate()");
		/**
		 * randomDot is the 3-position pseudo-random generator used for to
		 * initialize the agent's strategies. Sequence of random values depends
		 * on the seed : seedDot.
		 */
		Object RandomConstructorParameter[] = new Object[]{new Long(seedDot)};
		try {
			Constructor constructor = modulecoFramework.Moduleco.getClass(randomPath + "JavaRandom")
					.getConstructor(new Class[]{long.class});
			randomDot = (CRandomInt) constructor
					.newInstance(RandomConstructorParameter);
		} catch (Exception e) {
			System.out.println("->"+e.toString());
		}
		/**
		 * randomDotTag is the 2-position pseudo-random generator used for to
		 * initialize the agent's Tags. Sequence of random values depends on the
		 * seed : seedDotTag.
		 */
		if (tag.equalsIgnoreCase("2 tags")) {
			Object RandomConstructorParameter2[] = new Object[]{new Long(seedDotTag)};
			try {
				Constructor constructor = modulecoFramework.Moduleco.getClass(
						randomPath + "JavaRandom").getConstructor(new Class[]{long.class});
				randomDotTag = (CRandomInt) constructor.newInstance(RandomConstructorParameter2);
			} catch (Exception e) {
				System.out.println(e.toString());
			}
			simplexFeatureSet = new ArrayList[2];
			simplexFeatureSet[0] = new ArrayList(); //WHITHIN
			simplexFeatureSet[1] = new ArrayList(); // BETWEEN
		} else {
			simplexFeatureSet = new ArrayList[1];
			simplexFeatureSet[0] = new ArrayList();
		}
		wr = new WorldFeature(this);
	}
	
	/** 
	 * init()
	 */
	public void init() {
		System.out.println("World.init()");
	}
	
	/** 
	 * compute()
	 */
	public void compute() {
		System.out.println("World.compute()");
	}
	
	/**
	 * commit()
	 */
	public void commit() {
		super.commit();
		System.out.println("World.commit()");
	}
	
	/**
	 * setDefaultValues()
	 */
	public void setDefaultValues() {
		seedDot = 1;
		seedDotTag = 1;
		initialLocation = "Random";
		seedT = 1;
		setRandom_T("JavaRandom");
		tremble = 0.1;
		memoryLength = 20;
		tag = "no tag";
	}

	/** 
	 * setSeedDot(long d)
	 * @param d : the seed
	 */
	public void setSeedDot(long d) {
		seedDot = d;
		//System.out.println("Seed : "+seed);
		//setRandom_s(randomDot_s); //sinon on cree un randomDot a chaque
		// fois...
		//On ne peut modifier la graine qu'au debut d'une simulation,
		//pas en cours de simulation.
	}
	
	/** 
	 * getSeedDot()
	 * @return the seedDot
	 */
	public long getSeedDot() {
		return seedDot;
	}
	
	/**
	 * setSeedDotTag(long dt)
	 * @param dt : the new seedDotTag
	 */
	public void setSeedDotTag(long dt) {
		seedDotTag = dt;
	}
	
	/** 
	 * getSeedDotTag
	 * @return the seedDotTag
	 */
	public long getSeedDotTag() {
		return seedDotTag;
	}
	
	/**
	 * setInitialLocation(String s)
	 * @param s : the initial Location
	 */
	public void setInitialLocation(String s) {
		initialLocation = s;
	}
	
	/**
	 * getInitialLocation()
	 * @return the Initial Location
	 */
	public String getInitialLocation() {
		return initialLocation;
	}
	
	/** 
	 * setSeedT(long st)
	 * @param st : the seed T
	 */
	public void setSeedT(long st) {
		seedT = st;
	}
	
	/**
	 * getSeedT()
	 * @return the seedT
	 */
	public long getSeedT() {
		return seedT;
	}
	
	/**
	 * setRandom_T(String s)
	 * @param s : the new random_T
	 */
	public void setRandom_T(String s) {
		System.out.println("\tsetRandom_T");
		random_T = s;
		try {
			Constructor constructor = modulecoFramework.Moduleco.getClass(randomPath + random_T)
					.getConstructor(new Class[]{long.class});
			randomTremble = (CRandomDouble) constructor
					.newInstance(new Object[]{new Long(seedT)});
		} catch (Exception e) {
			System.out.println(e.toString());
		}
		//for (Iterator i=iterator();i.hasNext();)
		//((Agent) i.next()).setRandom(randomDot);
	}
	
	public String getRandom_T() {
		return random_T;
	}
	
	/** 
	 * setTremble(double tr)
	 * @param tr : the new tremble
	 */
	public void setTremble(double tr) {
		tremble = tr;
	}
	
	/**
	 * getTremble()
	 * @return the tremble
	 */
	public double getTremble() {
		return tremble;
	}
	
	/**
	 * setMemoryLength(int ml)
	 * @param ml : the new memory length
	 */
	public void setMemoryLength(int ml) {
		memoryLength = ml;
	}
	
	/**
	 * getMemorylength
	 * @return the memory length
	 */
	public int getMemoryLength() {
		return memoryLength;
	}
	
	/**
	 * getTag()
	 * @return the tag
	 */
	public String getTag() {
		return tag;
	}
	
	/**
	 * setTag(String tg)
	 * @param tg
	 */
	public void setTag(String tg) {
		tag = tg;
	}
}