/**
 * Moduleco
 * class discreteChoice.Agent.java
 * <p>
 * Description: Copyright: Copyright (c)enst-bretagne
 * 
 * @author denis.Phan@enst-bretagne.fr
 * @version 1.5 november, 2004
 */
package models.discreteChoice2;

import java.util.ArrayList;
import java.util.Iterator;
//import modulecoFramework.modeleco.randomeco.*;
import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.EAgent;
import modulecoGUI.grapheco.descriptor.BooleanDataDescriptor;
import modulecoGUI.grapheco.descriptor.DoubleDataDescriptor;

//import modulecoGUI.grapheco.descriptor.InfoDescriptor;
//import modulecoGUI.grapheco.descriptor.IntegerDataDescriptor;

/**
 * Describe the behaviour of an agent.
 * <p>
 * Each agent is characterised by a <tt>value</tt> which may changes at each
 * time step. His <tt>state</tt> depends on the <tt>value</tt> black & wihte
 * (green if positive, red if negative).
 * 
 * @author denis.phan@univ-rennes1.fr
 * @version 2, november 2004
 */

public class Agent extends EAgent {

	// == I - Agent's fields or parameters ==
	/**
	 * Average Willingness to Pay (common parameter over agents)
	 */
	public double h;

	/**
	 * random part of Idiosyncratic Willingness to Pay
	 */
	public double theta;

	/**
	 * idiosyncratic Willingness to pay idiosyncraticWP = h + theta
	 */
	public double idiosyncraticWP;

	/**
	 * magnitude of social influence (interaction)
	 */

	public double j;

	// == II - Agent's environment fields or parameters ==
	/**
	 * observed % of adopters within the neighbourhood at the end of the
	 * previous step
	 */
	public double observedEta;

	/**
	 * market price
	 */
	public double price;

	// == III - Agent's state and values ==
	/**
	 * state is the actual state . nextState is the computing state
	 */
	public int previouState, state, nextState; //

	/**
	 * ex ante Surplus : Willingness to pay - Price idiosyncraticWP +
	 * J.observedEta - Price
	 */
	//public double expostSurplus;
	/**
	 * State of this agent with respect to limit value of surplus if an agent
	 * for a given P, a refractory never adopt for all value of eta :
	 * idiosyncraticWP + J < P a primaryAdopter adopt even if they are no
	 * adopter in his neighbourhood idiosyncraticWP > P
	 */
	public boolean adopter, refractory, primaryAdopter;

	/**
	 * boolean flag only for external view
	 */
	protected boolean hasChanged;

	// == IV - Learning parameters ==
	/**
	 * expected fraction of adopters within population
	 */
	protected double expectedEta;

	/**
	 * expected Surplus : Willingness to pay(expectedEta) - Price
	 * idiosyncraticWP + j.expectedEta -price
	 */
	protected double expectedSurplus;

	/**
	 * Weighted attraction
	 */
	protected double ewaA1;

	/**
	 * Weighted attraction parameter updatedSurplus = (delta +
	 * (1-delta)*state)*surplus(expectedEta autoregressive update of attraction
	 * to adopt updated(ewaA1) = (1-mu)*ewaA1 + mu*updatedSurplus update mu =
	 * (1-kapa)*mu/(phi+mu) +kapa*(1-phi); if kapa = 0 => mu = mu/(phi+mu) which
	 * converge to (1 - phi) if kapa >= 0 and phi = 0. Then, mu = 1 for all kapa
	 * and all mu0 if kapa = 1 => mu = (1 - phi) for all mu0
	 *  
	 */
	protected double mu, kapa, phi, delta;

	//Part I - Initialisation of the agent =================
	/**
	 * Required to be a CAgent Invoked by <tt>ENeighbourWorld</tt>, when a
	 * new agent is created.
	 * <p>
	 * method get info is invoked after the agent constructor but before
	 * probe(descriptors) updates and initialisation. Mandatory method
	 * (inherited from its abstract superclass in <tt>EAgent</tt>)
	 * 
	 * @see modulecoFramework.modeleco.ENeighbourWorld
	 * @see modulecoFramework.modeleco.EAgent
	 * @see modulecoFramework.modeleco.CAgent
	 */

	public void getInfo() {
	}

	/**
	 * Invoked by SimulationControl.initSimulation() Initialise this EAgent
	 * Required to be a CAgent
	 * 
	 * @see modulecoFramework.modeleco.SimulationControl.initSimulation()
	 */
	public void init() {
		//if (agentID == 0) System.out.println("[Agent.init()]");

		// == I - Agent's fields or parameters ==
		h = ((World) world).getH();
		j = ((World) world).getJ();
		theta = ((World) world).getTheta();
		idiosyncraticWP = h + theta;
		//		System.out.println("agent" + agentID + " theta = " + theta);

		// == II - Agent's environment fields or parameters ==
		if (world.getNeighbourSelected().equalsIgnoreCase("World")) {
			neighbours = null;
			connectivity = world.agentSetSize - 1;
		} else {
			//super.init();
			neighbours = ((NeighbourMedium) mediums[0]).getNeighbours();
			connectivity = neighbours.size();
		}
		//if (agentID == 0)
		//System.out.println("connectivity = " + connectivity);

		//  == III - Agent's state and values ==

		previouState = 0;
		state =0;
		nextState = 0;

		// == IV - Learning parameters ==

		mu = ((World) world).getMu0();
		delta = ((World) world).getDelta();
		/*
		 * Compute the initial EWA, given the initialBelief.
		 */
		double initialBelief = ((World) world).getInitialBelief();
		ewaA1 = getSurplus(idiosyncraticWP, initialBelief, price);
		if (ewaA1 > 0)
			nextState = 1;
		else
			nextState = 0;
		/**
		 * myopicBRSR expectedSurplus = getSurplus(idiosyncraticWP, 0); if
		 * (expectedSurplus > 0) expostSurplus = expectedSurplus; else
		 * expostSurplus = 0;
		 */
	}

	/**
	 * Market function in the world (1) : get the market price
	 *  
	 */

	public double getPrice() {

		return ((World) world).getPrice();
	}
	/**
	 * Market function in the world (2) :
	 * increment the world counter of adopters
	 *
	 */
	public void updateMarket() {
		if (nextState == 1)
			((World) world).incrementAdopters();
		else
			((World) world).decrementAdopters();
	}

	// Part II - Agent's computations
	/**
	 * Implement HERE the behaviour of the agent.
	 * <p>
	 * Invoked at each time step.
	 */
	public void compute() {
		//        if (this.agentID == 0) System.out.println("[Agent.compute()]");
		// == I - get the price ==
		price = getPrice();
		// == II - Compute the next state ==
		nextState = choiceNextState();
	}
	
	public int choiceNextState(){
		// - Compute contingent Surplus ==
		/**
		 * update mu = (1 - kapa) * mu / (phi + mu) + kapa * (1 - phi); if kapa =
		 * 0 => mu = mu / (phi + mu) which converge to (1 - phi) if kapa >= 0
		 * and phi = 0 mu = 1 for all kapa and all all mu0 if kapa = 1 => mu =
		 * (1 - phi) for all mu0
		 *  
		 */
		int ns;
		mu = ((World) world).getMu();
		ewaA1 = computeAttraction(mu, price);
		/*
		 * myopicBRSR expectedSurplus = getSurplus(idiosyncraticWP, getEta());
		 * if (expectedSurplus > 0)
		 */
		if (ewaA1 > 0)
			ns = 1;
		else
			ns = 0;
		return ns;
		}

	public double computeAttraction(double mu, double price) {

		double updatedAttraction, updatedSurplus;
		/**
		 * if delta = 1 updatedSurplus = getSurplus(idiosyncraticWP, getEta());
		 */
		observedEta = getEta();
		expectedEta = observedEta; //Myopic Rule TEMPORAIRE MISE AU POINT

		updatedSurplus = (delta + (1 - delta) * state)
				* getSurplus(idiosyncraticWP, expectedEta, price);
		/**
		 * autoregressive update of attraction to adopt
		 */
		updatedAttraction = (1 - mu) * ewaA1 + mu * updatedSurplus;
		return updatedAttraction;

	}

	/**
	 * In "late commit scheduler", all agent compute and after, all agent commit
	 * In "early commit scheduler", each agent commit just after compute the
	 * agent commit, i.e. may change is state
	 * <p>
	 * Invoked at each time step
	 */
	public void commit() {
		//if (agentID==0) System.out.println(" agent.commit() ");

		if (state != nextState) {
			hasChanged = true;
			updateMarket();
			System.out.println(" agent.commit() state = "+state+" nextState = "+nextState);

		} else
			hasChanged = false;
		//updateMarket();
		previouState = state;
		state = nextState;
		adopter = (state == 1 ? true : false);
		computeLimitBehaviour(price);
	}

	//	-------------------------------------------------------------------------------------------------------------
	//	METHODS
	//	-------------------------------------------------------------------------------------------------------------
	/**
	 *  
	 */
	public void computeLimitBehaviour(double price) {

		primaryAdopter = (idiosyncraticWP > price ? true : false);
		refractory = (idiosyncraticWP + j <= price ? true : false);
		//TESTS
		/*
		 * System.out.print("agent" + agentID); if (primaryAdopter)
		 * System.out.print(" is a primaryAdopter for price = " + price); else
		 * if (refractory) System.out.print(" is a refractory for price = " +
		 * price); else if (adopter) System.out.print(" is an adopter for price = " +
		 * price); else System.out.print(" is not an adopter for price = " +
		 * price); System.out.println(" with theta = " + theta + " IWP + J = " +
		 * (idiosyncraticWP + j) + " and eta = " + observedEta);
		 */
	}

	/**
	 * this method is used to generate a new random eta estimated
	 */

	public double getSurplus(double iwp, double n, double p) {

		double surplus = iwp + j * n - p;
		return surplus;
	}

	/*
	 * public double getWillignessToPay() { double tempW = 0; return tempW; }
	 */

	public double getEta() {

		double tempEta = 0;

		if (world.getNeighbourSelected().equalsIgnoreCase("World"))
			tempEta = ((World) world).getEta();//ok pour
		// late, et early, puisque les agents modifient eux-meme world.buyers
		// avec agent.commit
		else {
			if (connectivity == 0)
				tempEta = 0; // pas ncessaire, car alors J = 0 ??
			else {
				int buyers = 0;
				for (Iterator i = neighbours.iterator(); i.hasNext();) {
					Agent ag = ((Agent) i.next());
					if (ag.state == 1) //previouState
						buyers++;
				}
				tempEta = (double) buyers / connectivity; //neighbours.size();
			}
		}
		return tempEta;
	}

	/**
	 * Compute the ex-post surplus of the agent method invoked by World.commit()
	 * 
	 * @see models.discreteChoice2.World.commit()
	 */
	/*
	 * public void computeExpostSurplus(double price) {
	 * 
	 * double eta = getEta(); expostSurplus = h + theta + j * eta - price; //if
	 * (agentID == 0) //System.out.println("agent " + agentID + "
	 * computeExpostSurplus() :" //+ expostSurplus); }
	 */

	// Part III - Data Exchanges =============
	//	======================================
	//	III-1 Agent's State
	/**
	 * Get the state of the agent used by the <em>Canevas</em> Return stable
	 * state at each Canevas update (including between iterations) Required to
	 * be a CAgent
	 * 
	 * @return a Boolean Object
	 * @see modulecoGUI.grapheco.Canevas
	 */
	public Object getState() {
		//System.out.println(" agent.getState() ");
		return new Boolean(adopter);
	}

	/**
	 * flag : return true when the state of the Agent has Changed
	 * 
	 * @return hasChanged
	 */
	public Boolean hasChanged() {
		return new Boolean(hasChanged);
	}

	/**
	 * Return some information about the agent Accessible on right-click
	 */
	public ArrayList getDescriptors() {

		//System.out.println("[Agent.getDescriptors()]");
		descriptors.clear();
		descriptors.add(new DoubleDataDescriptor(this, " idiosyncratic WP",
				"idiosyncraticWP", idiosyncraticWP, false));
		descriptors.add(new DoubleDataDescriptor(this, "  expected Surplus",
				"expectedSurplus", expectedSurplus, false));
		//descriptors.add(new DoubleDataDescriptor(this, " expost Surplus",
		//	"expostSurplus", expostSurplus, false));
		//descriptors.add(new DoubleDataDescriptor(this, " % Eta", "eta", eta,
		//	false));
		descriptors.add(new DoubleDataDescriptor(this, "EWAttraction A1",
				"ewaA1", ewaA1, false));
		descriptors.add(new BooleanDataDescriptor(this, "Adopter", "adopter",
				adopter, false));
		descriptors.add(new BooleanDataDescriptor(this, "Refractory",
				"refractory", refractory, false));
		return descriptors;
	}

	/**
	 * get the idiosyncratic Willingness to Pay
	 * 
	 * @return idiosyncraticWP
	 */

	public double getIdiosyncraticWP() {

		return idiosyncraticWP;
	}

	/**
	 * get the expected Surplus
	 * 
	 * @return expectedSurplus
	 */

	public double getExpectedSurplus() {

		return expectedSurplus;
	}

	/**
	 * get the EWAttraction A1
	 * 
	 * @return ewaA1
	 */

	public double getEwaA1() {

		return ewaA1;
	}

	/**
	 * get the effective ex post Surplus
	 * 
	 * @return expostSurplus
	 */

	/*
	 * public double getExpostSurplus() {
	 * 
	 * return expostSurplus; }
	 */
	/**
	 * get if the agent is adopter
	 * 
	 * @return state
	 */

	public boolean getadopter() {
		//System.out.println("getadopter = " + state);
		return (state == 1);
	}

	public boolean getRefractory() {

		return refractory;
	}

	public double getAdjustedWP() {
		double wp;
		wp=java.lang.StrictMath.max(j*getEta()+theta,0) ;
		//if (wp > 1.8 && test) { // DP 20/08/2002
		//System.out.println("agent : "+agentID+" wp = a*eta+theta = "+wp);
		//test = false;
		//}
		return wp;
	}

}