/*
 * Source File Name: discreteChoice.World.java Copyright: Copyright
 * (c)enst-bretagne @author : Denis.Phan@enst-bretagne.fr
 * 
 * @version 1.4 February, 2004
 */
package models.discreteChoice;

import java.util.Iterator;
import java.util.ArrayList;
import java.lang.reflect.Constructor;

import modulecoFramework.modeleco.CAgent;
import modulecoFramework.modeleco.EAgent;
import modulecoFramework.modeleco.ENeighbourSmallWorld;
import modulecoFramework.medium.Medium;
import modulecoFramework.modeleco.randomeco.CRandomDouble;
import modulecoFramework.modeleco.randomeco.RandomSD;
//import modulecoFramework.modeleco.SimulationControl;
import modulecoGUI.grapheco.statManager.CalculatedVar;
import modulecoGUI.grapheco.descriptor.ChoiceDataDescriptor;
import modulecoGUI.grapheco.descriptor.LongDataDescriptor;
import modulecoGUI.grapheco.descriptor.DoubleDataDescriptor;

/**
 * 
 *  
 */
public class World extends ENeighbourSmallWorld { //ENeighbourSmallWorld
	/**
	 * Initial values for the 4 basic parameters of this world <br>
	 * parameter 1: world size <br>
	 * parameter 2: neighbourhood type <br>
	 * parameter 3: active zone type <br>
	 * parameter 4: scheduler type <br>
	 */
	public static String initLength = "4"; //100

	public static String initNeighbour = "World";

	public static String initZone = "World";

	public static String initScheduler = "LateCommitScheduler";

	/**
	 *  
	 */
	protected CRandomDouble random;

	protected RandomSD random2;

	protected long seed, seed2;

	protected double sd;

	/**
	 * magnitude of social influence (interaction)
	 */
	protected double j;

	/**
	 * average idiosyncrasic willingness to pay equivalent to an external
	 * magnetic field in MS
	 */
	protected double h = 0.0;
	/**
	 * thetaMin is the minimum value of the IWP part Theta
	 */
	protected double thetaMin = 0;
	/**
	 * thetaMax is the maximum value of the IWP part Theta
	 */
	protected double thetaMax = 0;	

	protected int ns; // NeighbourSize

	protected String random_s, random_s2, thetaType;

	private static String randomPath = "modulecoFramework.modeleco.randomeco.";

	protected Autorun autorun; // DP 20/08/2002

	/**
	 * @param length
	 */
	public World(int length) {
		super(length);
		//autorun = centralControl.getAutorun(); // DP 20/08/2002
		//autorun.setWorld(this);
	}

	/**
	 * getInfo() receieve Info from the Eworld Before connection and
	 * initialisation
	 * 
	 * @see modulecoFramework.modeleco.ENeighbourWorld
	 *  
	 */
	public void getInfo() {
		//System.out.println("discreteChoice.World.getInfo");
	}

	public void setDefaultValues() {
		//System.out.println("1 - discreteChoice.World.setDefaultValues()");
		seed2 = 0; //190; // always before setRandom
		sd = 1; // always before setRandom
		setRandom_s2("JavaUniformCentred");//);//JavaLogistic
		// RandomGenrationClass must always be AFTER seed
		setThetaType("Deterministic");
		j = 3.4641;//1;
		h = 0;
	}

	/**
	 * populate()
	 */
	public void populate() {
		//System.out.println(" world.populate()");
		extraAgents = new Seller[1];
		extraAgents[0] = new Seller();
		((EAgent) extraAgents[0]).setWorld(this);
		extraAgents[0].getInfo();
		// setup the neighbourhood settlement
		// initialize market
		mediumsInWorld = new Medium[1];
		mediumsInWorld[0] = new Market();
	}

	/**
	 * connectAll() overides ENeighbourgWorld.connectAll()
	 *  
	 */
	public void connectAll() {
		if (getNeighbourSelected().equalsIgnoreCase("World"))
			System.out.println("initNeighbour = " + getNeighbourSelected()
					+ " > No Local Neighbourhood");
		else {
			Iterator it;
			CAgent agent;
			Medium[] agentMediums;
			System.out.println("initNeighbour = World > Local Neighbourhood : "
					+ getNeighbourSelected()+"initNeighbour = "+ initNeighbour);
			for (int i = 0; i < agentSetSize; i++) { // for all Visible CAgent
				agent = (CAgent) this.get(i);
				agentMediums = agent.getMediums();
				agentMediums[0].clear();
				// Ajoute AB-DP 19/09/2001 -revision des voisinages
				agentMediums[0].attach(agent, "source");
				// I attach my i th CAgent to mediums j
				for (it = (connectionsStrategies[0].compute(i)).iterator(); it
						.hasNext();) { // for all the computed agents to
					// connect...
					agentMediums[0].attach(((CAgent) it.next()), "neighbour");
					// I attach computed CAgent to mediums j
				}
			}
		}
		this.connect();
	}

	/**
	 * connect()
	 *  
	 */
	public void connect() {
		// connect the Neighbourhood
		super.connect(); // ENeighbourWorld.connect()
		for (Iterator i = iterator(); i.hasNext();) {
			getMarket().attach(((Agent) i.next()), "customer");
			//((Agent)i.next()).setMarket(market);
		}
		getMarket().attach(extraAgents[0], "Seller");
		// connect the seller to the market
		//System.out.println(" world.connect() ");
	}

	/**
	 * initAll() Overides ENeighbourgSmallWorld.initAll()
	 */
	public void initAll() {
		if (getNeighbourSelected().equalsIgnoreCase("World"))
			super.enWorldInitAll();
		else
			super.initAll();
	}

	/**
	 * init()
	 */
	public void init() {
		thetaStats();
		try {
			statManager.add(new CalculatedVar("State", modulecoFramework.Moduleco.getClass(
					this.pack() + ".Agent").getMethod("getState", null),
					CalculatedVar.NUMBER, new Boolean(true)));
			statManager.add(new CalculatedVar("Changes", modulecoFramework.Moduleco.getClass(
					this.pack() + ".Agent").getMethod("hasChanged", null),
					CalculatedVar.NUMBER, new Boolean(true)));
		} catch (ClassNotFoundException e) {
			System.out.println(e.toString());
		} catch (NoSuchMethodException e) {
			System.out.println(e.toString());
		}
		//System.out.print(" world.init - "+ getNeighbourSelected());
	}
	/**
	 * Compute descriptive statistics about the agent's theta
	 *
	 */
		public void thetaStats(){
//			Mise au point
			//Agent ag;
			double thetaMean = 0 ;
			double theta ;
			for (Iterator i = iterator(); i.hasNext();) {
				theta = ((Agent) i.next()).theta;
				if (theta < thetaMin)
					thetaMin = theta;
				if (theta > thetaMax)
					thetaMax = theta;
				thetaMean =+ theta ;
			}
			thetaMean = thetaMean /agentSet.size() ;
			
			System.out.println("thetaStats() - thetaMin = " + thetaMin
					+ " - thetaMax = " + thetaMax+" - theta moyen = "+thetaMean);
			}
	/**
	 * commit()
	 */
	public void commit() {
		boolean testPrice = ((Seller) extraAgents[0]).getRestartTest();
		boolean testTotalAdoption = ((Seller) extraAgents[0]).getCustomers() >= agentSetSize;
		if (testPrice || testTotalAdoption) { // DP 20/08/2002
			//DESACTIVATION TEMPORAIRE 10/2004 Mise au point
			//simulationControl.stop();
			/*
			 * System.out.println("Seed2 " + seed2 + " ; P = ; " + ((Seller)
			 * extraAgents[0]).maxPrice + " ; N = ; " + ((Seller)
			 * extraAgents[0]).maxProfitCustomers + " ; profit = ; " + ((Seller)
			 * extraAgents[0]).maxProfit);
			 */
			//autorun.test();
			//seed2=seed2+5;
			//autorun.restart();
		} else {
			super.commit();
			getMarket().marketClear();
			// pas forcment ncessaire ici // SP 17/01/2003
		}
		//System.out.println(" world.commit() ");
	}

	//====================================================
	protected String Format4Double(double db) {
		// format BEGIN
		String tempString = (new Integer((new Double(db * 10000)).intValue()))
				.toString();
		String formatedString = tempString.substring(0, 1) + "."
				+ tempString.substring(1);
		// Format END
		return formatedString;
	}

	public Object getState() {
		return new Boolean(true);
	}

	/**
	 * return the mediumsInWorld[0] as Market
	 */
	public Market getMarket() {
		//System.out.println(" world.getMarket() ");
		return (Market) mediumsInWorld[0];
	}

	/**
	 * get an ArrayList of descriptors (probes) descriptors.clear(); is located
	 * in the superclass
	 */
	public ArrayList getDescriptors() {
		descriptors = super.getDescriptors();
		//Seed MUST ALWAYS been calculated BEFORE RandomChoice
		descriptors.add(new LongDataDescriptor(this, "Seed 2", "seed2", seed2,
				true, 3));
		descriptors.add(new DoubleDataDescriptor(this, "Standard deviation",
				"sd", sd, true));
		descriptors.add(new ChoiceDataDescriptor(this, "AgentRandom",
				"random_s2", new String[] { "JavaUniformCentred",
						"JavaLogistic" }, random_s2, true));
		descriptors.add(new ChoiceDataDescriptor(this, "Theta Type",
				"thetaType", new String[] { "Random", "Deterministic" },
				thetaType, true));
		descriptors.add(new DoubleDataDescriptor(this, "J", "j", j, true, 3));
		descriptors.add(new DoubleDataDescriptor(this, "H", "h", h, true, 3));

		return descriptors;
	}

	public void setJ(double j) {
		this.j = j;
	}

	public double getJ() {
		return j;
	}

	public void setH(double h) {
		this.h = h;
	}

	public double getH() {
		return h;
	}


	public void setThetaType(String s) {
		thetaType = s;
	}
	
	public void setSeed2(long d) {
		seed2 = d;
		//System.out.println("world.setSeed2(" + seed2 + ")");
		//On ne peut modifier la graine qu'au debut d'une simulation,
		//pas en cours de simulation.
	}

	/*
	 * public void setRandom_s2(String s){ random_s2=s; try{ Constructor
	 * constructor = modulecoFramework.Moduleco.getClass(randomPath+random_s2).getConstructor(new
	 * Class[] {long.class}); random2 = (Random) constructor.newInstance(new
	 * Object[] {new Long(seed2)}); //System.out.println("random_s2"+random2+"
	 * seed "+seed2); } catch (Exception e){ System.out.println(e.toString()); } }
	 */

	public void setRandom_s2(String s) {
		random_s2 = s;
		Object RandomSDConstructorParameters[] = new Object[] {
				new Long(seed2), new Double(sd) };
		try {
			//Constructor constructor = modulecoFramework.Moduleco.getClass(randomPath + random_s2)
			//	.getConstructor(new Class[]{long.class, double.class});
			//random2 = (RandomSD) constructor
			//	.newInstance(RandomSDConstructorParameters);
			Constructor constructor = modulecoFramework.Moduleco.getClass(randomPath + "RandomSD")
					.getConstructor(new Class[] { long.class, double.class });
			random2 = (RandomSD) constructor
					.newInstance(RandomSDConstructorParameters);
			//System.out.println("models.discreteChoice.random_s2 sd = " + sd
					//+ " seed = " + seed2 + " random2 = " + random2);

		}
		/*
		 * catch (IllegalAccessException e){ System.out.println(e.toString());}
		 * 
		 * catch (InstantiationException e){ System.out.println(e.toString());}
		 * 
		 * catch (ClassNotFoundException e){ random = null;}
		 */
		catch (Exception e) {
			System.out.println("setRandom_s2 :" + e.toString());
		}
	}

	public RandomSD getRandom2() {
		return random2;
	}

	// SmallWorld
	public void RandomGeneratorsetDefaultValues() {
		seed = 1;
		random_s = "JavaRandom";
		setRandom_s(random_s);
		nNodes = 0;
		removedLinks = 0;
		//System.out.println(" 2 -
		// discreteChoice.World.RandomGeneratorsetDefaultValues()");
	}

	/**
	 * @param theta_s
	 * @return
	 */
	public double getCumulativeDistribution(double theta_s) {
		int cumul = 0;
		Agent ag;
		for (Iterator i = iterator(); i.hasNext();) {
			ag = (Agent) i.next();
			if (ag.theta > theta_s)
				cumul++;
		}
		double frequency = (double) 100 * ((double) cumul) / ((double) size());
		//System.out.println("frequency theta = "+frequency);
		return frequency;
	}

	public double getCumulativeWP(double wp) {
		int cumul = 0;
		Agent ag;
		for (Iterator i = iterator(); i.hasNext();) {
			ag = (Agent) i.next();
			if (ag.getAdjustedWP() > wp)
				cumul++;
		}
		double frequency = (double) 100 * ((double) cumul) / ((double) size());
		//System.out.println("frequency wp= "+frequency);
		return frequency;
	}

	public double getCumulativeEta(double s) {
		int cumul = 0;
		Agent ag;
		for (Iterator i = iterator(); i.hasNext();) {
			ag = (Agent) i.next();
			if (ag.getObservedEta() < s) {
				cumul++;
			}
		}
		double frequency = (double) 100 * ((double) cumul) / ((double) size());
		//System.out.println("cumulEta = "+frequency+" s = "+s);
		return frequency;
	}

	public void setNeighbourSize(int ns) {
		this.ns = ns;
		//System.out.println("NeighbourSize = "+ns);
	}

	public int getNeighbourSize() {
		//ns = 4;
		return ns;
	}

	public long getSeed2() { // DP 20/08/2002
		return seed2;
	}

	public void setSd(double s) {
		sd = s;
		//System.out.println("models.DBBGame.setSd = "+sd);
	}

	public double getSd() {
		return sd;
	}

	public double getTheta() {
		double theta = 0;
		double u = 0;
		if (random_s2.equalsIgnoreCase("JavaUniformCentred")) {
			//theta = random2.getDouble();
			theta = (random2.getDouble() - 0.5) * sd * java.lang.Math.sqrt(3.0)
					* 2.0;
		}
		if (random_s2.equalsIgnoreCase("JavaLogistic")) {
			do {
				u = random2.getDouble(); //Math.random();
				//System.out.println(u);
			} while (u == 0 || u == 1);
			theta = sd * Math.log(u / (1 - u));
		}
		return theta;
	}

}