/**
 * Moduleco
 * class discreteChoice.Agent.java
 * <p>
 * Description: Copyright: Copyright (c)enst-bretagne
 * 
 * @author denis.Phan@enst-bretagne.fr
 * @version 1.5 november, 2004
 */

package models.discreteChoice;

import java.util.Iterator;
import java.util.ArrayList;

import modulecoFramework.medium.NeighbourMedium;
import modulecoFramework.modeleco.EAgentLinks;
// import modulecoGUI.grapheco.descriptor.DataDescriptor;
import modulecoGUI.grapheco.descriptor.DoubleDataDescriptor;
import modulecoGUI.grapheco.descriptor.BooleanDataDescriptor;
import modulecoGUI.grapheco.descriptor.IntegerDataDescriptor;

// import modulecoFramework.medium.NeighbourMedium;
// import modulecoFramework.medium.Medium;
//import modulecoFramework.modeleco.randomeco.Random;
//import modulecoFramework.modeleco.randomeco.RandomSD;

/**
 * Describe the behaviour of an agent.
 * <p>
 * Each agent is characterised by a <tt>value</tt> which may changes at each
 * time step. His <tt>state</tt> depends on the <tt>value</tt> black & wihte
 * 
 * @author denis.phan@univ-rennes1.fr
 * @version 2, november 2004
 */
public class Agent extends EAgentLinks {
	// == I - Agent's fields or parameters ==
	/**
	 * Average Willingness to Pay (common parameter over agents)
	 */
	public double h;

	/**
	 * random part of Idiosyncratic Willingness to Pay
	 */
	public double theta;

	/**
	 * idiosyncratic Willingness to pay idiosyncraticWP = h + theta
	 */
	public double idiosyncraticWP;

	/**
	 * magnitude of social influence (interaction)
	 */

	public double j;

	// == II - Agent's environment fields or parameters ==
	/**
	 * % of adopters within the neighbourhood at the end of the previous step
	 */
	public double observedEta;

	/**
	 * market price
	 */
	public double price;

	// == III - Agent's state and values ==
	/**
	 * state is the actual state . nextState is the computing state
	 */
	public int state, nextState, previouState;

	/**
	 * Surplus : Willingness to pay - Price idiosyncraticWP + J.eta - Price
	 */
	public double exanteSurplus;

	// Utile ?
	// public double expostSurplus;

	/**
	 * State of this agent with respect to limit value of surplus if an agent
	 * for a given P, a refractory never adopt for all value of eta :
	 * idiosyncraticWP + J < P a primaryAdopter adopt even if they are no
	 * adopter in his neighbourhood idiosyncraticWP > P
	 */
	public boolean adopter, refractory, primaryAdopter;

	/**
	 * boolean flag only for external view
	 */
	protected boolean hasChanged;

	//	 == VI - Market ==
	/**
	 * Medium Market : the agent knows the market
	 */
	protected Market market;

	//	=======================================
	//  Part I - Initialisation of the agent ==
	/**
	 * Required to be a CAgent Invoked by <tt>ENeighbourWorld</tt>, when a
	 * new agent is created.
	 * <p>
	 * method get info is invoked after the agent constructor but before
	 * probe(descriptors) updates and initialisation. Mandatory method
	 * (inherited from its abstract superclass in <tt>EAgent</tt>)
	 * 
	 * @see modulecoFramework.modeleco.ENeighbourWorld
	 * @see modulecoFramework.modeleco.EAgent
	 * @see modulecoFramework.modeleco.CAgent
	 */
	public void getInfo() {
	}

	/**
	 * Invoked by SimulationControl.initSimulation() Initialise this (E)Agent
	 * Required to be a CAgent
	 * 
	 * @see modulecoFramework.modeleco.SimulationControl.initSimulation()
	 */
	public void init() {
		//if (agentID == 0) System.out.println("[Agent.init()]");

		// == I - Agent's fields or parameters ==
		h = ((World) world).getH();
		j = ((World) world).getJ();
		theta = ((World) world).getTheta();
		idiosyncraticWP = h + theta;
		//		System.out.println("agent" + agentID + " theta = " + theta);

		// == II - Agent's environment fields or parameters ==
		if (world.getNeighbourSelected().equalsIgnoreCase("World")) {
			neighbours = null;
			connectivity = world.agentSetSize - 1;
		} else {
			//super.init();
			neighbours = ((NeighbourMedium) mediums[0]).getNeighbours();
			connectivity = neighbours.size();
		}
		//if (agentID == 0)
		//System.out.println("connectivity = " + connectivity);

		// == III - Agent's state and values ==
		previouState = 0;
		state =0;
		nextState = 0;

		// == VI - Market ==
		market = ((World) world).getMarket();
	}

	/**
	 * method marketOpen() invoked by market.intit()
	 */
	public void marketOpen() {

		price = market.getPrice();// setMenuPrice();
		// The agent get all menu of prices for the market
	}

	//	=============================
	// Part II - Agent's computations
	/**
	 * Implement HERE the behaviour of the agent.
	 * <p>
	 * Invoked at each time step. I - The agent get the price from the market II -
	 * The agent compute his surplus : for given (contingent) eta expected or
	 * observed (myopic) III - The agent apply his best response to this
	 * contingent surplus
	 * 
	 *  
	 */
	public void compute() {
		//if (this.agentID == 0) System.out.println("[Agent.compute()]");
		/**
		 * -- I - The agent get the price from the market ==
		 */
		price = getPrice();
		/**
		 * -- II - The agent Choices his next state
		 */
		nextState = choiceNextState();
	}

	public int choiceNextState() {
		int ns;
		/**
		 * I - The agent compute his surplus : for given (contingent) eta
		 * expected or observed (myopic)
		 */
		observedEta = getObservedEta();
		exanteSurplus = getSurplus(idiosyncraticWP, observedEta, price);
		/**
		 * II - The agent apply his best response to this contingent surplus
		 */
		if (exanteSurplus > 0)
			ns = 1;
		else
			ns = 0;
		return ns;
	}

	/**
	 * In "late commit scheduler", all agent compute and after, all agent commit
	 * In "early commit scheduler", each agent commit just after compute the
	 * agent commit, i.e. may change is state
	 * <p>
	 * Invoked at each time step
	 */
	public void commit() {
		//if (agentID==0) System.out.println(" agent.commit() ");

		if (state != nextState) {
			hasChanged = true;
			updateMarket();

		} else
			hasChanged = false;
		previouState = state;
		state = nextState;
		adopter = (state == 1 ? true : false);
		computeLimitBehaviour(price);
	}

	public void updateMarket() {
		if (nextState == 1)
			market.buy(agentID);
		else
			market.removeCustomer(agentID);
	}

	public double getPrice() {
		return market.getPrice();
	}

	public void computeLimitBehaviour(double price) {

		primaryAdopter = (idiosyncraticWP > price ? true : false);
		refractory = (idiosyncraticWP + j <= price ? true : false);
		//TESTS
		/*
		 * System.out.print("agent" + agentID); if (primaryAdopter)
		 * System.out.print(" is a primaryAdopter for price = " + price); else
		 * if (refractory) System.out.print(" is a refractory for price = " +
		 * price); else if (adopter) System.out.print(" is an adopter for price = " +
		 * price); else System.out.print(" is not an adopter for price = " +
		 * price); System.out.println(" with theta = " + theta+" IWP + J =
		 * "+(idiosyncraticWP+j) + " and observedEta = "+observedEta);
		 */
	}

	/**
	 *  
	 */
	public double getSurplus(double iwp, double n, double p) {

		double Surplus = iwp + j * n - p;
		return Surplus;
	}

	/**
	 * getEta()
	 */

	public double getObservedEta() {
		double tempEta;
		double connect;
		double Nc;
		double N;

		if (world.getNeighbourSelected().equalsIgnoreCase("World")) {
			//optimisation ok pour late, mais pas pour early !!!!
			/*
			 * Nc = Number of customers in the world in t-1 (at le last market
			 * clear)
			 */
			Nc = (double) market.getNCustomers();
			N = world.agentSetSize;
			tempEta = Nc / N;
		} else {
			connect = (double) connectivity;
			if (connectivity == 0) {
				//System.out.println("connectivity = " + connectivity);
				tempEta = 0;
			} else {

				int nbAdopter = 0;

				for (Iterator i = neighbours.iterator(); i.hasNext();) {
					Agent ag = ((Agent) i.next());
					if (ag.state > 0) //previouState
						nbAdopter++;
				}
				tempEta = (double) nbAdopter / connect; //neighbours.size();
			}
			//System.out.println("Agent : "+agentID+" connectivity =
			// "+connect+" tempEta = "+tempEta);
		}
		return tempEta;
	}

	// Part III - Data Exchanges =============
	//	======================================
	//	III-1 Agent's State
	/**
	 * Get the state of the agent used by the <em>Canevas</em> Return stable
	 * state at each Canevas update (including between iterations) Required to
	 * be a CAgent
	 * 
	 * @return a Boolean Object
	 * @see modulecoGUI.grapheco.Canevas
	 */
	public Object getState() {
		//System.out.println(" agent.getState() ");
		return new Boolean(adopter);
	}

	/**
	 * flag : return true when the state of the Agent has Changed
	 * 
	 * @return hasChanged
	 */
	public Boolean hasChanged() {
		return new Boolean(hasChanged);
	}

	/**
	 * Return some information about the agent Accessible on right-click
	 */
	public ArrayList getDescriptors() {
		descriptors.clear();
		descriptors.add(new IntegerDataDescriptor(this, "State", "state",
				state, false));
		descriptors.add(new BooleanDataDescriptor(this, "primaryAdopter",
				"primaryAdopter", primaryAdopter, false));
		descriptors.add(new BooleanDataDescriptor(this, "Refractory",
				"refractory", refractory, false));
		descriptors.add(new DoubleDataDescriptor(this, "obs.Eta",
				"observedEta", observedEta, false, 4));
		descriptors.add(new DoubleDataDescriptor(this, "Theta", "theta", theta,
				false, 6));
		descriptors.add(new IntegerDataDescriptor(this, "Connectivity",
				"connectivity", connectivity, false));
		// add DP 13/09/2002
		return descriptors;
	}

	//	============================
	//	III-2 Agent's fields (state)
	/**
	 *  
	 */
	public boolean getPrimaryAdopter() {

		return primaryAdopter;
	}

	/**
	 *  
	 */
	public boolean getRefractory() {
		return refractory;
	}

	//	============================================
	//	III-3 Agent's parameters and others fields
	/**
	 *  
	 */
	protected void setTheta(double newTheta) {
		//System.out.println(" agent.setTheta() ");
		theta = newTheta;
	}

	/**
	 *  
	 */
	public double getTheta() {
		return theta;
	}

	/**
	 * 
	 * @return
	 */
	public int getConnectivity() {
		if (world.getNeighbourSelected() == "World")
			connectivity = world.agentSetSize - 1;
		else
			connectivity = neighbours.size();
		//if( connectivity == ((World)
		// world).getNeighbourSize())System.out.println("TEST");
		//else System.out.println("agent : "+agentID+" connectivity =
		// "+connectivity);
		return connectivity;

		//for (Iterator i= neighbours.iterator();i.hasNext();) {
		//Agent ag =((Agent) i.next());
	}

	/**
	 * 
	 * @return
	 */
	public double getAdjustedWP() {
		double wp;
		wp = java.lang.StrictMath.max(j * observedEta + theta, 0);
		//if (wp > 1.8 && test) { // DP 20/08/2002
		//System.out.println("agent : "+agentID+" wp = a*eta+theta = "+wp);
		//test = false;
		//}
		return wp;
	}
}