/*
* Ball.java - Communicator: the connection module of MadKit
* Copyright (C) 1998-2007 Olivier Gutknecht, Pierre Bommel, Fabien Michel, Thomas Cahuzac
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility.demo;

import madkit.kernel.*;
import madkit.messages.*;
import java.util.*;

public class Ball extends Agent
{
int i=0;	

public void activate() 
{
	println("Super Ball agent Activated");
	while(nextMessage() != null);
	if(! isGroup("local balls"))// si il n'y a pas de groupe lon cr�e un 
		createGroup(false,"local balls",null,null);
	requestRole("local balls","ball");
	println("ready to be shooted !!!!");
}


public void live()
{
	while(true)
	{
		exitImmediatlyOnKill();
		Message m;
		if (! isMessageBoxEmpty())
		{
			m = nextMessage();
			//System.err.println("mon message est "+m);
			if(Math.random() < 0.5)
				println("aille !!!!");
			else
				println("ouille !!!!");
			KernelAddress destination = (KernelAddress) ((KernelMessage) m).getArgument();
			AgentAddress kernelA = getAgentWithRole("communications","site");
			disposeMyGUI();
			sendMessage(kernelA,new NetworkRequest(NetworkRequest.REQUEST_MIGRATION, destination));
		}
		pause(500);
		println("no message");
	}
}

public void end()
{
	System.err.println("ball killed !!");
}

}
