/*
* Group.java - Kernel: the kernel of MadKit
* Copyright (C) 1998-2007 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;

import java.util.Vector;

/** A MadKit group definition. A group in Aalaadin/MadKit is defined as a set
  of Role objects. Any member can hold many roles within the group.
  This class is an internal MadKit structure.
   
   new Group class for MadKit 3.0
    @author Mansour Saber
    @version 1.0 14/05/04
*/
public class Operation extends ScriptMobility
{
	Vector listActs;
	
	public Operation()
	{
		listActs = new Vector(1,1);
	}

 	public String toString()
  {	
		String txt ="";
		if(name!=null)
			txt+="\tThe name of the operation is : "+name;

		if(listActs!=null)	
		{  
		  for(int i=0;i<listActs.size();i++)
			txt+="\n \t The actions are : "+listActs.elementAt(i).toString();
		}
		return txt;	
	}	

	public void addAction(Action ac)
	{
		listActs.add(ac);
	}
	
	public Action getNextAction()
	{	
		if(listActs!=null)
			return (Action)listActs.elementAt(0);
		else
		  return null;
	}
	
	public boolean removeAction(int nb)
	{
		if(listActs!=null && nb<listActs.size())
		{	
			listActs.remove(nb);
			return true;
		}
		return false;
	}

	
	public Vector getListActs()
	{
		return listActs;
	}
	

	
}

