/*
* mobileAgent.java - Kernel: the kernel of MadKit
* Copyright (C) 1998-2004 Mansour Saber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;
/** The main MadKit mobileAgent class. Provides support for non threaded agent
 * lifecycle, messaging, graphical interface, group and roles
 * management, agent information, ...
 *
 * The agent behavior intentionnaly is *not* defined. It is up to the
 * agent developer to choose an agent model or to develop his specific
 * agent library on top of the facilities provided by MadKit. However,
 * all agent share the same organizational view, and the basic
 * messaging code, so integration of agent coming from different
 * developer and having heterogeneous models is quite easy.
 *
 * Agent-related methods (almost everything here) can invoked only
 * after registration in the kernel (i.e. after the activate() method has been called
 * on this agent). That means that you should not use any of the agent methods in
 * constructor
 *
  @author Mansour Saber

 */
	import java.lang.*;
	import java.util.Vector ;
 	import madkit.kernel.*;

	import java.io.IOException;
	import org.xml.sax.SAXException;
	import org.xml.sax.XMLReader;
	import org.xml.sax.helpers.XMLReaderFactory;

	
	public  abstract class MobileAgent extends Agent implements Mobile
	{

		protected String idMobile = "";
		protected AgentAddress myBirthAddress;
		protected String myPlace;
		protected String currentPlace;
		protected KernelAddress myAgency;
		protected AgentAddress placeKeeper=null;
		protected int state;
		private String password="";
		private Mirror myMirror = null;
		AgentAddress mirrorAddress;
		Vector persistantRoles;
		protected Vector listMissions;
		
		final public static String MOBILE_GROUP="Mobility";


		public MobileAgent(String place)
		{
					myPlace=place;
					persistantRoles = new Vector(1,1);
					listMissions = new Vector(1,1);
		}

		public final void activate()
		{
			if(myAgency==null) // je viens d'etre crer
			{
					System.err.println("New mobile agent in the Place : "+myPlace);
					if(!isGroup(MOBILE_GROUP)) // A group named Mobility must be created first
					{
							System.err.println("This application is not yet able to be a mobile one ! You must create a mobile Group first.");
							end();
					}
					else if(!isGroup(myPlace))
					{
							System.err.println("Place : "+myPlace+" doesn't exist!");
							end();
					}
					else
					{
						myBirthAddress =  new AgentAddress(getAddress());
						myAgency = myBirthAddress.getKernel();
						joinGroup(MOBILE_GROUP);
						pause(500);
						joinPlace(myPlace,"");
						pause(500);
						requestRole(myPlace,"mobileAgent");
						currentPlace = myPlace;
						placeKeeper = getAgentWithRole(myPlace,"placeKeeperOf"+myPlace);// We look for the placeKeeper
						sendMessage(placeKeeper,new StringMessage("newMobileAgent"));
						if(placeKeeper!= null)
						{
					 		//println("Je viens de trouver le place Keeper");
							sendMessage(placeKeeper,new StringMessage("requestMobileId"));// on demande un idMobile du placeKeeper
							while(idMobile.equals(""))// boucler jusqu' avoir un message du keeper pour nous donner un idMobile unique
							{
								Message m=waitNextMessage();// On attend l'idMobile;
								handlingMessage(m);
							}
							requestRole(MOBILE_GROUP,idMobile);
						}
						else
						{
							System.err.println("Problem the placeKeeperOf"+myPlace+" not found");
						}
					}
			}
			else// On n'est pas un nouveau ne
			{

					if(getMyAgency().equals(getCurrentKernelAddress()))			// On est de retour dans notre Agence
					{
						System.err.println("I'm back at my agency");
						joinGroup(MOBILE_GROUP);
						pause(500);
						joinPlace(myPlace,password);
						pause(500);
						requestRole(MOBILE_GROUP,idMobile);
						requestRole(myPlace,"mobileAgent");
						placeKeeper = getAgentWithRole(myPlace,"placeKeeperOf"+myPlace);// We look for the placeKeeper
						treatWithMirror(); // Ici on laisse  l'utilsiateur de rcuperer le msgBox et toute autre infomation
						// que le mirror n'avait pas pu envoyer (dones critiques, ou....)
						myMirror = null;
					}
					else // On est dans une autre agence on ne fait rien si on n'a rien  faire
					{
						System.err.println("The Agent is now in a foreign agency.");
						joinGroup(MOBILE_GROUP);
						pause(500);
						requestRole(MOBILE_GROUP,idMobile);
						joinPlace(currentPlace,password);//
						pause(500);
						if(currentPlace!=null)
						  placeKeeper = getAgentWithRole(currentPlace,"placeKeeperOf"+myPlace);// We look for the placeKeeper
						//afterMigration();
						sendMessage(myBirthAddress,new StringMessage("Arrived"));
					}
			}
				//
		}

		public boolean createItinerary(String path) throws SAXException, IOException// create the itininerary from a scipt mobility XML file
		{
			try
			{
  			 SaxHandler handler = new SaxHandler();
				 XMLReader saxReader = XMLReaderFactory.createXMLReader();
 				 saxReader.setContentHandler(handler);
  			 saxReader.parse(path); 
  			 listMissions = handler.getListMissions();
				
				if(listMissions==null)
					return false;
				else
				{
					return true;
				}
      } 
			catch (Exception e) 
			{
        e.printStackTrace();
				return false;
  	  }
			
		}
		
		public void addMission(Mission m)
		{
		 try
		 {
			listMissions.addElement(m);
			}
			catch(Exception e)
			{
			System.err.println("Error admission"+e.toString());
			}
		}
		
		public int executeMission(Mission m)
		{
			if(m!=null)
			{
				while((m.getListOperations()).size()>0)
				{
				  Operation op=null;
					Action act = m.getNextAction();

					if(m.getListOperations()!=null)
						op = (Operation) m.getListOperations().elementAt(0);
					if(act!=null)
					{
						Vector dest = act.getDestination();
						Vector listMethods = act.getListCommands();
						if(dest!=null)
						{
							//System.out.println("La destination est "+dest.toString()+"la taille est "+dest.size());
							switch (dest.size())
							{
								case 2 :
								{
									if(dest.elementAt(0) instanceof String)
									{
								//		System.err.println("on cherhce l'agence au nom "+(String)dest.elementAt(0));
										KernelAddress ag = getAgencyNamed((String)dest.elementAt(0));
										if(ag==null)
										{
											System.err.println("Error destination agency not found!!"+(String)dest.elementAt(0));
											return -4; //
										}
										String place= new String((String)dest.elementAt(1));
											act.removeDestination();
											moveToPlace(ag,place);
										return 1;
									}
									else if(dest.elementAt(1) instanceof KernelAddress)
									 return 1;// A terminer avec discussion sur le deuxime par : place ...
								 break;
								}
								case 1 :
								{
									if(dest.elementAt(1) instanceof String)
									{
											KernelAddress ag = getAgencyNamed((String)dest.elementAt(0));
											if(ag==null)
											{
												System.err.println("Error destination agency not found!!");
												return -4; //
											}
											return(moveToAgency(ag));
									}
									else if(dest.elementAt(1) instanceof KernelAddress)
									{
										return(moveToAgency((KernelAddress)dest.elementAt(0)));
									}
									else
									 return -9;
								}
								default :
								{
									System.err.println("Error destination agency not found!!");
									return -5; //
								}
							}
							dest=null;
						}
						else
						{
							boolean success=true;
							for(int i=0;i<listMethods.size() && success;i++)
							{
								//System.out.println("Liste des mthodes : HHHHHHHHH");
							  Command meth = (Command) listMethods.elementAt(i);
								try
								{
									//System.out.println("Exectuion de la mthode numro "+i+" parmis "+listMethods.size()+" methodes cette mthode est :"+meth.getName());
									if(!executeMethod(meth.getName(),meth.getListArgs()))
									{
										System.err.println("Error while trying to execute the methode : "+meth.getName());
										success = false;
									}
									
									listMethods.remove(0);
								}
								catch(Exception e)
								{
									System.err.println("Error executing method : "+meth.getName());
									success=false;
								}

							}
							if(success)
								m.removeAction();
						}
					}
					else
					 return -6;
					}
				}
				listMissions.remove(0);
				return -7;// Mission null
		}

		public KernelAddress getDestination()
 		{
			sendMessage(getAgentWithRole("communications","site"),new NetworkRequest(NetworkRequest.GET_AVAILABLE_DESTINATIONS));
			KernelAddress dest=null;
					Message m=waitNextMessage();
					if(m instanceof NetworkRequest)
					{
						KernelAddress[] destinations = (KernelAddress[])((NetworkRequest) m).getArgument();
  					if(destinations.length > 0)
  					{
							dest= destinations[0];
						}
					}
				  return dest;
		}
		
    public Class[] getArgsClasses(Vector args)
    {
          if(args==null)
           return null;
          try
          {
            Class[] argsClasses = new Class[args.size()];
						
						for(int i=0;i<args.size();i++)
            {
              java.lang.reflect.Field arg = this.getClass().getDeclaredField((String)(args.elementAt(i)));
              if(arg!=null)
                argsClasses[i]=arg.getType();
               else
                return null;
            }
            return argsClasses;
          }
          catch(Exception e)
          {
            System.out.println("Error occured while trying to get arguments Classes"+e.toString());
            return null;
          }

      }


		public boolean executeMethod(String method, Vector args)
		{
		 // System.out.println("la mthode est "+method+"\n la liste des args est "+args.toString());
	    try
      {
            Class [] argsClasses = getArgsClasses(args);
						java.lang.reflect.Method mth=getClass().getDeclaredMethod(method,argsClasses);
            Object para[]= new Object[args.size()];
            for(int i=0;i<args.size();i++)
            {
                para[i] = getClass().getDeclaredField((String)args.elementAt(i)).get(this);
            }
            mth.invoke(this,para);
						return(true);
       }
       catch (Exception e)
       {
          System.out.println("The Error is "+e.toString());
					return false;
       }
 
	}

		public boolean addMission(Mission m, int pos)
		{
			if(pos<listMissions.size())
			{
				listMissions.add(pos,m);
				return true;
			}
			else
			  return false;
		}

	
		private void handlingMessage(Message m)
		{
			if(m.getSender() == placeKeeper) //A changer avec exp isInstance of mobilityMessage.getIdMobile
			{
					if(m instanceof StringMessage)
						idMobile = ((StringMessage)m).getString();
					else if(m instanceof MigrationAnswer)
					{
						state = ((MigrationAnswer)m).getAnswer();
					}
			}
		}

		public final KernelAddress getMyAgency()
		{
				return myAgency;
		}

		public String getMyPlace()
		{
				return myPlace;
		}

		public void setMirrorAgent(Mirror mirror)
		{
			myMirror = mirror;
		}

		public String getCurrentPlace()
		{
				return currentPlace;
		}

		public void treatWithMirror() // this method is used in order to get from the mirror the informations
		{                            // he wasn't able to send throw the network for a security reasons or ....

			System.out.println("Hello now we have to deal with myMirrorAgent ");
			//myMirror.ecrire("I m sorry mirror but i will kill you!!");
		}

		public void requestService(String community,String groupName,String role, boolean persistant)
		{
			requestService(community,groupName,role,null,persistant);
		}

		public int requestService(String community,String groupName,String role,Object memberCard, boolean persistant)
		{
			int answer = requestRole(community,groupName,role,memberCard);
			if(answer == 1)
			{
					if(persistant)
					{
						Vector newRole = new Vector(3,1);
						newRole.addElement(community);
						newRole.addElement(groupName);
						newRole.addElement(role);
						persistantRoles.add(newRole);
					}
			}
			return answer;
		}

		public String getPassword()
		{
				return password;
		}

		public final AgentAddress getMyBirthAddress()
		{
			return myBirthAddress;
		}

		public void end()
		{
			killAgent(this);	// A terminer  si on est dans notre site ok sinon informer notre site de notre mort
		}

		public final String getIdMobile()
		{
			return (idMobile);
		}

 		private final boolean isAgency(KernelAddress ag)
		{
				if(ag!=null)
				{
					sendMessage(getAgentWithRole("communications","site"),new NetworkRequest(NetworkRequest.GET_AVAILABLE_DESTINATIONS));
	 				//Demande d'un site o migrer
					while (true)
					{
						Message m=waitNextMessage();
			  	  if(m instanceof NetworkRequest)
						{
							KernelAddress[] destinations = (KernelAddress[])((NetworkRequest) m).getArgument();
					  	//On vrifie qu'on a enfin une adresse valide

			  				if(destinations.length > 0)
			  				{
									boolean found=false;
				 					for(int i=0;i<destinations.length && found ==false;i++)
									{
										//System.err.println("La destination est "+ag.toString()+"on verifie la destination"+ destinations[i].toString());
										if(destinations[i].equals(ag))// Cette destination est bien valide (On doit integrer a dans le noyeau
										{													//	Sous la forme de isDestination(KernalAdress ad)
												found = true;
										}

									}
									if(found == false)
									{
										System.err.println("Migration failed : Destination not found!! ");
										return false;
									}
									else
									 return true;
								}
								else
									return false; // pas de destiantion Connecte.
						}
				}
			}
			else
			 return false;
		}

		public Mirror  createMirror(KernelAddress agence)
		{
			Vector destination = new Vector(2,1);
			destination.addElement(agence);
			destination.addElement(currentPlace);
			Mirror mirror = new MirrorAgent(destination);
			System.out.println("Mirror Created");
			return mirror;
		}

		public final int moveToAgency(KernelAddress agency)//, String place)
		{
				System.err.println("The destination is "+agency.toString());
				if(isAgency(agency))
				{
					return moveToPlace(agency,"");
				}
				else
				{
					return -1;
				}
		}

		public abstract  void negociateMigration(MigrationAnswer answer);

		public int moveToPlace(KernelAddress agency,String place,long timeOut)
		{
				if(isAgency(agency))
				{
					System.err.println("The destination is "+agency.toString()+" The place is "+place);
					// on migre en s'envoyant comme msg
					if(agency.equals(getAddress().getKernel()))
					{
							System.out.println("Internal Migration )");
					}
					else
					{
						MigrationRequest req= new MigrationRequest(myAgency,getAddress(),myPlace,place,agency,0,0,null,null);
						sendMessage(placeKeeper,req);
						state = -4;// On a  demand une migration
						Message m= null;
						while(state==-4)
						{
							m=waitNextMessage(timeOut);// attente de la rponse de la part du placeKeeper Distant.
							if(m==null)
							{
								System.err.println("No answer from the placeKeeper PlaceKeeper");
								return -3;
							}
							handlingMessage(m);
						}
						switch (state)
						{
								case -1: // Migration Failed
								{
								 System.err.println("Migration wasn't allowed by the Agency.");
								 break;
								}
								case 0 :
								{
								 System.err.println("Migration must be discussed.");
								 break;
								}
								case 1 :
								{
									disposeMyGUI();
									System.err.println("Migration Succeeded.");
									currentPlace = place;
									password = ((MigrationAnswer)m).getPassword();
									sendMessage(placeKeeper,new StringMessage("willLeave"));
									ObjectMessage msg = null;

									if(persistantRoles.size()!=0)
									{
										msg= new ObjectMessage(persistantRoles);
										sendMessage(myBirthAddress, msg);
										//System.out.println("On a envoy  notre mirroir "+myBirthAddress.toString()+"et on lui dit "+persistantRoles.toString());
										persistantRoles.removeAllElements();
									}
										sendMessage(getAgentWithRole("communications","site"),new NetworkRequest(NetworkRequest.REQUEST_MIGRATION,agency));

									break;
								}
						}
					}
			 		return state;
				}
				else
				{
					System.err.println("Migration failed : Destination not found!! ");
					//System.err.println("La destination est "+agency+" my agency est"+myAgency);
					//capture(agentThread);
					return -2;
				}
		}

		public int moveToPlace(KernelAddress agence,String place)
		{
			return (moveToPlace(agence,place,(long)Long.MAX_VALUE));
		}
}
