/*
* NetworkRequest.java - Kernel: the kernel of MadKit
* Copyright (C) 1998-2007 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.mobility;

import madkit.kernel.*;


/** This message class is to be used to allow communications between mobileAgent and the placeKeeper
  	of the corresponding running kernel.

    @author Mansour Saber 07/04/04
    @version 1.0
*/

final public class MigrationAnswer extends Message implements PrivateMessage
{
	private AgentAddress agentAddress;
	
	private int answer;// 0: let's discuss // 1 :OK // -1 : i will Never receive you
	
	private int allowedRights; // 
	private String destinationPlace; //The place where the mobile agent is now
	private int neededRights; // 
	
	private Object key; // Some Agency will need a key to allow receiving mobileAgents or it may be the key to be received to the place

	private Object others; // Any other specific informations a developper can add
	
	private String password;
	

	public MigrationAnswer(AgentAddress agent, String dest, int ans, int allowedR, int neededR,String pwd)
	{
		agentAddress = agent;
		answer = ans;
		neededRights = neededR;
		allowedRights = allowedR;
		destinationPlace = dest;
		password = pwd;
	}

	
	public String getDestinationPlace() {return destinationPlace;}

	public AgentAddress getAgentAddress(){	return agentAddress;    }
	
	public int getAnswer() {return answer;}
	
	public int getNeededRights() {return neededRights;}
	
  public int getAllowedRights() {return allowedRights;}
	
	public String getPassword(){return password;}
	
}
