/*
* Watcher.java - Kernel: the kernel of MadKit
* Copyright (C) 1998-2008 Olivier Gutknecht, Fabien Michel, Jacques Ferber
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.

* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.

* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
package madkit.kernel;

import java.util.ArrayList;
import java.util.Iterator;

/** This class defines a generic watcher agent. It holds a collection of probes to explore agents' internal properties.

    @author Fabien Michel (MadKit 3.0 05/09/01) and 2.0 (Overlooker).
    @author Olivier Gutknecht version 1.0
    @since MadKit 2.0
    @version 3.0
*/

public abstract class Watcher extends AbstractAgent
{
	final private ArrayList<Probe<? extends AbstractAgent>> probes = new ArrayList<Probe<? extends AbstractAgent>>(7);
	
final synchronized public void addProbe(Probe<? extends AbstractAgent> p)
{
	if(currentKernel.addOverlooker(getAddress(), p, null))
		probes.add(p);
}

final synchronized public void addProbe(Probe<? extends AbstractAgent> p, Object accessCard)
{
	if(currentKernel.addOverlooker(getAddress(), p, accessCard))
		probes.add(p);
}
    
final synchronized public void removeProbe(Probe<? extends AbstractAgent> p)
{
	if(probes.remove(p))
		currentKernel.removeOverlooker(p);
}

@SuppressWarnings("unchecked")
final public Probe<? extends AbstractAgent>[] getProbes()
{
	return (Probe<? extends AbstractAgent>[]) probes.toArray();
}

final synchronized public void removeAllProbes()
{
	for (Iterator<Probe<? extends AbstractAgent>> i = probes.iterator();i.hasNext();)
	{
		currentKernel.removeOverlooker(i.next());
		i.remove();
	}
}

/** the end method will remove all the probes which have been used by the scheduler.
 * 
 *   Overriding this method, one should use <code>super.end()</code> first in order to ease the removal of simulated agents which will be killed. 
 *   Doing so can greatly improved the "killing time" of simulation engines
 * @see madkit.kernel.AbstractAgent#end()
 */
@Override
public void end()
{
	removeAllProbes();
}

/** @deprecated since MadKit 2.1 : update is now useless as the Probe's agents variable is updated automatically*/
public void update(){}
}
