/* This file was generated by SableCC (http://www.sablecc.org/). */
/**
 * ***************************************************************
 * 
 * classe gnre par sableCC pour le parser 
 * GNU Lesser General Public License
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation,
 * version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 * **************************************************************
 */
package madkit.fipa.sl.parser;

import madkit.fipa.sl.lexer.*;
import madkit.fipa.sl.node.*;
import madkit.fipa.sl.analysis.*;
import java.util.*;

import java.io.DataInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;

public class Parser
{
    public final Analysis ignoredTokens = new AnalysisAdapter();

    protected Node node;

    private final Lexer lexer;
    private final ListIterator stack = new LinkedList().listIterator();
    private int last_shift;
    private int last_pos;
    private int last_line;
    private Token last_token;
    private final TokenIndex converter = new TokenIndex();
    private final int[] action = new int[2];

    private final static int SHIFT = 0;
    private final static int REDUCE = 1;
    private final static int ACCEPT = 2;
    private final static int ERROR = 3;

    protected void filter() throws ParserException, LexerException, IOException
    {
    }

    public Parser(Lexer lexer)
    {
        this.lexer = lexer;

        if(actionTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Parser.class.getResourceAsStream("parser.dat")));

                // read actionTable
                int length = s.readInt();
                actionTable = new int[length][][];
                for(int i = 0; i < actionTable.length; i++)
                {
                    length = s.readInt();
                    actionTable[i] = new int[length][3];
                    for(int j = 0; j < actionTable[i].length; j++)
                    {
                        for(int k = 0; k < 3; k++)
                        {
                            actionTable[i][j][k] = s.readInt();
                        }
                    }
                }

                // read gotoTable
                length = s.readInt();
                gotoTable = new int[length][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][2];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        for(int k = 0; k < 2; k++)
                        {
                            gotoTable[i][j][k] = s.readInt();
                        }
                    }
                }

                // read errorMessages
                length = s.readInt();
                errorMessages = new String[length];
                for(int i = 0; i < errorMessages.length; i++)
                {
                    length = s.readInt();
                    StringBuffer buffer = new StringBuffer();

                    for(int j = 0; j < length; j++)
                    {
                        buffer.append(s.readChar());
                    }
                    errorMessages[i] = buffer.toString();
                }

                // read errors
                length = s.readInt();
                errors = new int[length];
                for(int i = 0; i < errors.length; i++)
                {
                    errors[i] = s.readInt();
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("The file \"parser.dat\" is either missing or corrupted.");
            }
        }
    }

    private int goTo(int index)
    {
        int state = state();
        int low = 1;
        int high = gotoTable[index].length - 1;
        int value = gotoTable[index][0][1];

        while(low <= high)
        {
            int middle = (low + high) / 2;

            if(state < gotoTable[index][middle][0])
            {
                high = middle - 1;
            }
            else if(state > gotoTable[index][middle][0])
            {
                low = middle + 1;
            }
            else
            {
                value = gotoTable[index][middle][1];
                break;
            }
        }

        return value;
    }

    private void push(int state, Node node, boolean filter) throws ParserException, LexerException, IOException
    {
        this.node = node;

        if(filter)
        {
            filter();
        }

        if(!stack.hasNext())
        {
            stack.add(new State(state, this.node));
            return;
        }

        State s = (State) stack.next();
        s.state = state;
        s.node = this.node;
    }

    private int state()
    {
        State s = (State) stack.previous();
        stack.next();
        return s.state;
    }

    private Node pop()
    {
        return (Node) ((State) stack.previous()).node;
    }

    private int index(Switchable token)
    {
        converter.index = -1;
        token.apply(converter);
        return converter.index;
    }

    public Start parse() throws ParserException, LexerException, IOException
    {
        push(0, null, false);

        List ign = null;
        while(true)
        {
            while(index(lexer.peek()) == -1)
            {
                if(ign == null)
                {
                    ign = new TypedLinkedList(NodeCast.instance);
                }

                ign.add(lexer.next());
            }

            if(ign != null)
            {
                ignoredTokens.setIn(lexer.peek(), ign);
                ign = null;
            }

            last_pos = lexer.peek().getPos();
            last_line = lexer.peek().getLine();
            last_token = lexer.peek();

            int index = index(lexer.peek());
            action[0] = actionTable[state()][0][1];
            action[1] = actionTable[state()][0][2];

            int low = 1;
            int high = actionTable[state()].length - 1;

            while(low <= high)
            {
                int middle = (low + high) / 2;

                if(index < actionTable[state()][middle][0])
                {
                    high = middle - 1;
                }
                else if(index > actionTable[state()][middle][0])
                {
                    low = middle + 1;
                }
                else
                {
                    action[0] = actionTable[state()][middle][1];
                    action[1] = actionTable[state()][middle][2];
                    break;
                }
            }

            switch(action[0])
            {
                case SHIFT:
                    push(action[1], lexer.next(), true);
                    last_shift = action[1];
                    break;
                case REDUCE:
                    switch(action[1])
                    {
                    case 0: { Node node = new0(); push(goTo(0), node, true); } break;
                    case 1: { Node node = new1(); push(goTo(19), node, false); } break;
                    case 2: { Node node = new2(); push(goTo(19), node, false); } break;
                    case 3: { Node node = new3(); push(goTo(1), node, true); } break;
                    case 4: { Node node = new4(); push(goTo(1), node, true); } break;
                    case 5: { Node node = new5(); push(goTo(1), node, true); } break;
                    case 6: { Node node = new6(); push(goTo(2), node, true); } break;
                    case 7: { Node node = new7(); push(goTo(2), node, true); } break;
                    case 8: { Node node = new8(); push(goTo(2), node, true); } break;
                    case 9: { Node node = new9(); push(goTo(2), node, true); } break;
                    case 10: { Node node = new10(); push(goTo(2), node, true); } break;
                    case 11: { Node node = new11(); push(goTo(2), node, true); } break;
                    case 12: { Node node = new12(); push(goTo(2), node, true); } break;
                    case 13: { Node node = new13(); push(goTo(20), node, false); } break;
                    case 14: { Node node = new14(); push(goTo(20), node, false); } break;
                    case 15: { Node node = new15(); push(goTo(2), node, true); } break;
                    case 16: { Node node = new16(); push(goTo(2), node, true); } break;
                    case 17: { Node node = new17(); push(goTo(3), node, true); } break;
                    case 18: { Node node = new18(); push(goTo(3), node, true); } break;
                    case 19: { Node node = new19(); push(goTo(3), node, true); } break;
                    case 20: { Node node = new20(); push(goTo(3), node, true); } break;
                    case 21: { Node node = new21(); push(goTo(3), node, true); } break;
                    case 22: { Node node = new22(); push(goTo(3), node, true); } break;
                    case 23: { Node node = new23(); push(goTo(3), node, true); } break;
                    case 24: { Node node = new24(); push(goTo(4), node, true); } break;
                    case 25: { Node node = new25(); push(goTo(4), node, true); } break;
                    case 26: { Node node = new26(); push(goTo(4), node, true); } break;
                    case 27: { Node node = new27(); push(goTo(5), node, true); } break;
                    case 28: { Node node = new28(); push(goTo(5), node, true); } break;
                    case 29: { Node node = new29(); push(goTo(5), node, true); } break;
                    case 30: { Node node = new30(); push(goTo(21), node, false); } break;
                    case 31: { Node node = new31(); push(goTo(21), node, false); } break;
                    case 32: { Node node = new32(); push(goTo(6), node, true); } break;
                    case 33: { Node node = new33(); push(goTo(6), node, true); } break;
                    case 34: { Node node = new34(); push(goTo(6), node, true); } break;
                    case 35: { Node node = new35(); push(goTo(7), node, true); } break;
                    case 36: { Node node = new36(); push(goTo(8), node, true); } break;
                    case 37: { Node node = new37(); push(goTo(8), node, true); } break;
                    case 38: { Node node = new38(); push(goTo(8), node, true); } break;
                    case 39: { Node node = new39(); push(goTo(9), node, true); } break;
                    case 40: { Node node = new40(); push(goTo(10), node, true); } break;
                    case 41: { Node node = new41(); push(goTo(11), node, true); } break;
                    case 42: { Node node = new42(); push(goTo(11), node, true); } break;
                    case 43: { Node node = new43(); push(goTo(11), node, true); } break;
                    case 44: { Node node = new44(); push(goTo(11), node, true); } break;
                    case 45: { Node node = new45(); push(goTo(11), node, true); } break;
                    case 46: { Node node = new46(); push(goTo(11), node, true); } break;
                    case 47: { Node node = new47(); push(goTo(11), node, true); } break;
                    case 48: { Node node = new48(); push(goTo(11), node, true); } break;
                    case 49: { Node node = new49(); push(goTo(12), node, true); } break;
                    case 50: { Node node = new50(); push(goTo(13), node, true); } break;
                    case 51: { Node node = new51(); push(goTo(13), node, true); } break;
                    case 52: { Node node = new52(); push(goTo(14), node, true); } break;
                    case 53: { Node node = new53(); push(goTo(14), node, true); } break;
                    case 54: { Node node = new54(); push(goTo(15), node, true); } break;
                    case 55: { Node node = new55(); push(goTo(16), node, true); } break;
                    case 56: { Node node = new56(); push(goTo(17), node, true); } break;
                    case 57: { Node node = new57(); push(goTo(17), node, true); } break;
                    case 58: { Node node = new58(); push(goTo(18), node, true); } break;
                    }
                    break;
                case ACCEPT:
                    {
                        EOF node2 = (EOF) lexer.next();
                        PContent node1 = (PContent) pop();
                        Start node = new Start(node1, node2);
                        return node;
                    }
                case ERROR:
                    throw new ParserException(last_token,
                        "[" + last_line + "," + last_pos + "] " +
                        errorMessages[errors[action[1]]]);
            }
        }
    }

    Node new0()
    {
        TRPar node3 = (TRPar) pop();
        XPContentExpression node2 = (XPContentExpression) pop();
        TLPar node1 = (TLPar) pop();
        AContent node = new AContent(node1, node2, node3);
        return node;
    }

    Node new1()
    {
        PContentExpression node2 = (PContentExpression) pop();
        XPContentExpression node1 = (XPContentExpression) pop();
        X1PContentExpression node = new X1PContentExpression(node1, node2);
        return node;
    }

    Node new2()
    {
        PContentExpression node1 = (PContentExpression) pop();
        X2PContentExpression node = new X2PContentExpression(node1);
        return node;
    }

    Node new3()
    {
        PIdentifyingExpression node1 = (PIdentifyingExpression) pop();
        AIdentifyingContentExpression node = new AIdentifyingContentExpression(node1);
        return node;
    }

    Node new4()
    {
        PActionExpression node1 = (PActionExpression) pop();
        AActionContentExpression node = new AActionContentExpression(node1);
        return node;
    }

    Node new5()
    {
        PProposition node1 = (PProposition) pop();
        APropositionContentExpression node = new APropositionContentExpression(node1);
        return node;
    }

    Node new6()
    {
        TRPar node4 = (TRPar) pop();
        PProposition node3 = (PProposition) pop();
        TNot node2 = (TNot) pop();
        TLPar node1 = (TLPar) pop();
        ANegationProposition node = new ANegationProposition(node1, node2, node3, node4);
        return node;
    }

    Node new7()
    {
        TRPar node5 = (TRPar) pop();
        PProposition node4 = (PProposition) pop();
        PProposition node3 = (PProposition) pop();
        TOr node2 = (TOr) pop();
        TLPar node1 = (TLPar) pop();
        ADisjunctionProposition node = new ADisjunctionProposition(node1, node2, node3, node4, node5);
        return node;
    }

    Node new8()
    {
        TRPar node5 = (TRPar) pop();
        PProposition node4 = (PProposition) pop();
        PProposition node3 = (PProposition) pop();
        TImplies node2 = (TImplies) pop();
        TLPar node1 = (TLPar) pop();
        AImplicationProposition node = new AImplicationProposition(node1, node2, node3, node4, node5);
        return node;
    }

    Node new9()
    {
        TRPar node5 = (TRPar) pop();
        PProposition node4 = (PProposition) pop();
        PProposition node3 = (PProposition) pop();
        TEquiv node2 = (TEquiv) pop();
        TLPar node1 = (TLPar) pop();
        AEquivalenceProposition node = new AEquivalenceProposition(node1, node2, node3, node4, node5);
        return node;
    }

    Node new10()
    {
        TRPar node5 = (TRPar) pop();
        PProposition node4 = (PProposition) pop();
        PVariable node3 = (PVariable) pop();
        TExists node2 = (TExists) pop();
        TLPar node1 = (TLPar) pop();
        AExistentialProposition node = new AExistentialProposition(node1, node2, node3, node4, node5);
        return node;
    }

    Node new11()
    {
        TRPar node5 = (TRPar) pop();
        PProposition node4 = (PProposition) pop();
        PVariable node3 = (PVariable) pop();
        TForall node2 = (TForall) pop();
        TLPar node1 = (TLPar) pop();
        AUniversalProposition node = new AUniversalProposition(node1, node2, node3, node4, node5);
        return node;
    }

    Node new12()
    {
        TRPar node4 = (TRPar) pop();
        XPTerm node3 = (XPTerm) pop();
        PPredicateSymbol node2 = (PPredicateSymbol) pop();
        TLPar node1 = (TLPar) pop();
        APredicateProposition node = new APredicateProposition(node1, node2, node3, node4);
        return node;
    }

    Node new13()
    {
        PTerm node2 = (PTerm) pop();
        XPTerm node1 = (XPTerm) pop();
        X1PTerm node = new X1PTerm(node1, node2);
        return node;
    }

    Node new14()
    {
        PTerm node1 = (PTerm) pop();
        X2PTerm node = new X2PTerm(node1);
        return node;
    }

    Node new15()
    {
        TTrue node1 = (TTrue) pop();
        ATrueProposition node = new ATrueProposition(node1);
        return node;
    }

    Node new16()
    {
        TFalse node1 = (TFalse) pop();
        AFalseProposition node = new AFalseProposition(node1);
        return node;
    }

    Node new17()
    {
        PVariable node1 = (PVariable) pop();
        AVariableTerm node = new AVariableTerm(node1);
        return node;
    }

    Node new18()
    {
        PFunctionalTerm node1 = (PFunctionalTerm) pop();
        AFunctionTerm node = new AFunctionTerm(node1);
        return node;
    }

    Node new19()
    {
        PActionExpression node1 = (PActionExpression) pop();
        AActionTerm node = new AActionTerm(node1);
        return node;
    }

    Node new20()
    {
        PIdentifyingExpression node1 = (PIdentifyingExpression) pop();
        AIdentifyingTerm node = new AIdentifyingTerm(node1);
        return node;
    }

    Node new21()
    {
        PConstant node1 = (PConstant) pop();
        AConstantTerm node = new AConstantTerm(node1);
        return node;
    }

    Node new22()
    {
        PSequence node1 = (PSequence) pop();
        ASequenceTerm node = new ASequenceTerm(node1);
        return node;
    }

    Node new23()
    {
        PSet node1 = (PSet) pop();
        ASetTerm node = new ASetTerm(node1);
        return node;
    }

    Node new24()
    {
        TRPar node5 = (TRPar) pop();
        PProposition node4 = (PProposition) pop();
        PTerm node3 = (PTerm) pop();
        TIota node2 = (TIota) pop();
        TLPar node1 = (TLPar) pop();
        AIotaIdentifyingExpression node = new AIotaIdentifyingExpression(node1, node2, node3, node4, node5);
        return node;
    }

    Node new25()
    {
        TRPar node5 = (TRPar) pop();
        PProposition node4 = (PProposition) pop();
        PTerm node3 = (PTerm) pop();
        TAny node2 = (TAny) pop();
        TLPar node1 = (TLPar) pop();
        AAnyIdentifyingExpression node = new AAnyIdentifyingExpression(node1, node2, node3, node4, node5);
        return node;
    }

    Node new26()
    {
        TRPar node5 = (TRPar) pop();
        PProposition node4 = (PProposition) pop();
        PTerm node3 = (PTerm) pop();
        TAll node2 = (TAll) pop();
        TLPar node1 = (TLPar) pop();
        AAllIdentifyingExpression node = new AAllIdentifyingExpression(node1, node2, node3, node4, node5);
        return node;
    }

    Node new27()
    {
        TRPar node4 = (TRPar) pop();
        XPTerm node3 = null;
        PFunctionSymbol node2 = (PFunctionSymbol) pop();
        TLPar node1 = (TLPar) pop();
        ANormalFunctionalTerm node = new ANormalFunctionalTerm(node1, node2, node3, node4);
        return node;
    }

    Node new28()
    {
        TRPar node4 = (TRPar) pop();
        XPTerm node3 = (XPTerm) pop();
        PFunctionSymbol node2 = (PFunctionSymbol) pop();
        TLPar node1 = (TLPar) pop();
        ANormalFunctionalTerm node = new ANormalFunctionalTerm(node1, node2, node3, node4);
        return node;
    }

    Node new29()
    {
        TRPar node4 = (TRPar) pop();
        XPParameter node3 = (XPParameter) pop();
        PFunctionSymbol node2 = (PFunctionSymbol) pop();
        TLPar node1 = (TLPar) pop();
        ANamedFunctionalTerm node = new ANamedFunctionalTerm(node1, node2, node3, node4);
        return node;
    }

    Node new30()
    {
        PParameter node2 = (PParameter) pop();
        XPParameter node1 = (XPParameter) pop();
        X1PParameter node = new X1PParameter(node1, node2);
        return node;
    }

    Node new31()
    {
        PParameter node1 = (PParameter) pop();
        X2PParameter node = new X2PParameter(node1);
        return node;
    }

    Node new32()
    {
        TInteger node1 = (TInteger) pop();
        AIntegerConstant node = new AIntegerConstant(node1);
        return node;
    }

    Node new33()
    {
        TFloat node1 = (TFloat) pop();
        AFloatConstant node = new AFloatConstant(node1);
        return node;
    }

    Node new34()
    {
        PString node1 = (PString) pop();
        AStringConstant node = new AStringConstant(node1);
        return node;
    }

    Node new35()
    {
        PString node2 = (PString) pop();
        TQMark node1 = (TQMark) pop();
        AVariable node = new AVariable(node1, node2);
        return node;
    }

    Node new36()
    {
        TRPar node5 = (TRPar) pop();
        PTerm node4 = (PTerm) pop();
        PAgent node3 = (PAgent) pop();
        TAction node2 = (TAction) pop();
        TLPar node1 = (TLPar) pop();
        AActionExpression node = new AActionExpression(node1, node2, node3, node4, node5);
        return node;
    }

    Node new37()
    {
        TRPar node5 = (TRPar) pop();
        PActionExpression node4 = (PActionExpression) pop();
        PActionExpression node3 = (PActionExpression) pop();
        TPipe node2 = (TPipe) pop();
        TLPar node1 = (TLPar) pop();
        ASequenceActionExpression node = new ASequenceActionExpression(node1, node2, node3, node4, node5);
        return node;
    }

    Node new38()
    {
        TRPar node5 = (TRPar) pop();
        PActionExpression node4 = (PActionExpression) pop();
        PActionExpression node3 = (PActionExpression) pop();
        TSemicolon node2 = (TSemicolon) pop();
        TLPar node1 = (TLPar) pop();
        AAlternativeActionExpression node = new AAlternativeActionExpression(node1, node2, node3, node4, node5);
        return node;
    }

    Node new39()
    {
        PString node1 = (PString) pop();
        APropositionSymbol node = new APropositionSymbol(node1);
        return node;
    }

    Node new40()
    {
        PString node1 = (PString) pop();
        APredicateSymbol node = new APredicateSymbol(node1);
        return node;
    }

    Node new41()
    {
        PString node1 = (PString) pop();
        AFunctionSymbol node = new AFunctionSymbol(node1);
        return node;
    }

    Node new42()
    {
        TAnd node1 = (TAnd) pop();
        ATmpAndFunctionSymbol node = new ATmpAndFunctionSymbol(node1);
        return node;
    }

    Node new43()
    {
        TOr node1 = (TOr) pop();
        ATmpOrFunctionSymbol node = new ATmpOrFunctionSymbol(node1);
        return node;
    }

    Node new44()
    {
        TNot node1 = (TNot) pop();
        ATmpNotFunctionSymbol node = new ATmpNotFunctionSymbol(node1);
        return node;
    }

    Node new45()
    {
        TImplies node1 = (TImplies) pop();
        ATmpImpliesFunctionSymbol node = new ATmpImpliesFunctionSymbol(node1);
        return node;
    }

    Node new46()
    {
        TEquiv node1 = (TEquiv) pop();
        ATmpEquivFunctionSymbol node = new ATmpEquivFunctionSymbol(node1);
        return node;
    }

    Node new47()
    {
        TForall node1 = (TForall) pop();
        ATmpForallFunctionSymbol node = new ATmpForallFunctionSymbol(node1);
        return node;
    }

    Node new48()
    {
        TExists node1 = (TExists) pop();
        ATmpExistsFunctionSymbol node = new ATmpExistsFunctionSymbol(node1);
        return node;
    }

    Node new49()
    {
        PTerm node1 = (PTerm) pop();
        AAgent node = new AAgent(node1);
        return node;
    }

    Node new50()
    {
        TRPar node4 = (TRPar) pop();
        XPTerm node3 = null;
        TSequence node2 = (TSequence) pop();
        TLPar node1 = (TLPar) pop();
        ASequence node = new ASequence(node1, node2, node3, node4);
        return node;
    }

    Node new51()
    {
        TRPar node4 = (TRPar) pop();
        XPTerm node3 = (XPTerm) pop();
        TSequence node2 = (TSequence) pop();
        TLPar node1 = (TLPar) pop();
        ASequence node = new ASequence(node1, node2, node3, node4);
        return node;
    }

    Node new52()
    {
        TRPar node4 = (TRPar) pop();
        XPTerm node3 = null;
        TSet node2 = (TSet) pop();
        TLPar node1 = (TLPar) pop();
        ASet node = new ASet(node1, node2, node3, node4);
        return node;
    }

    Node new53()
    {
        TRPar node4 = (TRPar) pop();
        XPTerm node3 = (XPTerm) pop();
        TSet node2 = (TSet) pop();
        TLPar node1 = (TLPar) pop();
        ASet node = new ASet(node1, node2, node3, node4);
        return node;
    }

    Node new54()
    {
        PParameterValue node2 = (PParameterValue) pop();
        PParameterName node1 = (PParameterName) pop();
        AParameter node = new AParameter(node1, node2);
        return node;
    }

    Node new55()
    {
        PTerm node1 = (PTerm) pop();
        AParameterValue node = new AParameterValue(node1);
        return node;
    }

    Node new56()
    {
        TWord node1 = (TWord) pop();
        AWordString node = new AWordString(node1);
        return node;
    }

    Node new57()
    {
        TStringLiteral node1 = (TStringLiteral) pop();
        ALiteralString node = new ALiteralString(node1);
        return node;
    }

    Node new58()
    {
        PString node2 = (PString) pop();
        TColon node1 = (TColon) pop();
        AParameterName node = new AParameterName(node1, node2);
        return node;
    }

    private static int[][][] actionTable;
/*      {
			{{-1, ERROR, 0}, {1, SHIFT, 1}, },
			{{-1, ERROR, 1}, {1, SHIFT, 3}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 2}, {28, ACCEPT, -1}, },
			{{-1, ERROR, 3}, {0, SHIFT, 11}, {5, SHIFT, 12}, {6, SHIFT, 13}, {7, SHIFT, 14}, {9, SHIFT, 15}, {10, SHIFT, 16}, {11, SHIFT, 17}, {16, SHIFT, 18}, {17, SHIFT, 19}, {20, SHIFT, 20}, {21, SHIFT, 21}, {22, SHIFT, 22}, {23, SHIFT, 23}, {27, SHIFT, 24}, },
			{{-1, REDUCE, 15}, },
			{{-1, REDUCE, 16}, },
			{{-1, REDUCE, 2}, },
			{{-1, REDUCE, 5}, },
			{{-1, REDUCE, 3}, },
			{{-1, REDUCE, 4}, },
			{{-1, ERROR, 10}, {1, SHIFT, 3}, {2, SHIFT, 27}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, REDUCE, 57}, },
			{{-1, ERROR, 12}, {1, SHIFT, 29}, },
			{{-1, ERROR, 13}, {1, SHIFT, 29}, },
			{{-1, ERROR, 14}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 15}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 16}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 17}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 18}, {3, SHIFT, 37}, },
			{{-1, ERROR, 19}, {3, SHIFT, 37}, },
			{{-1, ERROR, 20}, {0, SHIFT, 11}, {1, SHIFT, 40}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, ERROR, 21}, {0, SHIFT, 11}, {1, SHIFT, 40}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, ERROR, 22}, {0, SHIFT, 11}, {1, SHIFT, 40}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, ERROR, 23}, {0, SHIFT, 11}, {1, SHIFT, 40}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, REDUCE, 56}, },
			{{-1, ERROR, 25}, {0, SHIFT, 11}, {1, SHIFT, 40}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, REDUCE, 40}, },
			{{-1, REDUCE, 0}, },
			{{-1, REDUCE, 1}, },
			{{-1, ERROR, 29}, {5, SHIFT, 12}, {6, SHIFT, 13}, {20, SHIFT, 20}, },
			{{-1, ERROR, 30}, {1, SHIFT, 29}, },
			{{-1, ERROR, 31}, {1, SHIFT, 29}, },
			{{-1, ERROR, 32}, {0, SHIFT, 11}, {7, SHIFT, 14}, {9, SHIFT, 15}, {10, SHIFT, 16}, {11, SHIFT, 17}, {16, SHIFT, 18}, {17, SHIFT, 19}, {27, SHIFT, 24}, },
			{{-1, ERROR, 33}, {2, SHIFT, 60}, },
			{{-1, ERROR, 34}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 35}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 36}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 37}, {0, SHIFT, 11}, {27, SHIFT, 24}, },
			{{-1, ERROR, 38}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 39}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 40}, {0, SHIFT, 11}, {5, SHIFT, 12}, {6, SHIFT, 13}, {7, SHIFT, 67}, {8, SHIFT, 68}, {9, SHIFT, 69}, {10, SHIFT, 70}, {11, SHIFT, 71}, {14, SHIFT, 72}, {15, SHIFT, 73}, {16, SHIFT, 74}, {17, SHIFT, 75}, {20, SHIFT, 20}, {21, SHIFT, 21}, {22, SHIFT, 22}, {23, SHIFT, 23}, {27, SHIFT, 24}, },
			{{-1, REDUCE, 32}, },
			{{-1, REDUCE, 33}, },
			{{-1, REDUCE, 49}, },
			{{-1, REDUCE, 20}, },
			{{-1, REDUCE, 18}, },
			{{-1, REDUCE, 21}, },
			{{-1, REDUCE, 17}, },
			{{-1, REDUCE, 19}, },
			{{-1, ERROR, 49}, {0, SHIFT, 11}, {1, SHIFT, 40}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, REDUCE, 22}, },
			{{-1, REDUCE, 23}, },
			{{-1, REDUCE, 34}, },
			{{-1, ERROR, 53}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 54}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, ERROR, 55}, {1, SHIFT, 32}, {12, SHIFT, 4}, {13, SHIFT, 5}, },
			{{-1, REDUCE, 14}, },
			{{-1, ERROR, 57}, {0, SHIFT, 11}, {1, SHIFT, 40}, {2, SHIFT, 82}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, ERROR, 58}, {2, SHIFT, 84}, },
			{{-1, ERROR, 59}, {2, SHIFT, 85}, },
			{{-1, REDUCE, 6}, },
			{{-1, ERROR, 61}, {2, SHIFT, 86}, },
			{{-1, ERROR, 62}, {2, SHIFT, 87}, },
			{{-1, ERROR, 63}, {2, SHIFT, 88}, },
			{{-1, REDUCE, 35}, },
			{{-1, ERROR, 65}, {2, SHIFT, 89}, },
			{{-1, ERROR, 66}, {2, SHIFT, 90}, },
			{{-1, REDUCE, 44}, },
			{{-1, REDUCE, 42}, },
			{{-1, REDUCE, 43}, },
			{{-1, REDUCE, 45}, },
			{{-1, REDUCE, 46}, },
			{{-1, ERROR, 72}, {0, SHIFT, 11}, {1, SHIFT, 40}, {2, SHIFT, 91}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, ERROR, 73}, {0, SHIFT, 11}, {1, SHIFT, 40}, {2, SHIFT, 93}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, REDUCE, 47}, },
			{{-1, REDUCE, 48}, },
			{{-1, ERROR, 76}, {0, SHIFT, 11}, {1, SHIFT, 40}, {2, SHIFT, 95}, {3, SHIFT, 37}, {4, SHIFT, 96}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, REDUCE, 41}, },
			{{-1, ERROR, 78}, {2, SHIFT, 101}, },
			{{-1, ERROR, 79}, {2, SHIFT, 102}, },
			{{-1, ERROR, 80}, {2, SHIFT, 103}, },
			{{-1, ERROR, 81}, {2, SHIFT, 104}, },
			{{-1, REDUCE, 12}, },
			{{-1, REDUCE, 13}, },
			{{-1, REDUCE, 38}, },
			{{-1, REDUCE, 37}, },
			{{-1, REDUCE, 7}, },
			{{-1, REDUCE, 8}, },
			{{-1, REDUCE, 9}, },
			{{-1, REDUCE, 11}, },
			{{-1, REDUCE, 10}, },
			{{-1, REDUCE, 50}, },
			{{-1, ERROR, 92}, {0, SHIFT, 11}, {1, SHIFT, 40}, {2, SHIFT, 105}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, REDUCE, 52}, },
			{{-1, ERROR, 94}, {0, SHIFT, 11}, {1, SHIFT, 40}, {2, SHIFT, 106}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, REDUCE, 27}, },
			{{-1, ERROR, 96}, {0, SHIFT, 11}, {27, SHIFT, 24}, },
			{{-1, REDUCE, 31}, },
			{{-1, ERROR, 98}, {0, SHIFT, 11}, {1, SHIFT, 40}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, ERROR, 99}, {0, SHIFT, 11}, {1, SHIFT, 40}, {2, SHIFT, 110}, {3, SHIFT, 37}, {25, SHIFT, 41}, {26, SHIFT, 42}, {27, SHIFT, 24}, },
			{{-1, ERROR, 100}, {2, SHIFT, 111}, {4, SHIFT, 96}, },
			{{-1, REDUCE, 36}, },
			{{-1, REDUCE, 24}, },
			{{-1, REDUCE, 25}, },
			{{-1, REDUCE, 26}, },
			{{-1, REDUCE, 51}, },
			{{-1, REDUCE, 53}, },
			{{-1, REDUCE, 58}, },
			{{-1, REDUCE, 55}, },
			{{-1, REDUCE, 54}, },
			{{-1, REDUCE, 28}, },
			{{-1, REDUCE, 29}, },
			{{-1, REDUCE, 30}, },
        };*/
    private static int[][][] gotoTable;
/*      {
			{{-1, 2}, },
			{{-1, 6}, {10, 28}, },
			{{-1, 7}, {14, 33}, {15, 34}, {16, 35}, {17, 36}, {34, 61}, {35, 62}, {36, 63}, {38, 65}, {39, 66}, {53, 79}, {54, 80}, {55, 81}, },
			{{-1, 56}, {20, 43}, {21, 53}, {22, 54}, {23, 55}, {49, 78}, {57, 83}, {92, 83}, {94, 83}, {98, 108}, {99, 83}, },
			{{-1, 44}, {1, 8}, {10, 8}, },
			{{-1, 45}, },
			{{-1, 46}, },
			{{-1, 47}, {18, 38}, {19, 39}, },
			{{-1, 48}, {1, 9}, {10, 9}, {12, 30}, {13, 31}, {30, 58}, {31, 59}, },
			{{-1, -1}, },
			{{-1, 25}, },
			{{-1, 76}, },
			{{-1, 49}, },
			{{-1, 50}, },
			{{-1, 51}, },
			{{-1, 97}, {100, 112}, },
			{{-1, 109}, },
			{{-1, 52}, {3, 26}, {32, 26}, {37, 64}, {40, 77}, {96, 107}, },
			{{-1, 98}, },
			{{-1, 10}, },
			{{-1, 57}, {72, 92}, {73, 94}, {76, 99}, },
			{{-1, 100}, },
        };*/
    private static String[] errorMessages;
/*      {
			"expecting: l par",
			"expecting: l par, true, false",
			"expecting: EOF",
			"expecting: string literal, semicolon, pipe, not, or, implies, equiv, forall, exists, action, iota, any, all, word",
			"expecting: l par, r par, true, false",
			"expecting: string literal, l par, r par, q mark, colon, true, false, integer, float, word",
			"expecting: q mark",
			"expecting: string literal, l par, q mark, integer, float, word",
			"expecting: semicolon, pipe, action",
			"expecting: string literal, not, or, implies, equiv, forall, exists, word",
			"expecting: r par",
			"expecting: string literal, word",
			"expecting: string literal, semicolon, pipe, not, and, or, implies, equiv, sequence, set, forall, exists, action, iota, any, all, word",
			"expecting: string literal, l par, r par, q mark, integer, float, word",
			"expecting: string literal, l par, r par, q mark, colon, integer, float, word",
			"expecting: r par, colon",
        };*/
    private static int[] errors;
/*      {
			0, 1, 2, 3, 4, 4, 4, 4, 4, 4, 4, 5, 0, 0, 1, 1, 1, 1, 6, 6, 7, 7, 7, 7, 5, 7, 7, 2, 4, 8, 0, 0, 9, 10, 1, 1, 1, 11, 1, 1, 12, 5, 5, 7, 5, 5, 5, 5, 5, 7, 5, 5, 5, 1, 1, 1, 13, 13, 10, 10, 4, 10, 10, 10, 5, 10, 10, 14, 14, 14, 14, 14, 13, 13, 14, 14, 14, 14, 10, 10, 10, 10, 4, 13, 5, 5, 4, 4, 4, 4, 4, 5, 13, 5, 13, 5, 11, 15, 7, 13, 15, 5, 5, 5, 5, 5, 5, 7, 15, 15, 5, 5, 15, 
        };*/
}
