/**
 * ***************************************************************
 * 
 * SLCodec.java  fournit un codec pour le SL
 * GNU Lesser General Public License
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation,
 * version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 * **************************************************************
 */package madkit.fipa.sl;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;

import madkit.fipa.abs.AbsContentElementList;
import madkit.fipa.sl.lexer.Lexer;
import madkit.fipa.sl.node.Start;
import madkit.fipa.sl.parser.Parser;

public class SLCodec
{
	
	
	public SLCodec(){}
	
	public AbsContentElementList decode()
	{
		AbsContentElementList reponse = new AbsContentElementList();
		try
		{
			
			InputStreamReader isr = new InputStreamReader(new FileInputStream("F://cours//esiea//5a//TPED//fipa//exempleSL//amsderegister.sl"));
      		
			
			Parser p = new Parser( new Lexer(new PushbackReader(isr)));
			// Parse the input.
			Start tree = p.parse();
			// Apply the translation.
			tree.apply(new Translation(reponse));
			
			
		}
		catch(Exception e)
		{
			System.out.println(e.getMessage());
		}
		return reponse;
		
	}
}